/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.custom.animal.birds.BirdEntity;

public class BirdAerialWanderGoal
extends Goal {
    private final BirdEntity bird;
    private final double speedModifier;
    private int cooldownTicks;
    private static final int START_COOLDOWN_TICKS = 5;
    private static final double ALTITUDE_VARIANCE = 2.0;
    private static final int WANDER_INTERVAL_BASE = 60;
    private static final int WANDER_INTERVAL_RANDOM = 40;
    private int wanderTimer;
    private Vec3 currentTarget;
    private final RandomSource random;
    private static final double MIN_WANDER_DISTANCE = 8.0;
    private static final double MAX_WANDER_DISTANCE = 16.0;
    private static final double TARGET_REACHED_DISTANCE = 2.5;

    public BirdAerialWanderGoal(BirdEntity bird, double speedModifier) {
        this.bird = bird;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.cooldownTicks = 0;
        this.wanderTimer = 0;
        this.random = bird.getRandom();
    }

    public boolean canUse() {
        return this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING && this.bird.hasCompletedInitialAscent && this.bird.getTarget() == null && this.bird.isAlive();
    }

    public boolean canContinueToUse() {
        return this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING && this.bird.isAlive() && this.bird.getTarget() == null;
    }

    public void start() {
        this.cooldownTicks = 5;
        this.wanderTimer = 0;
        this.currentTarget = null;
    }

    public void stop() {
        this.currentTarget = null;
        this.wanderTimer = 0;
        this.bird.getNavigation().stop();
    }

    public void tick() {
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
            this.bird.getNavigation().stop();
            return;
        }
        boolean needNewTarget = false;
        if (this.currentTarget == null) {
            needNewTarget = true;
        } else if (this.wanderTimer-- <= 0) {
            needNewTarget = true;
        } else if (this.bird.distanceToSqr(this.currentTarget) < 6.25) {
            needNewTarget = true;
        }
        if (needNewTarget) {
            this.generateNewWanderTarget();
        } else if (this.currentTarget != null) {
            this.bird.getLookControl().setLookAt(this.currentTarget.x, this.currentTarget.y, this.currentTarget.z, (float)this.bird.getMaxHeadYRot(), (float)this.bird.getMaxHeadXRot());
        }
    }

    private void generateNewWanderTarget() {
        double baseY = this.bird.getY();
        double y = baseY + (this.random.nextDouble() * 2.0 - 1.0) * 2.0;
        double angle = this.random.nextDouble() * 2.0 * Math.PI;
        double distance = 8.0 + this.random.nextDouble() * 8.0;
        double x = this.bird.getX() + Math.cos(angle) * distance;
        double z = this.bird.getZ() + Math.sin(angle) * distance;
        this.currentTarget = new Vec3(x, y, z);
        this.bird.getNavigation().moveTo(x, y, z, this.speedModifier);
        this.wanderTimer = 60 + this.random.nextInt(40);
    }
}

