/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.custom.animal.birds.BirdEntity;

public class BirdFlightGoal
extends Goal {
    protected final BirdEntity bird;
    protected final double speedModifier;
    private final RandomSource random;
    private FlightPhase currentPhase = FlightPhase.TAKEOFF_DETECTION;
    private int flightCooldown;
    private final int baseCooldownTicks = 400;
    private final int randomCooldownAddition = 200;
    private int playerScanCooldown;
    private static final int PLAYER_SCAN_INTERVAL = 30;
    private static final double PLAYER_DETECTION_RANGE = 6.0;
    private boolean triggeredByPlayer = false;
    private Vec3 takeOffTargetPos;
    private boolean reachedTakeOffAltitude;
    private static final double FORWARD_ASCENT_POWER = 0.5;
    private static final double INITIAL_UPWARD_PUSH = 0.2;
    private int cooldownTicks;
    private static final int START_COOLDOWN_TICKS = 5;
    private static final double ALTITUDE_VARIANCE = 2.0;
    private static final int WANDER_INTERVAL_BASE = 60;
    private static final int WANDER_INTERVAL_RANDOM = 40;
    private int wanderTimer;
    private Vec3 currentWanderTarget;
    private static final double MIN_WANDER_DISTANCE = 8.0;
    private static final double MAX_WANDER_DISTANCE = 16.0;
    private static final double TARGET_REACHED_DISTANCE = 2.5;

    public BirdFlightGoal(BirdEntity bird, double speed, double minYIncrease, double maxYIncrease) {
        this.bird = bird;
        this.speedModifier = speed;
        this.random = bird.getRandom();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.flightCooldown = this.baseCooldownTicks + this.random.nextInt(this.randomCooldownAddition + 1);
        this.playerScanCooldown = this.random.nextInt(30);
        this.reachedTakeOffAltitude = false;
        this.cooldownTicks = 0;
        this.wanderTimer = 0;
        this.currentWanderTarget = null;
    }

    public boolean canUse() {
        if (!this.bird.onGround() || this.bird.isInWater() || this.bird.isVehicle() || this.bird.getTarget() != null || this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING) {
            return false;
        }
        if (this.currentPhase != FlightPhase.TAKEOFF_DETECTION) {
            return false;
        }
        if (this.playerScanCooldown <= 0) {
            this.playerScanCooldown = 30;
            Player nearestPlayer = this.bird.level().getNearestPlayer(this.bird.getX(), this.bird.getY(), this.bird.getZ(), 6.0, false);
            if (nearestPlayer != null && !nearestPlayer.isCreative() && !nearestPlayer.isSpectator()) {
                this.triggeredByPlayer = true;
                return true;
            }
        } else {
            --this.playerScanCooldown;
        }
        if (this.flightCooldown > 0) {
            --this.flightCooldown;
            return false;
        }
        this.triggeredByPlayer = false;
        return true;
    }

    public boolean canContinueToUse() {
        return this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING && this.bird.isAlive() && this.bird.getTarget() == null;
    }

    public void start() {
        this.currentPhase = FlightPhase.ASCENDING;
        this.bird.setCurrentFlightMode(BirdEntity.FlightMode.FLYING);
        this.bird.getNavigation().stop();
        BlockPos currentBlockPos = this.bird.blockPosition();
        Vec3 lookVector = this.bird.getLookAngle().normalize();
        double targetY = (double)currentBlockPos.getY() + this.bird.getConfigurableAscentHeight();
        double conceptualForwardDistance = 3.0;
        double targetX = this.bird.getX() + lookVector.x * conceptualForwardDistance;
        double targetZ = this.bird.getZ() + lookVector.z * conceptualForwardDistance;
        this.takeOffTargetPos = new Vec3(targetX, targetY, targetZ);
        this.reachedTakeOffAltitude = false;
        this.bird.getNavigation().moveTo(this.takeOffTargetPos.x, this.takeOffTargetPos.y, this.takeOffTargetPos.z, this.speedModifier);
        this.bird.setDeltaMovement(lookVector.x * 0.5, 0.2, lookVector.z * 0.5);
        this.bird.triggerHurtMarkedForSync();
        this.flightCooldown = this.triggeredByPlayer ? this.baseCooldownTicks / 2 : this.baseCooldownTicks + this.random.nextInt(this.randomCooldownAddition + 1);
    }

    public void stop() {
        this.currentPhase = FlightPhase.TAKEOFF_DETECTION;
        this.bird.getNavigation().stop();
        this.takeOffTargetPos = null;
        this.reachedTakeOffAltitude = false;
        this.currentWanderTarget = null;
        this.wanderTimer = 0;
        this.cooldownTicks = 0;
        if (!this.reachedTakeOffAltitude && this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING) {
            this.bird.setCurrentFlightMode(BirdEntity.FlightMode.GROUNDED);
        }
    }

    public void tick() {
        switch (this.currentPhase.ordinal()) {
            case 1: {
                this.tickAscentPhase();
                break;
            }
            case 2: {
                this.tickAerialWanderingPhase();
                break;
            }
        }
    }

    private void tickAscentPhase() {
        if (this.takeOffTargetPos == null) {
            this.reachedTakeOffAltitude = true;
            return;
        }
        this.bird.getLookControl().setLookAt(this.takeOffTargetPos.x, this.takeOffTargetPos.y, this.takeOffTargetPos.z, (float)this.bird.getMaxHeadYRot(), (float)this.bird.getMaxHeadXRot());
        if (this.bird.getY() >= this.takeOffTargetPos.y() - 0.5) {
            this.reachedTakeOffAltitude = true;
            this.bird.hasCompletedInitialAscent = true;
            this.currentPhase = FlightPhase.AERIAL_WANDERING;
            this.cooldownTicks = 5;
            this.wanderTimer = 0;
            this.currentWanderTarget = null;
        } else if (this.bird.getNavigation().isDone()) {
            this.bird.getNavigation().moveTo(this.takeOffTargetPos.x, this.takeOffTargetPos.y, this.takeOffTargetPos.z, this.speedModifier);
        }
    }

    private void tickAerialWanderingPhase() {
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
            this.bird.getNavigation().stop();
            return;
        }
        boolean needNewTarget = false;
        if (this.currentWanderTarget == null) {
            needNewTarget = true;
        } else if (this.wanderTimer-- <= 0) {
            needNewTarget = true;
        } else if (this.bird.distanceToSqr(this.currentWanderTarget) < 6.25) {
            needNewTarget = true;
        }
        if (needNewTarget) {
            this.generateNewWanderTarget();
        } else if (this.currentWanderTarget != null) {
            this.bird.getLookControl().setLookAt(this.currentWanderTarget.x, this.currentWanderTarget.y, this.currentWanderTarget.z, (float)this.bird.getMaxHeadYRot(), (float)this.bird.getMaxHeadXRot());
        }
    }

    private void generateNewWanderTarget() {
        double baseY = this.bird.getY();
        double y = baseY + (this.random.nextDouble() * 2.0 - 1.0) * 2.0;
        double angle = this.random.nextDouble() * 2.0 * Math.PI;
        double distance = 8.0 + this.random.nextDouble() * 8.0;
        double x = this.bird.getX() + Math.cos(angle) * distance;
        double z = this.bird.getZ() + Math.sin(angle) * distance;
        this.currentWanderTarget = new Vec3(x, y, z);
        this.bird.getNavigation().moveTo(x, y, z, this.speedModifier);
        this.wanderTimer = 60 + this.random.nextInt(40);
    }

    private static enum FlightPhase {
        TAKEOFF_DETECTION,
        ASCENDING,
        AERIAL_WANDERING;

    }
}

