/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.custom.animal.birds.BirdEntity;

public class BirdLandingGoal
extends Goal {
    private final BirdEntity bird;
    private final double speedModifier;
    private int flightDurationTicks;
    private static final int MIN_FLIGHT_DURATION = 100;
    private static final int MAX_FLIGHT_DURATION = 300;
    private final int targetFlightDuration;
    private Vec3 landingTarget;
    private boolean isLanding;
    private static final double LANDING_SEARCH_RADIUS = 20.0;
    private static final double LANDING_HEIGHT_TOLERANCE = 1.0;
    private final RandomSource random;

    public BirdLandingGoal(BirdEntity bird, double speedModifier) {
        this.bird = bird;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.random = bird.getRandom();
        this.targetFlightDuration = 100 + this.random.nextInt(200);
        this.flightDurationTicks = 0;
        this.isLanding = false;
    }

    public boolean canUse() {
        if (this.bird.getCurrentFlightMode() != BirdEntity.FlightMode.FLYING || !this.bird.hasCompletedInitialAscent || this.bird.getTarget() != null) {
            return false;
        }
        ++this.flightDurationTicks;
        return this.flightDurationTicks >= this.targetFlightDuration;
    }

    public boolean canContinueToUse() {
        return this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING && this.bird.isAlive() && this.bird.getTarget() == null && !this.bird.onGround();
    }

    public void start() {
        this.isLanding = true;
        this.landingTarget = this.findLandingSpot();
        if (this.landingTarget != null) {
            this.bird.getNavigation().moveTo(this.landingTarget.x, this.landingTarget.y, this.landingTarget.z, this.speedModifier);
        }
    }

    public void stop() {
        if (this.bird.onGround() || this.bird.getY() <= this.landingTarget.y + 1.0) {
            this.bird.setCurrentFlightMode(BirdEntity.FlightMode.GROUNDED);
        }
        this.isLanding = false;
        this.landingTarget = null;
        this.flightDurationTicks = 0;
        this.bird.getNavigation().stop();
    }

    public void tick() {
        if (this.landingTarget == null) {
            this.landingTarget = this.findLandingSpot();
            if (this.landingTarget != null) {
                this.bird.getNavigation().moveTo(this.landingTarget.x, this.landingTarget.y, this.landingTarget.z, this.speedModifier);
            }
            return;
        }
        this.bird.getLookControl().setLookAt(this.landingTarget.x, this.landingTarget.y, this.landingTarget.z, (float)this.bird.getMaxHeadYRot(), (float)this.bird.getMaxHeadXRot());
        double distanceToLanding = this.bird.distanceToSqr(this.landingTarget);
        if (distanceToLanding < 4.0 || this.bird.getY() <= this.landingTarget.y + 1.0) {
            this.bird.setNoGravity(false);
            if (this.bird.onGround()) {
                this.bird.setCurrentFlightMode(BirdEntity.FlightMode.GROUNDED);
            }
        } else if (this.bird.getNavigation().isDone()) {
            this.bird.getNavigation().moveTo(this.landingTarget.x, this.landingTarget.y, this.landingTarget.z, this.speedModifier);
        }
    }

    private Vec3 findLandingSpot() {
        BlockPos birdPos = this.bird.blockPosition();
        for (int attempts = 0; attempts < 10; ++attempts) {
            int targetZ;
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            double distance = this.random.nextDouble() * 20.0;
            int targetX = (int)((double)birdPos.getX() + Math.cos(angle) * distance);
            BlockPos groundPos = this.findGroundLevel(targetX, targetZ = (int)((double)birdPos.getZ() + Math.sin(angle) * distance));
            if (groundPos == null) continue;
            return Vec3.atBottomCenterOf((Vec3i)groundPos.above());
        }
        BlockPos fallbackGround = this.findGroundLevel(birdPos.getX(), birdPos.getZ());
        if (fallbackGround != null) {
            return Vec3.atBottomCenterOf((Vec3i)fallbackGround.above());
        }
        return new Vec3(this.bird.getX(), this.bird.getY() - 10.0, this.bird.getZ());
    }

    private BlockPos findGroundLevel(int x, int z) {
        int startY = Math.max(this.bird.blockPosition().getY(), this.bird.level().getMaxBuildHeight() - 1);
        int minY = this.bird.level().getMinBuildHeight();
        for (int y = startY; y >= minY; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = this.bird.level().getBlockState(pos);
            BlockState above = this.bird.level().getBlockState(pos.above());
            if (state.isAir() || !state.isSolid() || !above.isAir()) continue;
            return pos;
        }
        return null;
    }
}

