/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.custom.animal.birds.BirdEntity;

public class BirdTakeOffAndFlyGoal
extends Goal {
    protected final BirdEntity bird;
    protected final double speedModifier;
    private int flightCooldown;
    private final int baseCooldownTicks = 400;
    private final int randomCooldownAddition = 200;
    private int playerScanCooldown;
    private static final int PLAYER_SCAN_INTERVAL = 30;
    private static final double PLAYER_DETECTION_RANGE = 6.0;
    private boolean triggeredByPlayer = false;
    private Vec3 takeOffTargetPos;
    private boolean reachedTakeOffAltitude;
    private static final double ASCENT_HEIGHT = 15.0;
    private static final double FORWARD_ASCENT_POWER = 0.5;

    public BirdTakeOffAndFlyGoal(BirdEntity bird, double speed, double minYIncrease, double maxYIncrease) {
        this.bird = bird;
        this.speedModifier = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.flightCooldown = this.baseCooldownTicks + this.bird.getRandom().nextInt(this.randomCooldownAddition + 1);
        this.playerScanCooldown = this.bird.getRandom().nextInt(30);
    }

    public boolean canUse() {
        if (!this.bird.onGround() || this.bird.isInWater() || this.bird.isVehicle() || this.bird.getTarget() != null || this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING) {
            return false;
        }
        if (this.playerScanCooldown <= 0) {
            this.playerScanCooldown = 30;
            Player nearestPlayer = this.bird.level().getNearestPlayer(this.bird.getX(), this.bird.getY(), this.bird.getZ(), 6.0, false);
            if (nearestPlayer != null && !nearestPlayer.isCreative() && !nearestPlayer.isSpectator()) {
                this.triggeredByPlayer = true;
                return true;
            }
        } else {
            --this.playerScanCooldown;
        }
        if (this.flightCooldown > 0) {
            --this.flightCooldown;
            return false;
        }
        this.triggeredByPlayer = false;
        return true;
    }

    public void start() {
        this.bird.setCurrentFlightMode(BirdEntity.FlightMode.FLYING);
        this.bird.getNavigation().stop();
        BlockPos currentBlockPos = this.bird.blockPosition();
        Vec3 lookVector = this.bird.getLookAngle().normalize();
        double targetY = (double)currentBlockPos.getY() + 15.0;
        double conceptualForwardDistance = 3.0;
        double targetX = this.bird.getX() + lookVector.x * conceptualForwardDistance;
        double targetZ = this.bird.getZ() + lookVector.z * conceptualForwardDistance;
        this.takeOffTargetPos = new Vec3(targetX, targetY, targetZ);
        this.reachedTakeOffAltitude = false;
        this.bird.getNavigation().moveTo(this.takeOffTargetPos.x, this.takeOffTargetPos.y, this.takeOffTargetPos.z, this.speedModifier);
        double initialUpwardPush = 0.2;
        this.bird.setDeltaMovement(lookVector.x * 0.5, initialUpwardPush, lookVector.z * 0.5);
        this.bird.triggerHurtMarkedForSync();
        this.flightCooldown = this.triggeredByPlayer ? this.baseCooldownTicks / 2 : this.baseCooldownTicks + this.bird.getRandom().nextInt(this.randomCooldownAddition + 1);
    }

    public boolean canContinueToUse() {
        return !this.reachedTakeOffAltitude && this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING && this.bird.getTarget() == null && this.bird.isAlive();
    }

    public void tick() {
        if (this.takeOffTargetPos == null) {
            this.reachedTakeOffAltitude = true;
            return;
        }
        this.bird.getLookControl().setLookAt(this.takeOffTargetPos.x, this.takeOffTargetPos.y, this.takeOffTargetPos.z, (float)this.bird.getMaxHeadYRot(), (float)this.bird.getMaxHeadXRot());
        if (this.bird.getY() >= this.takeOffTargetPos.y() - 0.5) {
            this.reachedTakeOffAltitude = true;
            this.bird.hasCompletedInitialAscent = true;
        } else if (this.bird.getNavigation().isDone()) {
            this.bird.getNavigation().moveTo(this.takeOffTargetPos.x, this.takeOffTargetPos.y, this.takeOffTargetPos.z, this.speedModifier);
        }
    }

    public void stop() {
        this.bird.getNavigation().stop();
        if (!this.reachedTakeOffAltitude && this.bird.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING) {
            this.bird.setCurrentFlightMode(BirdEntity.FlightMode.GROUNDED);
        }
        this.takeOffTargetPos = null;
        this.reachedTakeOffAltitude = false;
    }
}

