/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.block.entity.custom.HilichurlCampfireBlockEntity;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class CookRawFoodGoal<T extends GenshinEntity>
extends Goal {
    protected final T mob;
    private final double speedModifier;
    private final double searchRadiusCampfire = 16.0;
    private final double interactionDistanceSq = 6.25;
    @Nullable
    private BlockPos targetCampfirePos;
    private boolean hasReachedCampfire;
    private boolean hasPlacedFood;

    public CookRawFoodGoal(T mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        ItemStack itemInHand = this.mob.getMainHandItem();
        if (itemInHand.isEmpty() || !GenshinEntity.COOKABLE_RAW_MEATS.contains(itemInHand.getItem())) {
            return false;
        }
        if (this.mob.getTarget() != null && !(this.mob.getTarget() instanceof Animal) && (this.mob.getTarget() instanceof Player || this.mob.getTarget() instanceof Monster)) {
            return false;
        }
        this.targetCampfirePos = this.findNearbyLitCampfire();
        return this.targetCampfirePos != null;
    }

    public boolean canContinueToUse() {
        boolean isLit;
        if (this.hasPlacedFood) {
            return false;
        }
        if (this.targetCampfirePos == null) {
            return false;
        }
        if (this.mob.getMainHandItem().isEmpty() || !GenshinEntity.COOKABLE_RAW_MEATS.contains(this.mob.getMainHandItem().getItem())) {
            return false;
        }
        BlockState campfireState = this.mob.level().getBlockState(this.targetCampfirePos);
        boolean isRecognizedType = campfireState.is(Blocks.CAMPFIRE) || campfireState.is(ModBlocks.HILICHURL_CAMPFIRE.get());
        boolean bl = isLit = campfireState.hasProperty((Property)CampfireBlock.LIT) && (Boolean)campfireState.getValue((Property)CampfireBlock.LIT) != false;
        if (!isRecognizedType || !isLit) {
            return false;
        }
        return this.mob.getTarget() == null || this.mob.getTarget() instanceof Animal || !(this.mob.getTarget() instanceof Player) && !(this.mob.getTarget() instanceof Monster);
    }

    public void start() {
        this.hasReachedCampfire = false;
        this.hasPlacedFood = false;
        ((GenshinEntity)((Object)this.mob)).isAttemptingToCook = true;
        ((GenshinEntity)((Object)this.mob)).ticksSinceLastAte = 0;
        this.mob.getNavigation().moveTo((double)this.targetCampfirePos.getX() + 0.5, (double)this.targetCampfirePos.getY(), (double)this.targetCampfirePos.getZ() + 0.5, this.speedModifier);
    }

    public void stop() {
        ((GenshinEntity)((Object)this.mob)).isAttemptingToCook = false;
        this.mob.getNavigation().stop();
        this.targetCampfirePos = null;
    }

    public void tick() {
        ((GenshinEntity)((Object)this.mob)).ticksSinceLastAte = 0;
        if (this.targetCampfirePos == null) {
            this.stop();
            return;
        }
        this.mob.getLookControl().setLookAt((double)this.targetCampfirePos.getX() + 0.5, (double)this.targetCampfirePos.getY() + 0.5, (double)this.targetCampfirePos.getZ() + 0.5, 10.0f, (float)this.mob.getMaxHeadXRot());
        if (!this.hasReachedCampfire && (this.mob.getNavigation().isDone() || this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetCampfirePos)) < 6.25)) {
            this.hasReachedCampfire = true;
        }
        if (this.hasReachedCampfire && !this.hasPlacedFood) {
            this.placeFoodOnCampfire();
            this.hasPlacedFood = true;
        }
    }

    private void placeFoodOnCampfire() {
        if (this.targetCampfirePos == null || this.mob.level().isClientSide()) {
            return;
        }
        ItemStack rawFoodInHand = this.mob.getMainHandItem();
        if (rawFoodInHand.isEmpty() || !GenshinEntity.COOKABLE_RAW_MEATS.contains(rawFoodInHand.getItem())) {
            this.hasPlacedFood = true;
            return;
        }
        BlockEntity blockEntity = this.mob.level().getBlockEntity(this.targetCampfirePos);
        if (blockEntity instanceof HilichurlCampfireBlockEntity) {
            HilichurlCampfireBlockEntity hilichurlCampfireBE = (HilichurlCampfireBlockEntity)blockEntity;
            Optional<RecipeHolder<CampfireCookingRecipe>> recipeHolderOpt = hilichurlCampfireBE.getCookableRecipe(rawFoodInHand);
            if (recipeHolderOpt.isPresent()) {
                CampfireCookingRecipe actualRecipe = (CampfireCookingRecipe)recipeHolderOpt.get().value();
                int cookingTime = actualRecipe.getCookingTime();
                ItemStack itemToPlace = rawFoodInHand.copyWithCount(1);
                boolean success = hilichurlCampfireBE.placeFood((LivingEntity)this.mob, itemToPlace, cookingTime);
                if (success) {
                    rawFoodInHand.shrink(1);
                    this.mob.level().playSound(null, this.targetCampfirePos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.7f, 1.0f + this.mob.getRandom().nextFloat() * 0.4f);
                    this.hasPlacedFood = true;
                } else {
                    this.hasPlacedFood = true;
                }
            } else {
                this.hasPlacedFood = true;
            }
        } else {
            this.hasPlacedFood = true;
        }
    }

    @Nullable
    private BlockPos findNearbyLitCampfire() {
        return BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)16, (int)8, pos -> {
            BlockState blockState = this.mob.level().getBlockState(pos);
            boolean isRecognizedCampfire = blockState.is(Blocks.CAMPFIRE) || blockState.is(ModBlocks.HILICHURL_CAMPFIRE.get());
            return isRecognizedCampfire && blockState.hasProperty((Property)CampfireBlock.LIT) && (Boolean)blockState.getValue((Property)CampfireBlock.LIT) != false;
        }).orElse(null);
    }
}

