/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.zenith.hoyocraft.entity.custom.elemental.slime.DendroSlimeEntity;

public class CustomFirePanicGoal
extends PanicGoal {
    private final DendroSlimeEntity dendroSlime;

    public CustomFirePanicGoal(DendroSlimeEntity mob, double speedModifier) {
        super((PathfinderMob)mob, speedModifier);
        this.dendroSlime = mob;
    }

    public boolean canUse() {
        if (!this.dendroSlime.isOnFire()) {
            return false;
        }
        return this.findRandomPosition();
    }

    public boolean canContinueToUse() {
        if (!this.dendroSlime.isOnFire()) {
            return false;
        }
        boolean canSuperContinue = super.canContinueToUse();
        return canSuperContinue;
    }

    public void start() {
        super.start();
        this.dendroSlime.playAnimation("dendro_slime.animation.panic");
        System.out.println("[CustomFirePanicGoal] Started for " + this.dendroSlime.getId() + ". Playing 'dendro_slime.animation.panic'.");
        if (this.mob.getNavigation().getPath() != null) {
            System.out.println("    Path target: " + this.mob.getNavigation().getPath().getTarget().toString());
        } else {
            System.out.println("    Path is NULL after super.start() - This means findRandomPosition likely failed or was overridden.");
        }
    }

    public void stop() {
        super.stop();
        if ("dendro_slime.animation.panic".equals(this.dendroSlime.getCurrentActionAnimationName())) {
            this.dendroSlime.stopCurrentActionAnimation();
        }
    }
}

