/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.custom.elemental.slime.DendroSlimeEntity;

public class DendroSlimeUndergroundBehaviorGoal
extends Goal {
    private final DendroSlimeEntity slime;
    private LivingEntity target;
    private final IGenshinAction hitHideAction;
    private boolean isPerformingHitHide;
    private int hitHideActionTickCounter;
    private int peekCooldownTicks;
    private int currentPeekDurationTicks;
    private int undergroundMoveTicksLeft;
    private static final int UNDERGROUND_MOVE_DURATION = 15;
    private static final int PEEK_ANIMATION_DURATION = 25;
    private static final int PEEK_COOLDOWN_MAX = 10;
    private StartledPhase currentStartledPhase;
    private int startledPhaseTimer;
    private boolean backwardJumpAppliedThisStartle;
    private static final int STARTLED_SURFACE_ANIM_TOTAL_DURATION = 12;
    private static final int STARTLED_BACKWARD_JUMP_TRIGGER_TICK = 5;
    private static final int STARTLED_RUN_AWAY_DURATION = 30;
    private static final int STARTLED_RUN_AWAY_SEGMENT_MAX_DIST = 16;
    private static final int STARTLED_RUN_AWAY_SEGMENT_VERTICAL_DIST = 7;
    private static final double STARTLED_BACKWARD_JUMP_H_STRENGTH = 0.8;
    private static final double STARTLED_BACKWARD_JUMP_V_STRENGTH = 0.5;
    private static final double STARTLED_RUN_AWAY_SPEED = 4.0;

    public DendroSlimeUndergroundBehaviorGoal(DendroSlimeEntity slime) {
        this.slime = slime;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.peekCooldownTicks = 0;
        this.currentPeekDurationTicks = 0;
        this.undergroundMoveTicksLeft = 0;
        this.hitHideAction = DendroSlimeEntity.createActualDendroSlimeHitHideAction();
        this.isPerformingHitHide = false;
        this.hitHideActionTickCounter = 0;
    }

    public boolean canUse() {
        if (!this.slime.isUnderground() || this.slime.hasLostUndergroundAI()) {
            return false;
        }
        LivingEntity currentTarget = this.slime.getTarget();
        if (currentTarget == null || !currentTarget.isAlive()) {
            return false;
        }
        if (this.isPerformingHitHide) {
            return false;
        }
        this.target = currentTarget;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.isPerformingHitHide) {
            return this.hitHideActionTickCounter < this.hitHideAction.getCooldown();
        }
        if (this.slime.isStartled()) {
            return !this.slime.hasLostUndergroundAI();
        }
        return this.target != null && this.target.isAlive() && this.slime.isUnderground() && !this.slime.hasLostUndergroundAI();
    }

    public void start() {
        this.slime.getNavigation().stop();
        this.currentPeekDurationTicks = 0;
        this.undergroundMoveTicksLeft = 0;
        this.slime.setMovingUnderground(false);
        this.isPerformingHitHide = false;
        this.hitHideActionTickCounter = 0;
        this.currentStartledPhase = null;
        this.startledPhaseTimer = 0;
        this.backwardJumpAppliedThisStartle = false;
    }

    public void stop() {
        if (this.isPerformingHitHide) {
            this.hitHideAction.stop(this.slime);
            this.isPerformingHitHide = false;
            this.hitHideActionTickCounter = 0;
        }
        if (this.slime.isAttackingGeckoLib()) {
            String currentAnim = this.slime.getCurrentActionAnimationName();
            if ("dendro_slime.animation.peek".equals(currentAnim)) {
                this.slime.stopCurrentActionAnimation();
            }
            if (this.slime.isMovingUnderground() && "dendro_slime.animation.undergroundidle".equals(currentAnim)) {
                this.slime.stopCurrentActionAnimation();
            }
        }
        this.slime.setMovingUnderground(false);
        this.target = null;
        this.currentPeekDurationTicks = 0;
        this.undergroundMoveTicksLeft = 0;
        if (this.slime.isStartled()) {
            this.slime.setStartled(false);
            this.slime.stopCurrentActionAnimation();
        } else if (this.slime.isUnderground() && !this.slime.hasLostUndergroundAI()) {
            System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Stop(): Goal stopping normally, was underground. Forcing surface. Tick: " + this.slime.tickCount);
            this.slime.setUnderground(false);
            if ("dendro_slime.animation.undergroundidle".equals(this.slime.getCurrentActionAnimationName())) {
                this.slime.stopCurrentActionAnimation();
            }
        }
        this.currentStartledPhase = null;
        this.startledPhaseTimer = 0;
        this.backwardJumpAppliedThisStartle = false;
    }

    public void tick() {
        this.target = this.slime.getTarget();
        if (this.slime.isStartled() && this.currentStartledPhase == null && !this.isPerformingHitHide) {
            System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Tick: Detected isStartled() == true and currentStartledPhase == null. Initializing startled sequence. Target: " + (this.target != null && this.target.isAlive() ? this.target.getName().getString() : "null/dead") + ". Tick: " + this.slime.tickCount);
            if (this.slime.isUnderground()) {
                this.slime.setUnderground(false);
            }
            this.currentStartledPhase = StartledPhase.SURFACING_ANIM;
            this.startledPhaseTimer = 0;
            this.backwardJumpAppliedThisStartle = false;
            this.peekCooldownTicks = 10;
            this.slime.getNavigation().stop();
        }
        if (this.isPerformingHitHide) {
            boolean actionShouldStopThisTick = false;
            String stopReason = "";
            if ((this.target == null || !this.target.isAlive()) && this.hitHideAction.requiresImmediateFinish()) {
                actionShouldStopThisTick = true;
                stopReason = "Target lost during HitHide and action requires immediate finish.";
            }
            if (!actionShouldStopThisTick && this.hitHideActionTickCounter >= this.hitHideAction.getCooldown()) {
                actionShouldStopThisTick = true;
                stopReason = "HitHide action finished by duration.";
            }
            if (actionShouldStopThisTick) {
                System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Stopping HitHide. Reason: " + stopReason + ". Tick: " + this.slime.tickCount);
                this.hitHideAction.stop(this.slime);
                this.isPerformingHitHide = false;
                this.hitHideActionTickCounter = 0;
                this.peekCooldownTicks = 10;
                return;
            }
            this.hitHideAction.perform(this.slime, this.target);
            ++this.hitHideActionTickCounter;
            return;
        }
        if (!(this.target != null && this.target.isAlive() || this.currentStartledPhase != null && this.currentStartledPhase != StartledPhase.SURFACING_ANIM)) {
            System.out.println("[DendroSlimeGoal DEBUG " + this.slime.getId() + "] Tick: Target is null or dead. CurrentStartledPhase: " + String.valueOf((Object)this.currentStartledPhase) + ". Goal tick returning. Tick: " + this.slime.tickCount);
            if (this.slime.isStartled() && this.currentStartledPhase == StartledPhase.SURFACING_ANIM) {
                this.slime.setStartled(false);
                this.currentStartledPhase = null;
                this.slime.stopCurrentActionAnimation();
            }
            return;
        }
        if (this.target != null && this.target.isAlive() && (this.currentStartledPhase == null || this.currentStartledPhase == StartledPhase.SURFACING_ANIM || this.currentStartledPhase == StartledPhase.BACKWARD_JUMPING)) {
            this.slime.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.slime.getMaxHeadXRot());
        }
        if (this.slime.isStartled() && this.currentStartledPhase != null) {
            if (!(this.target != null && this.target.isAlive() || this.currentStartledPhase != StartledPhase.SURFACING_ANIM)) {
                System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled (SURFACING_ANIM), but target lost. Resetting startled. Tick: " + this.slime.tickCount);
                this.slime.setStartled(false);
                this.slime.setMovingUnderground(false);
                this.slime.stopCurrentActionAnimation();
                this.currentStartledPhase = null;
                this.startledPhaseTimer = 0;
                this.backwardJumpAppliedThisStartle = false;
                this.peekCooldownTicks = 10;
                return;
            }
            ++this.startledPhaseTimer;
            switch (this.currentStartledPhase.ordinal()) {
                case 0: {
                    Vec3 fallbackPos;
                    if (!this.backwardJumpAppliedThisStartle && this.startledPhaseTimer >= 5) {
                        System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled: Applying backward jump.");
                        if (this.target != null && this.target.isAlive()) {
                            Vec3 directionAwayFromTarget = this.slime.position().subtract(this.target.position()).normalize();
                            if (directionAwayFromTarget.y < 0.1 && directionAwayFromTarget.y > -0.1 && (directionAwayFromTarget.x != 0.0 || directionAwayFromTarget.z != 0.0)) {
                                directionAwayFromTarget = new Vec3(directionAwayFromTarget.x, 0.2, directionAwayFromTarget.z).normalize();
                            } else if (directionAwayFromTarget.x == 0.0 && directionAwayFromTarget.z == 0.0) {
                                directionAwayFromTarget = this.slime.getLookAngle().scale(-1.0).add(0.0, 0.2, 0.0).normalize();
                            }
                            this.slime.setDeltaMovement(directionAwayFromTarget.x * 0.8, 0.5, directionAwayFromTarget.z * 0.8);
                            this.slime.triggerHurtMarkedForSync();
                        } else {
                            System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled: Wanted to jump, but target is null/dead for direction.");
                        }
                        this.backwardJumpAppliedThisStartle = true;
                    }
                    if (this.startledPhaseTimer < 12) break;
                    System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled: Surface animation finished. Transitioning to RUNNING_AWAY_UNDERGROUND.");
                    this.slime.stopCurrentActionAnimation();
                    this.currentStartledPhase = StartledPhase.RUNNING_AWAY_UNDERGROUND;
                    this.startledPhaseTimer = 0;
                    this.slime.setUnderground(true);
                    this.slime.setMovingUnderground(true);
                    Vec3 initialAwayPos = null;
                    if (this.target != null && this.target.isAlive()) {
                        initialAwayPos = DefaultRandomPos.getPosAway((PathfinderMob)this.slime, (int)16, (int)7, (Vec3)this.target.position());
                    }
                    if (initialAwayPos != null) {
                        this.slime.getNavigation().moveTo(initialAwayPos.x, initialAwayPos.y, initialAwayPos.z, 4.0);
                        System.out.println("    Initial flee path set towards: " + String.valueOf(initialAwayPos));
                        break;
                    }
                    Vec3 directionAwayFromLook = this.slime.getLookAngle().scale(-1.0).normalize();
                    if (this.target != null && this.target.isAlive()) {
                        directionAwayFromLook = this.slime.position().subtract(this.target.position()).normalize();
                    }
                    if ((fallbackPos = DefaultRandomPos.getPosTowards((PathfinderMob)this.slime, (int)8, (int)7, (Vec3)this.slime.position().add(directionAwayFromLook.scale(8.0)), (double)1.5707963267948966)) != null) {
                        this.slime.getNavigation().moveTo(fallbackPos.x, fallbackPos.y, fallbackPos.z, 4.0);
                        System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled: RUNNING_AWAY_UNDERGROUND, initial fallback pathing to " + String.valueOf(fallbackPos));
                        break;
                    }
                    System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled: RUNNING_AWAY_UNDERGROUND, failed to find any initial fallback path.");
                    break;
                }
                case 2: {
                    if (this.startledPhaseTimer >= 30) {
                        System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled: Total run away DURATION (30 ticks) reached. Finishing. Timer: " + this.startledPhaseTimer);
                        this.slime.getNavigation().stop();
                        this.slime.setMovingUnderground(false);
                        this.slime.setStartled(false);
                        this.peekCooldownTicks = 10;
                        this.currentStartledPhase = null;
                        this.backwardJumpAppliedThisStartle = false;
                        break;
                    }
                    if (this.slime.getNavigation().isInProgress()) break;
                    System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Startled: Navigation idle during RUNNING_AWAY_UNDERGROUND (timer " + this.startledPhaseTimer + "/30). Attempting to find new flee path.");
                    Vec3 fleePos = null;
                    if (this.target != null && this.target.isAlive()) {
                        fleePos = DefaultRandomPos.getPosAway((PathfinderMob)this.slime, (int)16, (int)7, (Vec3)this.target.position());
                    } else {
                        Vec3 directionAwayFromLook = this.slime.getLookAngle().scale(-1.0).normalize();
                        fleePos = DefaultRandomPos.getPosTowards((PathfinderMob)this.slime, (int)16, (int)7, (Vec3)this.slime.position().add(directionAwayFromLook.scale(16.0)), (double)1.5707963267948966);
                    }
                    if (fleePos != null) {
                        this.slime.getNavigation().moveTo(fleePos.x, fleePos.y, fleePos.z, 4.0);
                        System.out.println("    New flee path set towards: " + String.valueOf(fleePos));
                        break;
                    }
                    System.out.println("    Could not find a new flee path. Slime might stop temporarily if stuck or no path found.");
                }
            }
            return;
        }
        boolean isTargetLookingAtMe = false;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Vec3 directionToSlime;
            Player playerTarget = (Player)livingEntity;
            if (this.slime.hasLineOfSight((Entity)playerTarget) && (playerLook = playerTarget.getLookAngle()).dot(directionToSlime = this.slime.position().subtract(playerTarget.getEyePosition()).normalize()) > 0.5) {
                isTargetLookingAtMe = true;
            }
        } else {
            playerLook = this.target;
            if (playerLook instanceof Mob) {
                Mob mobTarget = (Mob)playerLook;
                if (this.slime.hasLineOfSight((Entity)this.target) && mobTarget.getTarget() == this.slime && mobTarget.hasLineOfSight((Entity)this.slime)) {
                    isTargetLookingAtMe = true;
                }
            }
        }
        if (this.currentPeekDurationTicks > 0) {
            --this.currentPeekDurationTicks;
            if (isTargetLookingAtMe && !this.slime.isStartled()) {
                System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] STARTLED by LoS during peek!");
                this.slime.stopCurrentActionAnimation();
                this.currentPeekDurationTicks = 0;
                this.slime.setStartled(true);
                this.peekCooldownTicks = 10;
                return;
            }
            if (this.currentPeekDurationTicks <= 0) {
                this.slime.stopCurrentActionAnimation();
                this.peekCooldownTicks = 10;
                double distanceSqToTarget = this.slime.distanceToSqr((Entity)this.target);
                double minAttackRangeSq = 0.0;
                double maxAttackRangeSq = 9.0;
                if (distanceSqToTarget >= minAttackRangeSq && distanceSqToTarget <= maxAttackRangeSq && this.slime.hasLineOfSight((Entity)this.target)) {
                    this.isPerformingHitHide = true;
                    this.hitHideAction.start(this.slime);
                    this.hitHideActionTickCounter = 0;
                } else if (this.target != null && this.target.isAlive()) {
                    System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Post-peek: Initiating underground move.");
                    this.slime.setMovingUnderground(true);
                    this.undergroundMoveTicksLeft = 15;
                    this.slime.getNavigation().moveTo((Entity)this.target, 2.65);
                }
            }
            return;
        }
        if (this.slime.isMovingUnderground()) {
            Level level;
            --this.undergroundMoveTicksLeft;
            if (!this.slime.level().isClientSide() && (level = this.slime.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.slime.tickCount % 3 == 0) {
                    serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.slime.getBlockStateOn()), this.slime.getRandomX(0.7), this.slime.getY(), this.slime.getRandomZ(0.7), 5, 0.0, 0.0, 0.0, 0.1);
                }
            }
            if (this.undergroundMoveTicksLeft <= 0 || !this.slime.getNavigation().isInProgress()) {
                this.slime.setMovingUnderground(false);
                this.slime.getNavigation().stop();
            }
            return;
        }
        if (isTargetLookingAtMe) {
            this.slime.getNavigation().stop();
            return;
        }
        if (this.peekCooldownTicks > 0) {
            --this.peekCooldownTicks;
        }
        if (this.peekCooldownTicks <= 0) {
            System.out.println("[DendroSlimeGoal " + this.slime.getId() + "] Peek cooldown over. Initiating peek animation!");
            this.slime.playAnimation("dendro_slime.animation.peek");
            this.currentPeekDurationTicks = 25;
            this.slime.getNavigation().stop();
        } else {
            this.slime.getNavigation().stop();
        }
    }

    private static enum StartledPhase {
        SURFACING_ANIM,
        BACKWARD_JUMPING,
        RUNNING_AWAY_UNDERGROUND;

    }
}

