/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.custom.animal.birds.BirdEntity;
import net.zenith.hoyocraft.entity.custom.animal.birds.finch.FinchEntity;

public class FinchMoveControl
extends MoveControl {
    private final FinchEntity finch;
    private int groundMoveCooldown;
    private static final int MAX_GROUND_MOVE_COOLDOWN_TICKS = 4;
    private boolean hasHoppedThisGroundCycle;
    private static final float FORWARD_HOP_STRENGTH = 0.19f;
    private final int maxTurnAerial;

    public FinchMoveControl(FinchEntity finch, int maxTurnDegrees, boolean allowDownwardFlight) {
        super((Mob)finch);
        this.finch = finch;
        this.maxTurnAerial = maxTurnDegrees;
        this.groundMoveCooldown = 0;
        this.hasHoppedThisGroundCycle = false;
    }

    public void tick() {
        if (this.finch.getCurrentFlightMode() == BirdEntity.FlightMode.FLYING) {
            this.handleFlyingMovement();
        } else {
            this.handleGroundHoppingMovement();
        }
    }

    private void handleGroundHoppingMovement() {
        this.mob.setNoGravity(false);
        if (this.groundMoveCooldown > 0) {
            --this.groundMoveCooldown;
            this.mob.setSpeed(0.0f);
            this.mob.setZza(0.0f);
            this.mob.setXxa(0.0f);
            if (this.mob.onGround()) {
                this.mob.setDeltaMovement(0.0, this.mob.getDeltaMovement().y(), 0.0);
            }
            if (this.groundMoveCooldown == 0) {
                this.hasHoppedThisGroundCycle = false;
            }
            return;
        }
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            double distanceToTargetSqXZ;
            double dX = this.wantedX - this.mob.getX();
            double dZ = this.wantedZ - this.mob.getZ();
            float targetYaw = (float)(Mth.atan2((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), targetYaw, 90.0f));
            this.mob.setYBodyRot(this.mob.getYRot());
            boolean didInitiateHopThisTick = false;
            if (!this.hasHoppedThisGroundCycle && this.mob.onGround()) {
                this.mob.getJumpControl().jump();
                Vec3 lookAngle = Vec3.directionFromRotation((float)0.0f, (float)this.mob.getYRot());
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().x + lookAngle.x * (double)0.19f, this.mob.getDeltaMovement().y, this.mob.getDeltaMovement().z + lookAngle.z * (double)0.19f);
                this.hasHoppedThisGroundCycle = true;
                didInitiateHopThisTick = true;
            }
            this.mob.setSpeed(0.0f);
            this.mob.setZza(0.0f);
            this.mob.setXxa(0.0f);
            if (!didInitiateHopThisTick && this.mob.onGround()) {
                this.mob.setDeltaMovement(0.0, this.mob.getDeltaMovement().y(), 0.0);
            }
            if ((distanceToTargetSqXZ = dX * dX + dZ * dZ) < 0.09 || this.hasHoppedThisGroundCycle && this.mob.onGround() && !didInitiateHopThisTick) {
                this.operation = MoveControl.Operation.WAIT;
                this.groundMoveCooldown = 4;
            }
        } else {
            this.mob.setSpeed(0.0f);
            this.mob.setZza(0.0f);
            this.mob.setXxa(0.0f);
            if (this.mob.onGround()) {
                this.mob.setDeltaMovement(0.0, this.mob.getDeltaMovement().y(), 0.0);
            }
            if (this.groundMoveCooldown == 0 && this.operation == MoveControl.Operation.WAIT) {
                this.groundMoveCooldown = 4;
                this.hasHoppedThisGroundCycle = false;
            }
        }
    }

    private void handleFlyingMovement() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.mob.setNoGravity(true);
            double dX = this.wantedX - this.mob.getX();
            double dY = this.wantedY - this.mob.getY();
            double dZ = this.wantedZ - this.mob.getZ();
            double distToTargetSq = dX * dX + dY * dY + dZ * dZ;
            if (distToTargetSq < 0.010000000000000002) {
                this.operation = MoveControl.Operation.WAIT;
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.5));
                return;
            }
            float targetYaw = (float)(Mth.atan2((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), targetYaw, this.maxTurnAerial));
            this.mob.setYBodyRot(this.mob.getYRot());
            float flySpeed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
            Vec3 direction = new Vec3(dX, dY, dZ).normalize();
            Vec3 targetDelta = direction.scale((double)flySpeed);
            Vec3 currentDelta = this.mob.getDeltaMovement();
            this.mob.setDeltaMovement(currentDelta.x + (targetDelta.x - currentDelta.x) * 0.1, currentDelta.y + (targetDelta.y - currentDelta.y) * 0.1, currentDelta.z + (targetDelta.z - currentDelta.z) * 0.1);
        } else {
            this.mob.setNoGravity(true);
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.95));
            if (this.mob.getDeltaMovement().lengthSqr() < 0.001) {
                this.mob.setDeltaMovement(Vec3.ZERO);
            }
        }
    }
}

