/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.entity.ai.goal.PlaceFenceContributionAction;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class FollowerCampContributionGoal
extends Goal {
    @Nullable
    private BlockPos anchorCampfirePos;
    protected final GenshinEntity follower;
    private int considerationCooldown;
    private static final List<Pair<ICampContributionAction, Double>> POSSIBLE_CONTRIBUTIONS = new ArrayList<Pair<ICampContributionAction, Double>>();
    private static final int CONSIDERATION_COOLDOWN_BASE_TICKS = 7000;
    private static final int CONSIDERATION_COOLDOWN_RANDOM_TICKS = 6000;
    private static final float CHANCE_TO_CONTRIBUTE = 0.5f;
    private static final int CAMP_CHECK_RADIUS = 24;
    private static final List<EntityType<? extends Animal>> SPAWNABLE_ANIMAL_TYPES;

    @Nullable
    public BlockPos getAnchorCampfirePos() {
        return this.anchorCampfirePos;
    }

    public FollowerCampContributionGoal(GenshinEntity follower) {
        this.follower = follower;
        this.considerationCooldown = 100 + follower.getRandom().nextInt(600);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private Optional<BlockPos> findNearbyLitCampfireContext() {
        return GenshinEntity.findClosestLitCampfire((LivingEntity)this.follower, 24.0);
    }

    @Nullable
    private SoundEvent getAmbientSoundForEntityType(EntityType<?> entityType) {
        if (entityType == EntityType.COW) {
            return SoundEvents.COW_AMBIENT;
        }
        if (entityType == EntityType.PIG) {
            return SoundEvents.PIG_AMBIENT;
        }
        if (entityType == EntityType.SHEEP) {
            return SoundEvents.SHEEP_AMBIENT;
        }
        if (entityType == EntityType.CHICKEN) {
            return SoundEvents.CHICKEN_AMBIENT;
        }
        return null;
    }

    public boolean canUse() {
        if (this.considerationCooldown > 0) {
            --this.considerationCooldown;
            return false;
        }
        Runnable resetCooldownAndFail = () -> {
            this.considerationCooldown = 7000 + this.follower.getRandom().nextInt(6000);
            this.anchorCampfirePos = null;
        };
        if (this.follower.isLeader() || this.follower.getTarget() != null || !this.follower.onGround()) {
            resetCooldownAndFail.run();
            return false;
        }
        if (this.follower.isFollowingLeaderGoalActive()) {
            resetCooldownAndFail.run();
            return false;
        }
        Optional<BlockPos> foundCampfireOpt = this.findNearbyLitCampfireContext();
        if (!foundCampfireOpt.isPresent()) {
            resetCooldownAndFail.run();
            return false;
        }
        this.anchorCampfirePos = foundCampfireOpt.get();
        if (this.follower.getRandom().nextFloat() < 0.5f) {
            return true;
        }
        this.considerationCooldown = 7000 + this.follower.getRandom().nextInt(6000);
        return false;
    }

    public void start() {
        ICampContributionAction chosenAction;
        if (this.follower.level() instanceof ServerLevel && (chosenAction = this.selectWeightedRandomContribution()) != null) {
            chosenAction.tryExecute(this);
        }
        this.considerationCooldown = 7000 + this.follower.getRandom().nextInt(6000);
    }

    @Nullable
    private ICampContributionAction selectWeightedRandomContribution() {
        if (POSSIBLE_CONTRIBUTIONS.isEmpty()) {
            return null;
        }
        double totalWeight = 0.0;
        for (Pair<ICampContributionAction, Double> pair : POSSIBLE_CONTRIBUTIONS) {
            totalWeight += ((Double)pair.getSecond()).doubleValue();
        }
        if (totalWeight <= 0.0) {
            if (!POSSIBLE_CONTRIBUTIONS.isEmpty()) {
                return (ICampContributionAction)POSSIBLE_CONTRIBUTIONS.get(this.follower.getRandom().nextInt(POSSIBLE_CONTRIBUTIONS.size())).getFirst();
            }
            return null;
        }
        double r = this.follower.getRandom().nextDouble() * totalWeight;
        for (Pair<ICampContributionAction, Double> pair : POSSIBLE_CONTRIBUTIONS) {
            if (!((r -= ((Double)pair.getSecond()).doubleValue()) <= 0.0)) continue;
            return (ICampContributionAction)pair.getFirst();
        }
        return POSSIBLE_CONTRIBUTIONS.isEmpty() ? null : (ICampContributionAction)POSSIBLE_CONTRIBUTIONS.get(POSSIBLE_CONTRIBUTIONS.size() - 1).getFirst();
    }

    private boolean tryPlaceHayBale() {
        BlockPos referenceAnchor;
        ServerLevel level = (ServerLevel)this.follower.level();
        BlockPos placementPos = this.findClearPlacementPosNearby(level, (LivingEntity)this.follower, referenceAnchor = this.anchorCampfirePos != null ? this.anchorCampfirePos : this.follower.blockPosition(), 1, 1, 1, 3);
        if (placementPos != null) {
            level.setBlock(placementPos, Blocks.HAY_BLOCK.defaultBlockState(), 3);
            level.playSound(null, placementPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            return true;
        }
        return false;
    }

    private boolean trySpawnLeashedAnimal() {
        BlockPos spawnPos;
        ServerLevel level = (ServerLevel)this.follower.level();
        RandomSource random = this.follower.getRandom();
        if (SPAWNABLE_ANIMAL_TYPES.isEmpty()) {
            return false;
        }
        EntityType<? extends Animal> selectedAnimalType = SPAWNABLE_ANIMAL_TYPES.get(random.nextInt(SPAWNABLE_ANIMAL_TYPES.size()));
        Animal animalEntity = (Animal)selectedAnimalType.create((Level)level);
        if (animalEntity != null && (spawnPos = this.findClearPlacementPosNearby(level, (LivingEntity)this.follower, this.follower.blockPosition(), (int)Math.ceil(animalEntity.getBbWidth()), (int)Math.ceil(animalEntity.getBbHeight()), 1, 2)) != null) {
            animalEntity.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            if (animalEntity instanceof AgeableMob) {
                Animal ageableMob = animalEntity;
                ageableMob.setAge(0);
            }
            level.addFreshEntity((Entity)animalEntity);
            animalEntity.setLeashedTo((Entity)this.follower, true);
            level.playSound(null, this.follower.blockPosition(), SoundEvents.LEASH_KNOT_PLACE, SoundSource.NEUTRAL, 0.5f, 1.0f);
            SoundEvent ambientSound = this.getAmbientSoundForEntityType(selectedAnimalType);
            if (ambientSound != null) {
                level.playSound(null, animalEntity.blockPosition(), ambientSound, SoundSource.NEUTRAL, 0.7f, animalEntity.getVoicePitch());
            }
            return true;
        }
        return false;
    }

    private boolean tryPlaceHilichurlCampfire() {
        ServerLevel level = (ServerLevel)this.follower.level();
        BlockPos referencePos = this.anchorCampfirePos != null ? this.anchorCampfirePos : this.follower.blockPosition();
        for (int attempt = 0; attempt < 10; ++attempt) {
            BlockPos placementPos = this.findClearPlacementPosNearby(level, (LivingEntity)this.follower, referencePos, 1, 1, 14, 24);
            if (placementPos == null) continue;
            boolean tooCloseToExisting = false;
            for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)placementPos.offset(-1, 0, -1), (BlockPos)placementPos.offset(1, 0, 1))) {
                BlockState existingState = level.getBlockState(checkPos);
                if (!existingState.is(ModBlocks.HILICHURL_CAMPFIRE.get()) && !existingState.is(Blocks.CAMPFIRE)) continue;
                if (checkPos.equals((Object)this.anchorCampfirePos) && placementPos.distManhattan((Vec3i)this.anchorCampfirePos) < 3) {
                    tooCloseToExisting = true;
                } else if (!checkPos.equals((Object)this.anchorCampfirePos)) {
                    tooCloseToExisting = true;
                }
                if (!tooCloseToExisting) continue;
                break;
            }
            if (tooCloseToExisting) continue;
            level.setBlock(placementPos, (BlockState)ModBlocks.HILICHURL_CAMPFIRE.get().defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            level.playSound(null, placementPos, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean tryPlaceLogPile() {
        ServerLevel level = (ServerLevel)this.follower.level();
        BlockPos referencePos = this.anchorCampfirePos != null ? this.anchorCampfirePos : this.follower.blockPosition();
        RandomSource random = this.follower.getRandom();
        Block logBlock = Blocks.OAK_LOG;
        int numberOfLogs = 3;
        for (int attempt = 0; attempt < 10; ++attempt) {
            Direction.Axis primaryAxis = random.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z;
            BlockState logStateWithAxis = (BlockState)logBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)primaryAxis);
            Direction extensionDirection = primaryAxis == Direction.Axis.X ? (random.nextBoolean() ? Direction.EAST : Direction.WEST) : (random.nextBoolean() ? Direction.NORTH : Direction.SOUTH);
            BlockPos firstLogPos = this.findClearPlacementPosNearby(level, (LivingEntity)this.follower, referencePos, 1, 1, 2, 6);
            if (firstLogPos == null || this.anchorCampfirePos != null && firstLogPos.distManhattan((Vec3i)this.anchorCampfirePos) < 3) continue;
            ArrayList<BlockPos> logPositionsToPlace = new ArrayList<BlockPos>();
            boolean canPlaceEntireLogPile = true;
            for (int i = 0; i < numberOfLogs; ++i) {
                BlockPos currentLogPos = firstLogPos.relative(extensionDirection, i);
                if (i == 0) {
                    logPositionsToPlace.add(currentLogPos);
                    continue;
                }
                if (level.isEmptyBlock(currentLogPos) && level.getBlockState(currentLogPos.below()).isFaceSturdy((BlockGetter)level, currentLogPos.below(), Direction.UP)) {
                    logPositionsToPlace.add(currentLogPos);
                    continue;
                }
                canPlaceEntireLogPile = false;
                break;
            }
            if (!canPlaceEntireLogPile) continue;
            for (BlockPos pos : logPositionsToPlace) {
                level.setBlock(pos, logStateWithAxis, 3);
            }
            level.playSound(null, firstLogPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            return true;
        }
        return false;
    }

    private boolean tryPlaceLargeCrate() {
        ServerLevel level = (ServerLevel)this.follower.level();
        BlockPos referencePos = this.anchorCampfirePos != null ? this.anchorCampfirePos : this.follower.blockPosition();
        RandomSource random = this.follower.getRandom();
        BlockPos placementPos = this.findClearPlacementPosNearby(level, (LivingEntity)this.follower, referencePos, 1, 2, 4, 16);
        if (placementPos != null) {
            level.setBlock(placementPos, ModBlocks.LARGE_CRATE.get().defaultBlockState(), 3);
            level.playSound(null, placementPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f);
            return true;
        }
        return false;
    }

    private boolean tryPlaceHilichurlBarrel() {
        ServerLevel level = (ServerLevel)this.follower.level();
        BlockPos referencePos = this.anchorCampfirePos != null ? this.anchorCampfirePos : this.follower.blockPosition();
        RandomSource random = this.follower.getRandom();
        BlockPos placementPos = this.findClearPlacementPosNearby(level, (LivingEntity)this.follower, referencePos, 1, 1, 4, 16);
        if (placementPos != null) {
            level.setBlock(placementPos, ModBlocks.HILICHURL_BARREL.get().defaultBlockState(), 3);
            level.playSound(null, placementPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findClearPlacementPosNearby(ServerLevel level, LivingEntity entityUsedForRandom, BlockPos anchorPos, int objectWidth, int objectHeight, int minRadius, int maxRadius) {
        if (maxRadius <= minRadius && maxRadius > 0) {
            minRadius = maxRadius - 1;
        } else if (maxRadius <= minRadius) {
            maxRadius = minRadius + 1;
        }
        RandomSource random = entityUsedForRandom.getRandom();
        for (int attempts = 0; attempts < 15; ++attempts) {
            boolean spaceClear;
            BlockPos groundPos;
            block6: {
                block5: {
                    double angle = random.nextDouble() * 2.0 * Math.PI;
                    double dist = minRadius == 0 && maxRadius == 0 ? 0.0 : (double)minRadius + random.nextDouble() * (double)(maxRadius - minRadius);
                    int xOff = (int)(Math.cos(angle) * dist);
                    int zOff = (int)(Math.sin(angle) * dist);
                    BlockPos potentialCenterPos = anchorPos.offset(xOff, 0, zOff);
                    groundPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, potentialCenterPos);
                    spaceClear = true;
                    if (objectWidth != 1 || objectHeight != 1) break block5;
                    if (level.isEmptyBlock(groundPos)) break block6;
                    spaceClear = false;
                    break block6;
                }
                for (int yOffset = 0; yOffset < objectHeight; ++yOffset) {
                    if (level.isEmptyBlock(groundPos.above(yOffset))) continue;
                    spaceClear = false;
                    break;
                }
            }
            if (!spaceClear || !level.getBlockState(groundPos.below()).isFaceSturdy((BlockGetter)level, groundPos.below(), Direction.UP)) continue;
            return groundPos;
        }
        return null;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void stop() {
    }

    static {
        POSSIBLE_CONTRIBUTIONS.add((Pair<ICampContributionAction, Double>)Pair.of(goal -> goal.tryPlaceHayBale(), (Object)5.0));
        POSSIBLE_CONTRIBUTIONS.add((Pair<ICampContributionAction, Double>)Pair.of(goal -> goal.trySpawnLeashedAnimal(), (Object)7.0));
        POSSIBLE_CONTRIBUTIONS.add((Pair<ICampContributionAction, Double>)Pair.of(goal -> goal.tryPlaceHilichurlCampfire(), (Object)5.0));
        POSSIBLE_CONTRIBUTIONS.add((Pair<ICampContributionAction, Double>)Pair.of(goal -> goal.tryPlaceLogPile(), (Object)4.0));
        POSSIBLE_CONTRIBUTIONS.add((Pair<ICampContributionAction, Double>)Pair.of(goal -> goal.tryPlaceLargeCrate(), (Object)6.0));
        POSSIBLE_CONTRIBUTIONS.add((Pair<ICampContributionAction, Double>)Pair.of(goal -> goal.tryPlaceHilichurlBarrel(), (Object)7.0));
        POSSIBLE_CONTRIBUTIONS.add((Pair<ICampContributionAction, Double>)Pair.of((Object)new PlaceFenceContributionAction(), (Object)8.0));
        SPAWNABLE_ANIMAL_TYPES = List.of(EntityType.COW, EntityType.PIG, EntityType.SHEEP, EntityType.CHICKEN);
    }

    @FunctionalInterface
    static interface ICampContributionAction {
        public boolean tryExecute(FollowerCampContributionGoal var1);
    }
}

