/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class GenshinHungerHealGoal<T extends GenshinEntity>
extends Goal {
    protected final T mob;
    public static final double HEALTH_THRESHOLD_PERCENT = 0.75;
    public static final double ITEM_SEARCH_RANGE = 10.0;
    public static final double EDIBLE_BLOCK_SEARCH_RANGE = 8.0;
    private static final int EAT_BLOCK_DURATION_TICKS = 30;
    private int searchCooldownTicks;
    private static final int FOOD_SEARCH_INTERVAL_MIN = 40;
    private static final int FOOD_SEARCH_INTERVAL_RANDOM = 40;
    @Nullable
    private ItemEntity targetedItem;
    @Nullable
    private BlockPos targetEdibleBlockPos;
    private BlockState targetedBlockState;
    private boolean isTargetingEdibleBlock;
    private int eatingBlockTicks;

    public GenshinHungerHealGoal(T mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Optional<BlockPos> foundBlock;
        if (this.searchCooldownTicks > 0) {
            --this.searchCooldownTicks;
            return false;
        }
        this.searchCooldownTicks = 40 + this.mob.getRandom().nextInt(40);
        if ((double)this.mob.getHealth() >= (double)this.mob.getMaxHealth() * 0.75) {
            return false;
        }
        LivingEntity currentTarget = this.mob.getTarget();
        if (currentTarget != null && currentTarget.isAlive() && (currentTarget instanceof Player || currentTarget instanceof Monster)) {
            return false;
        }
        if (!((GenshinEntity)((Object)this.mob)).getEdibleBlocks().isEmpty() && (foundBlock = this.findNearbyEdibleBlock()).isPresent()) {
            this.targetEdibleBlockPos = foundBlock.get();
            this.targetedBlockState = this.mob.level().getBlockState(this.targetEdibleBlockPos);
            this.isTargetingEdibleBlock = true;
            this.targetedItem = null;
            return true;
        }
        this.isTargetingEdibleBlock = false;
        this.targetEdibleBlockPos = null;
        this.targetedBlockState = null;
        return this.findAndSetTargetItem();
    }

    private boolean findAndSetTargetItem() {
        Predicate<ItemEntity> isEdibleFoodItem = itemEntity -> itemEntity.isAlive() && ((GenshinEntity)((Object)((Object)this.mob))).getEdibleItems().containsKey(itemEntity.getItem().getItem());
        List nearbyFoodItems = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(10.0), isEdibleFoodItem);
        if (nearbyFoodItems.isEmpty()) {
            return false;
        }
        this.targetedItem = nearbyFoodItems.stream().min(Comparator.comparingDouble(item -> item.distanceToSqr(this.mob))).orElse(null);
        return this.targetedItem != null;
    }

    @Nullable
    private Optional<BlockPos> findNearbyEdibleBlock() {
        Map<Block, Float> edibleBlocksMap = ((GenshinEntity)((Object)this.mob)).getEdibleBlocks();
        if (edibleBlocksMap.isEmpty()) {
            return Optional.empty();
        }
        return BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)8, (int)4, pos -> edibleBlocksMap.containsKey(this.mob.level().getBlockState(pos).getBlock()));
    }

    public boolean canContinueToUse() {
        boolean needsHealing;
        boolean bl = needsHealing = (double)this.mob.getHealth() < (double)this.mob.getMaxHealth() * 0.75;
        if (!needsHealing) {
            return false;
        }
        LivingEntity currentTarget = this.mob.getTarget();
        if (currentTarget != null && currentTarget.isAlive() && (currentTarget instanceof Player || currentTarget instanceof Monster)) {
            return false;
        }
        if (this.isTargetingEdibleBlock) {
            return this.targetEdibleBlockPos != null && ((GenshinEntity)((Object)this.mob)).getEdibleBlocks().containsKey(this.mob.level().getBlockState(this.targetEdibleBlockPos).getBlock()) && this.eatingBlockTicks < 30;
        }
        return this.targetedItem != null && this.targetedItem.isAlive();
    }

    public void start() {
        ((GenshinEntity)((Object)this.mob)).setTarget(null);
        this.eatingBlockTicks = 0;
        if (this.isTargetingEdibleBlock && this.targetEdibleBlockPos != null) {
            Vec3 targetVec = Vec3.atBottomCenterOf((Vec3i)this.targetEdibleBlockPos);
            this.mob.getNavigation().moveTo(targetVec.x(), targetVec.y(), targetVec.z(), 1.0);
        } else if (this.targetedItem != null) {
            this.mob.getNavigation().moveTo((Entity)this.targetedItem, 1.0);
        } else if (!this.isTargetingEdibleBlock && this.findAndSetTargetItem() && this.targetedItem != null) {
            this.mob.getNavigation().moveTo((Entity)this.targetedItem, 1.0);
        }
    }

    public void tick() {
        if (this.isTargetingEdibleBlock) {
            if (this.targetEdibleBlockPos == null || this.targetedBlockState == null) {
                this.stop();
                return;
            }
            this.mob.getLookControl().setLookAt(Vec3.atCenterOf((Vec3i)this.targetEdibleBlockPos));
            if (this.mob.distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetEdibleBlockPos)) < 6.25) {
                this.mob.getNavigation().stop();
                ++this.eatingBlockTicks;
                if (this.eatingBlockTicks % 10 == 0) {
                    this.mob.playSound(SoundEvents.GENERIC_EAT, 0.5f + 0.5f * (float)this.mob.getRandom().nextInt(2), (this.mob.getRandom().nextFloat() - this.mob.getRandom().nextFloat()) * 0.2f + 1.0f);
                }
                if (this.eatingBlockTicks >= 30) {
                    Level level = this.mob.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        Block currentBlockInWorld = serverLevel.getBlockState(this.targetEdibleBlockPos).getBlock();
                        Float healPercent = ((GenshinEntity)((Object)this.mob)).getEdibleBlocks().get(currentBlockInWorld);
                        if (healPercent != null) {
                            serverLevel.destroyBlock(this.targetEdibleBlockPos, false, this.mob);
                            this.mob.heal(this.mob.getMaxHealth() * healPercent.floatValue());
                            this.mob.playSound(SoundEvents.PLAYER_BURP, 0.5f, this.mob.getRandom().nextFloat() * 0.1f + 0.9f);
                        }
                    }
                    this.stop();
                }
            } else if (this.mob.getNavigation().isDone()) {
                this.mob.getNavigation().moveTo((double)this.targetEdibleBlockPos.getX() + 0.5, (double)this.targetEdibleBlockPos.getY(), (double)this.targetEdibleBlockPos.getZ() + 0.5, 1.0);
            }
        } else {
            if (this.targetedItem == null || !this.targetedItem.isAlive()) {
                this.stop();
                return;
            }
            this.mob.getLookControl().setLookAt((Entity)this.targetedItem, 10.0f, (float)this.mob.getMaxHeadXRot());
            if (this.mob.getNavigation().isDone() && !this.mob.getBoundingBox().intersects(this.targetedItem.getBoundingBox().inflate(0.5))) {
                this.mob.getNavigation().moveTo((Entity)this.targetedItem, 1.0);
            }
        }
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.targetedItem = null;
        this.targetEdibleBlockPos = null;
        this.targetedBlockState = null;
        this.isTargetingEdibleBlock = false;
        this.eatingBlockTicks = 0;
    }
}

