/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class HilichurlCampGoal
extends Goal {
    private final GenshinEntity leader;
    private RitualPhase currentPhase = RitualPhase.INACTIVE;
    private int phaseTicks;
    private BlockPos campfirePos;
    private static final int CAMPFIRE_SPAWN_ATTEMPT_TIMEOUT = 100;

    public HilichurlCampGoal(GenshinEntity leader) {
        this.leader = leader;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.leader.isLeader() || this.leader.getTarget() != null || !this.leader.onGround()) {
            return false;
        }
        return this.leader.getNeedsToPerformCampfireRitual();
    }

    public boolean canContinueToUse() {
        if (this.leader.getTarget() != null) {
            return false;
        }
        return this.currentPhase != RitualPhase.DONE && this.currentPhase != RitualPhase.INACTIVE;
    }

    public void start() {
        super.start();
        this.currentPhase = RitualPhase.FINDING_SPOT_AND_SPAWNING_CAMPFIRE;
        this.phaseTicks = 0;
        this.campfirePos = null;
        this.leader.getNavigation().stop();
        this.leader.setNeedsToPerformCampfireRitual(false);
    }

    public void stop() {
        super.stop();
        this.currentPhase = RitualPhase.INACTIVE;
        this.phaseTicks = 0;
        this.campfirePos = null;
    }

    public void tick() {
        ++this.phaseTicks;
        this.leader.getLookControl().setLookAt(this.leader.getX() + this.leader.getLookAngle().x, this.leader.getEyeY(), this.leader.getZ() + this.leader.getLookAngle().z);
        switch (this.currentPhase.ordinal()) {
            case 1: {
                if (this.trySpawnCampfire()) {
                    this.currentPhase = RitualPhase.DONE;
                    break;
                }
                if (this.phaseTicks <= 100) break;
                this.currentPhase = RitualPhase.DONE;
                break;
            }
        }
    }

    private boolean trySpawnCampfire() {
        if (this.leader.level().isClientSide()) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)this.leader.level();
        for (int i = 0; i < 10; ++i) {
            BlockPos posOnTopOfSolid;
            Vec3 leaderLook = this.leader.getLookAngle();
            BlockPos searchPos = this.leader.blockPosition().offset((int)(leaderLook.x() * (double)(2 + this.leader.getRandom().nextInt(2))), 0, (int)(leaderLook.z() * (double)(2 + this.leader.getRandom().nextInt(2))));
            BlockPos posToPlaceCampfire = serverLevel.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, searchPos);
            BlockState stateAtPlacePos = serverLevel.getBlockState(posToPlaceCampfire);
            boolean canPlace = false;
            if (serverLevel.getBlockState(posToPlaceCampfire.below()).isFaceSturdy((BlockGetter)serverLevel, posToPlaceCampfire.below(), Direction.UP) && (serverLevel.isEmptyBlock(posToPlaceCampfire) || stateAtPlacePos.canBeReplaced() || stateAtPlacePos.is(Blocks.SNOW)) && serverLevel.isEmptyBlock(posToPlaceCampfire.above())) {
                canPlace = true;
            }
            if (!canPlace && stateAtPlacePos.isSolidRender((BlockGetter)serverLevel, posToPlaceCampfire) && !stateAtPlacePos.canBeReplaced() && !stateAtPlacePos.is(Blocks.SNOW) && serverLevel.isEmptyBlock(posOnTopOfSolid = posToPlaceCampfire.above()) && serverLevel.isEmptyBlock(posOnTopOfSolid.above())) {
                posToPlaceCampfire = posOnTopOfSolid;
                canPlace = true;
            }
            if (!canPlace) continue;
            serverLevel.setBlock(posToPlaceCampfire, (BlockState)ModBlocks.HILICHURL_CAMPFIRE.get().defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            this.campfirePos = posToPlaceCampfire;
            serverLevel.playSound(null, posToPlaceCampfire, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean isInterruptable() {
        return true;
    }

    private static enum RitualPhase {
        INACTIVE,
        FINDING_SPOT_AND_SPAWNING_CAMPFIRE,
        DONE;

    }
}

