/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.types.AbyssalEntity;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.HilichurlEntity;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.HilichurlFighterEntity;

public class HilichurlFollowLeaderGoal
extends Goal {
    private final AbyssalEntity follower;
    private GenshinEntity leader;
    private int followingTick;
    private boolean hasReachedLeaderCurrentTarget;
    @Nullable
    private Vec3 currentOffsetNavTarget = null;
    @Nullable
    private Vec3 previousLeaderPatrolTargetForOffset = null;
    private static final double LEADER_SEARCH_RADIUS = 32.0;
    private static final double MIN_FOLLOW_DISTANCE_SQ = 4.0;
    private static final double MAX_FOLLOW_DISTANCE_SQ = 64.0;
    private static final double CATCH_UP_DISTANCE_SQ = 225.0;
    private static final double TARGET_REACHED_THRESHOLD_SQ = 6.25;

    public HilichurlFollowLeaderGoal(AbyssalEntity follower) {
        this.follower = follower;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.follower.isLeader() || this.follower.getTarget() != null) {
            return false;
        }
        List nearbyPotentialLeaders = this.follower.level().getEntitiesOfClass(GenshinEntity.class, this.follower.getBoundingBox().inflate(32.0), e -> e.isLeader() && e.isAlive() && e != this.follower && (e instanceof HilichurlEntity || e instanceof HilichurlFighterEntity));
        if (nearbyPotentialLeaders.isEmpty()) {
            this.leader = null;
            return false;
        }
        this.leader = nearbyPotentialLeaders.stream().min(Comparator.comparingDouble(arg_0 -> ((AbyssalEntity)this.follower).distanceToSqr(arg_0))).orElse(null);
        if (this.leader == null) {
            return false;
        }
        if (this.leader.getTarget() != null) {
            return false;
        }
        return this.leader.getLeaderPatrolGoalTargetPosition() != null || this.leader.isSignalingPatrol();
    }

    public boolean canContinueToUse() {
        if (this.leader == null || !this.leader.isAlive() || this.follower.isLeader()) {
            return false;
        }
        if (this.leader.getTarget() != null) {
            return false;
        }
        if (this.follower.getTarget() != null) {
            return false;
        }
        return this.leader.getLeaderPatrolGoalTargetPosition() != null;
    }

    public void start() {
        this.followingTick = 0;
        this.hasReachedLeaderCurrentTarget = false;
        this.follower.getNavigation().stop();
        this.currentOffsetNavTarget = null;
        this.previousLeaderPatrolTargetForOffset = null;
    }

    public void stop() {
        this.leader = null;
        this.follower.getNavigation().stop();
        this.currentOffsetNavTarget = null;
        this.previousLeaderPatrolTargetForOffset = null;
    }

    @Nullable
    private Vec3 calculateOffsetLeaderTarget(AbyssalEntity follower, Vec3 leaderPatrolTargetPos, GenshinEntity leader) {
        Vec3 offset;
        Vec3 desiredOffsetPoint;
        int verticalSearchRadius;
        int horizontalSearchRadius;
        Vec3 pathableTarget;
        int uniqueOffsetSeed = follower.getId();
        boolean goLeft = uniqueOffsetSeed % 2 == 0;
        double[] offsetDistances = new double[]{1.5, 2.0, 2.5, 3.0};
        double chosenOffsetDistance = offsetDistances[uniqueOffsetSeed / 2 % offsetDistances.length];
        Vec3 pathDirection = leaderPatrolTargetPos.subtract(leader.position());
        if (pathDirection.lengthSqr() < 1.0E-4 && (pathDirection = leader.getLookAngle()).lengthSqr() < 1.0E-4) {
            pathDirection = new Vec3(1.0, 0.0, 0.0);
        }
        pathDirection = pathDirection.normalize();
        Vec3 perpendicularOffsetDir = new Vec3(-pathDirection.z, 0.0, pathDirection.x).normalize();
        if (perpendicularOffsetDir.lengthSqr() < 1.0E-4) {
            Vec3 leaderLookHorizontal = new Vec3(leader.getLookAngle().x, 0.0, leader.getLookAngle().z).normalize();
            perpendicularOffsetDir = leaderLookHorizontal.lengthSqr() < 1.0E-4 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(-leaderLookHorizontal.z, 0.0, leaderLookHorizontal.x).normalize();
        }
        if ((pathableTarget = DefaultRandomPos.getPosTowards((PathfinderMob)follower, (int)(horizontalSearchRadius = 4), (int)(verticalSearchRadius = 2), (Vec3)(desiredOffsetPoint = leaderPatrolTargetPos.add(offset = perpendicularOffsetDir.scale(chosenOffsetDistance * (double)(goLeft ? 1 : -1)))), (double)1.5707963267948966)) != null) {
            return pathableTarget;
        }
        return leaderPatrolTargetPos;
    }

    public void tick() {
        if (this.leader == null || !this.leader.isAlive()) {
            this.stop();
            return;
        }
        LivingEntity leaderTarget = this.leader.getTarget();
        if (leaderTarget != null) {
            if (!Objects.equals(this.follower.getTarget(), leaderTarget)) {
                this.follower.setTarget(leaderTarget);
            }
            return;
        }
        Vec3 leaderPatrolTargetPos = this.leader.getLeaderPatrolGoalTargetPosition();
        boolean leaderIsCurrentlyMoving = this.leader.isLeaderActivelyPatrolling();
        double distanceToLeaderSq = this.follower.distanceToSqr((Entity)this.leader);
        double leaderAbsoluteSpeed = this.leader.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.leader.getNavigationSpeedMultiplier();
        double followerBaseSpeed = this.follower.getAttributeValue(Attributes.MOVEMENT_SPEED);
        double necessaryFollowerSpeedMultiplier = 1.0;
        necessaryFollowerSpeedMultiplier = followerBaseSpeed > 0.001 ? leaderAbsoluteSpeed / followerBaseSpeed : this.follower.getNavigationSpeedMultiplier();
        if (leaderPatrolTargetPos != null) {
            if (leaderIsCurrentlyMoving) {
                this.hasReachedLeaderCurrentTarget = false;
                if (distanceToLeaderSq > 225.0) {
                    this.follower.getNavigation().moveTo((Entity)this.leader, necessaryFollowerSpeedMultiplier * 1.25);
                    this.currentOffsetNavTarget = null;
                    this.previousLeaderPatrolTargetForOffset = null;
                } else {
                    BlockPos currentNavBlockTarget;
                    boolean shouldRecalculateOffset = false;
                    if (this.currentOffsetNavTarget == null || this.previousLeaderPatrolTargetForOffset == null) {
                        shouldRecalculateOffset = true;
                    } else if (this.previousLeaderPatrolTargetForOffset.distanceToSqr(leaderPatrolTargetPos) > 0.25) {
                        shouldRecalculateOffset = true;
                    } else {
                        currentNavBlockTarget = this.follower.getNavigation().getTargetPos();
                        if (this.follower.getNavigation().isDone()) {
                            if (currentNavBlockTarget == null || !BlockPos.containing((Position)this.currentOffsetNavTarget).closerThan((Vec3i)currentNavBlockTarget, 1.5)) {
                                shouldRecalculateOffset = true;
                            } else if (BlockPos.containing((Position)this.currentOffsetNavTarget).closerThan((Vec3i)this.follower.blockPosition(), 2.0)) {
                                shouldRecalculateOffset = true;
                            }
                        }
                    }
                    if (shouldRecalculateOffset) {
                        this.currentOffsetNavTarget = this.calculateOffsetLeaderTarget(this.follower, leaderPatrolTargetPos, this.leader);
                        this.previousLeaderPatrolTargetForOffset = leaderPatrolTargetPos;
                    }
                    if (this.follower.distanceToSqr(leaderPatrolTargetPos) <= 6.25) {
                        if (!this.hasReachedLeaderCurrentTarget) {
                            this.follower.getNavigation().stop();
                            this.hasReachedLeaderCurrentTarget = true;
                            this.currentOffsetNavTarget = null;
                            this.previousLeaderPatrolTargetForOffset = null;
                        }
                    } else if (this.currentOffsetNavTarget != null) {
                        currentNavBlockTarget = this.follower.getNavigation().getTargetPos();
                        boolean needsNewPathInstruction = false;
                        if (currentNavBlockTarget == null) {
                            needsNewPathInstruction = true;
                        } else {
                            Vec3 currentNavVec3Target = Vec3.atCenterOf((Vec3i)currentNavBlockTarget);
                            if (this.currentOffsetNavTarget.distanceToSqr(currentNavVec3Target) > 0.25) {
                                needsNewPathInstruction = true;
                            }
                        }
                        if (needsNewPathInstruction || this.follower.getNavigation().isDone()) {
                            this.follower.getNavigation().moveTo(this.currentOffsetNavTarget.x, this.currentOffsetNavTarget.y, this.currentOffsetNavTarget.z, necessaryFollowerSpeedMultiplier);
                        }
                    }
                }
            } else if (this.currentOffsetNavTarget != null && this.follower.distanceToSqr(this.currentOffsetNavTarget) > 6.25) {
                BlockPos currentNavBlockTarget = this.follower.getNavigation().getTargetPos();
                boolean needsNewPathInstruction = false;
                if (currentNavBlockTarget == null) {
                    needsNewPathInstruction = true;
                } else {
                    Vec3 currentNavVec3Target = Vec3.atCenterOf((Vec3i)currentNavBlockTarget);
                    if (this.currentOffsetNavTarget.distanceToSqr(currentNavVec3Target) > 0.25) {
                        needsNewPathInstruction = true;
                    }
                }
                if (needsNewPathInstruction || this.follower.getNavigation().isDone()) {
                    this.follower.getNavigation().moveTo(this.currentOffsetNavTarget.x, this.currentOffsetNavTarget.y, this.currentOffsetNavTarget.z, necessaryFollowerSpeedMultiplier);
                }
            } else {
                this.currentOffsetNavTarget = null;
                this.previousLeaderPatrolTargetForOffset = null;
                if (!this.follower.getNavigation().isDone() && !this.hasReachedLeaderCurrentTarget && this.follower.getNavigation().getTargetPos() != null && leaderPatrolTargetPos.distanceToSqr(Vec3.atCenterOf((Vec3i)this.follower.getNavigation().getTargetPos())) < 1.0) {
                    this.follower.getNavigation().stop();
                    this.hasReachedLeaderCurrentTarget = true;
                }
                if (distanceToLeaderSq > 64.0 && this.follower.getNavigation().isDone()) {
                    this.follower.getNavigation().moveTo((Entity)this.leader, this.follower.getNavigationSpeedMultiplier());
                } else if (distanceToLeaderSq < 4.0) {
                    this.follower.getNavigation().stop();
                }
                if (this.follower.distanceToSqr(leaderPatrolTargetPos) <= 6.25) {
                    this.hasReachedLeaderCurrentTarget = true;
                }
            }
        } else {
            if (!this.follower.getNavigation().isDone()) {
                this.follower.getNavigation().stop();
            }
            this.currentOffsetNavTarget = null;
            this.previousLeaderPatrolTargetForOffset = null;
        }
    }
}

