/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class HilichurlLeaderPatrolGoal
extends Goal {
    protected final GenshinEntity mob;
    private final double speedMultiplier;
    private final int executionInterval;
    private int generalCooldown;
    @Nullable
    private Vec3 currentLegTargetPos;
    @Nullable
    private Vec3 overallPatrolDirection;
    @Nullable
    private Vec3 lastLegActualEndPoint;
    private float originalWaterPathfindingMalus;
    private int currentLegNumber;
    private static final int TOTAL_PATROL_LEGS = 15;
    private static final int PATROL_INITIAL_LEG_HORIZONTAL_RADIUS = 70;
    private static final int PATROL_INITIAL_LEG_VERTICAL_RADIUS = 10;
    private static final double MIN_INITIAL_LEG_FACTOR = 0.66;
    private static final int PATROL_SUBSEQUENT_LEG_DISTANCE = 70;
    private static final int SUBSEQUENT_LEG_SEARCH_HORIZONTAL_RADIUS = 25;
    private static final int SUBSEQUENT_LEG_SEARCH_VERTICAL_RADIUS = 8;
    private static final double SUBSEQUENT_LEG_MAX_ANGLE_DEVIATION = 0.8975979010256552;
    private static final int RETRY_SUBSEQUENT_LEG_SEARCH_HORIZONTAL_RADIUS = 35;
    private static final double RETRY_SUBSEQUENT_LEG_MAX_ANGLE_DEVIATION = 1.2566370614359172;
    private static final int NO_CAMPFIRE_CHECK_RADIUS = 32;

    public HilichurlLeaderPatrolGoal(GenshinEntity mob, double speedMultiplier, int executionIntervalTicks) {
        this.mob = mob;
        this.speedMultiplier = speedMultiplier;
        this.executionInterval = Math.max(1, executionIntervalTicks);
        this.generalCooldown = 0;
        this.currentLegNumber = 0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean isHilichurlCampfireMissingNearby(double radius) {
        if (this.mob.level().isClientSide()) {
            return true;
        }
        Optional foundCampfire = BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)((int)radius), (int)((int)(radius / 2.0)), pos -> {
            BlockState blockState = this.mob.level().getBlockState(pos);
            return blockState.is(ModBlocks.HILICHURL_CAMPFIRE.get()) && blockState.hasProperty((Property)CampfireBlock.LIT) && (Boolean)blockState.getValue((Property)CampfireBlock.LIT) != false;
        });
        return foundCampfire.isEmpty();
    }

    public boolean canUse() {
        if (this.mob.getNeedsToPerformCampfireRitual()) {
            return false;
        }
        if (this.currentLegNumber != 0) {
            return false;
        }
        if (!this.mob.isLeader() || this.mob.getTarget() != null || !this.mob.getNavigation().isDone()) {
            return false;
        }
        if (this.generalCooldown > 0) {
            --this.generalCooldown;
            return false;
        }
        if (!this.isHilichurlCampfireMissingNearby(32.0)) {
            this.generalCooldown = this.executionInterval;
            return false;
        }
        Vec3 randomPosForLeg1 = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)70, (int)10);
        if (randomPosForLeg1 == null) {
            this.generalCooldown = 20;
            return false;
        }
        double minDistanceSq = 2134.44;
        if (this.mob.position().distanceToSqr(randomPosForLeg1) < minDistanceSq) {
            this.generalCooldown = 20;
            return false;
        }
        this.currentLegTargetPos = randomPosForLeg1;
        this.lastLegActualEndPoint = this.mob.position();
        return true;
    }

    public boolean canContinueToUse() {
        return this.mob.getTarget() == null && this.mob.isLeader() && this.currentLegNumber != 0;
    }

    public void start() {
        if (this.currentLegTargetPos == null || this.lastLegActualEndPoint == null) {
            this.currentLegNumber = 0;
            return;
        }
        this.originalWaterPathfindingMalus = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 100.0f);
        this.currentLegNumber = 1;
        this.overallPatrolDirection = this.currentLegTargetPos.subtract(this.lastLegActualEndPoint).normalize();
        if (this.overallPatrolDirection.equals((Object)Vec3.ZERO)) {
            this.overallPatrolDirection = this.mob.getLookAngle();
        }
        double actualSpeed = this.speedMultiplier * this.mob.getNavigationSpeedMultiplier();
        boolean pathFound = this.mob.getNavigation().moveTo(this.currentLegTargetPos.x, this.currentLegTargetPos.y, this.currentLegTargetPos.z, actualSpeed);
        if (!pathFound) {
            this.stop();
            this.generalCooldown = this.executionInterval / 3 + this.mob.getRandom().nextInt(this.executionInterval / 3);
            return;
        }
        this.mob.isSignalingPatrol = true;
        this.mob.patrolSignalTicks = 40;
    }

    public void tick() {
        if (this.currentLegNumber == 0 || this.overallPatrolDirection == null || this.lastLegActualEndPoint == null) {
            if (this.currentLegNumber != 0) {
                System.out.println("[HLPG Error] " + this.mob.getName().getString() + " tick: Inconsistent state (leg=" + this.currentLegNumber + ", dir/lastEnd null). Stopping.");
                this.stop();
            }
            return;
        }
        if (this.currentLegTargetPos != null) {
            this.mob.getLookControl().setLookAt(this.currentLegTargetPos.x, this.currentLegTargetPos.y + (double)this.mob.getEyeHeight(), this.currentLegTargetPos.z, 10.0f, (float)this.mob.getMaxHeadXRot());
        }
        boolean currentLegSegmentMovementDone = false;
        if (this.currentLegTargetPos == null) {
            currentLegSegmentMovementDone = true;
        } else if (this.mob.getNavigation().isDone()) {
            currentLegSegmentMovementDone = true;
        } else if (this.mob.position().distanceToSqr(this.currentLegTargetPos) < 6.25) {
            currentLegSegmentMovementDone = true;
            this.mob.getNavigation().stop();
        }
        if (currentLegSegmentMovementDone) {
            if (this.currentLegTargetPos != null && (this.mob.getNavigation().isDone() || this.mob.position().distanceToSqr(this.currentLegTargetPos) < 6.25)) {
                this.lastLegActualEndPoint = this.currentLegTargetPos;
            }
            if (this.currentLegNumber < 15) {
                int legToSetUp = this.currentLegNumber + 1;
                Vec3 desiredNextPoint = this.lastLegActualEndPoint.add(this.overallPatrolDirection.scale(70.0));
                Vec3 foundTargetForNextLeg = this.findPathablePointForLeg(desiredNextPoint);
                this.currentLegNumber = legToSetUp;
                if (foundTargetForNextLeg != null) {
                    this.currentLegTargetPos = foundTargetForNextLeg;
                    double actualSpeed = this.speedMultiplier * this.mob.getNavigationSpeedMultiplier();
                    if (!this.mob.getNavigation().moveTo(this.currentLegTargetPos.x, this.currentLegTargetPos.y, this.currentLegTargetPos.z, actualSpeed)) {
                        System.out.println("    [HLPG] Failed to *initiate navigation* for Leg " + this.currentLegNumber + " to " + String.valueOf(this.currentLegTargetPos) + ". This leg will be effectively skipped.");
                        this.currentLegTargetPos = null;
                        this.mob.getNavigation().stop();
                    }
                } else {
                    System.out.println("    [HLPG] Could not find any navigable point for Leg " + this.currentLegNumber + ". This leg is SKIPPED.");
                    this.currentLegTargetPos = null;
                    this.mob.getNavigation().stop();
                }
            } else {
                this.stop();
            }
        }
    }

    @Nullable
    private Vec3 findPathablePointForLeg(Vec3 desiredPoint) {
        Vec3 target = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)25, (int)8, (Vec3)desiredPoint, (double)0.8975979010256552);
        if (target == null) {
            target = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)35, (int)8, (Vec3)desiredPoint, (double)1.2566370614359172);
        }
        if (target == null && this.lastLegActualEndPoint != null && this.overallPatrolDirection != null) {
            Vec3 shorterDesiredNextPoint = this.lastLegActualEndPoint.add(this.overallPatrolDirection.scale(23.1));
            target = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)35, (int)8, (Vec3)shorterDesiredNextPoint, (double)1.2566370614359172);
        }
        return target;
    }

    public void stop() {
        boolean wasActuallyPatrolling = this.currentLegNumber != 0;
        this.mob.getNavigation().stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.originalWaterPathfindingMalus);
        if (wasActuallyPatrolling && this.currentLegNumber >= 15) {
            this.mob.setNeedsToPerformCampfireRitual(true);
            this.generalCooldown = 20;
        } else {
            this.generalCooldown = wasActuallyPatrolling ? this.executionInterval / 2 + this.mob.getRandom().nextInt(this.executionInterval / 2) : this.executionInterval / 2 + this.mob.getRandom().nextInt(this.executionInterval / 2);
        }
        this.currentLegTargetPos = null;
        this.overallPatrolDirection = null;
        this.lastLegActualEndPoint = null;
        this.currentLegNumber = 0;
        this.mob.isSignalingPatrol = false;
        if (this.mob.patrolSignalTicks > 0) {
            this.mob.patrolSignalTicks = 0;
        }
    }

    @Nullable
    public Vec3 getCurrentLegTargetPos() {
        return this.currentLegTargetPos;
    }
}

