/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.zenith.hoyocraft.entity.ai.goal.FollowerCampContributionGoal;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import org.jetbrains.annotations.Nullable;

public class PlaceFenceContributionAction
implements FollowerCampContributionGoal.ICampContributionAction {
    private static final int MIN_FENCE_DISTANCE_FROM_CAMPFIRE = 12;
    private static final int MAX_FENCE_DISTANCE_FROM_CAMPFIRE = 24;
    private static final int MIN_FENCE_LENGTH = 4;
    private static final int MAX_FENCE_LENGTH = 8;
    private static final int MIN_TOTAL_L_SHAPE_LENGTH = 4;
    private static final int MAX_TOTAL_L_SHAPE_LENGTH = 8;
    private static final int MIN_SINGLE_SEGMENT_LENGTH = 2;
    private static final int MIN_TOTAL_U_SHAPE_LENGTH = 7;
    private static final int MAX_TOTAL_U_SHAPE_LENGTH = 12;
    private static final int MIN_U_ARM_LENGTH = 2;
    private static final int MIN_U_BASE_LENGTH = 2;
    private static final Block FENCE_BLOCK_TYPE = Blocks.OAK_FENCE;

    @Override
    public boolean tryExecute(FollowerCampContributionGoal goal) {
        GenshinEntity follower = goal.follower;
        if (follower.level().isClientSide() || goal.getAnchorCampfirePos() == null) {
            return false;
        }
        ServerLevel level = (ServerLevel)follower.level();
        BlockPos anchorCampfirePos = goal.getAnchorCampfirePos();
        RandomSource random = follower.getRandom();
        int attempts = 0;
        int maxAttempts = 5;
        for (attempts = 0; attempts < maxAttempts; ++attempts) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int distance = 12 + random.nextInt(13);
            int xOffset = (int)(Math.cos(angle) * (double)distance);
            int zOffset = (int)(Math.sin(angle) * (double)distance);
            BlockPos potentialStartPointInRing = anchorCampfirePos.offset(xOffset, 0, zOffset);
            BlockPos fenceLineStartPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, potentialStartPointInRing);
            Direction initialFenceDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            float randomVal = random.nextFloat();
            FenceShape shapeToBuild = randomVal < 0.3f ? FenceShape.STRAIGHT : (randomVal < 0.6f ? FenceShape.L_SHAPE : (randomVal < 0.85f ? FenceShape.U_SHAPE : FenceShape.ZIG_ZAG));
            boolean successThisAttempt = false;
            if (shapeToBuild == FenceShape.ZIG_ZAG) {
                successThisAttempt = this.tryPlaceZigZagFence(level, fenceLineStartPos, initialFenceDirection, random, anchorCampfirePos);
            } else {
                int firstSegmentLength = 0;
                int secondSegmentLength = 0;
                int thirdSegmentLength = 0;
                if (shapeToBuild == FenceShape.U_SHAPE) {
                    int totalUMaterial = 7 + random.nextInt(6);
                    if (totalUMaterial < 6) {
                        totalUMaterial = 6;
                    }
                    secondSegmentLength = 2 + random.nextInt(Math.max(1, totalUMaterial - 6 + 1));
                    secondSegmentLength = Math.min(secondSegmentLength, totalUMaterial - 4);
                    int remainingForArms = totalUMaterial - secondSegmentLength;
                    firstSegmentLength = 2 + random.nextInt(Math.max(1, remainingForArms - 4 + 1));
                    thirdSegmentLength = remainingForArms - (firstSegmentLength = Math.min(firstSegmentLength, remainingForArms - 2));
                    if (thirdSegmentLength < 2) {
                        int diff = 2 - thirdSegmentLength;
                        thirdSegmentLength = 2;
                        if ((firstSegmentLength -= diff) < 2) {
                            continue;
                        }
                    }
                } else if (shapeToBuild == FenceShape.L_SHAPE) {
                    int totalLMaterial = 4 + random.nextInt(5);
                    if (totalLMaterial < 4) {
                        totalLMaterial = 4;
                    }
                    firstSegmentLength = 2 + random.nextInt(Math.max(1, totalLMaterial - 4 + 1));
                    secondSegmentLength = totalLMaterial - firstSegmentLength;
                } else {
                    firstSegmentLength = 4 + random.nextInt(5);
                }
                BlockPos endOfFirstSegment = this.tryPlaceFenceLine(level, fenceLineStartPos, initialFenceDirection, firstSegmentLength, FENCE_BLOCK_TYPE, anchorCampfirePos, null);
                if (endOfFirstSegment != null) {
                    if (shapeToBuild == FenceShape.STRAIGHT) {
                        successThisAttempt = true;
                    } else if (shapeToBuild == FenceShape.L_SHAPE) {
                        BlockPos endOfL;
                        Direction dirCw = initialFenceDirection.getClockWise();
                        dirCcw = initialFenceDirection.getCounterClockWise();
                        testPointCw = endOfFirstSegment.relative(dirCw, 2);
                        testPointCcw = endOfFirstSegment.relative(dirCcw, 2);
                        Direction firstTurnDirection = testPointCw.distSqr((Vec3i)anchorCampfirePos) <= testPointCcw.distSqr((Vec3i)anchorCampfirePos) ? dirCw : dirCcw;
                        startOfSecondSegCandidate = endOfFirstSegment.relative(firstTurnDirection, 1);
                        groundStartOfSecondSeg = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startOfSecondSegCandidate);
                        successThisAttempt = Math.abs(groundStartOfSecondSeg.getY() - endOfFirstSegment.getY()) <= 1 ? (endOfL = this.tryPlaceFenceLine(level, groundStartOfSecondSeg, firstTurnDirection, secondSegmentLength, FENCE_BLOCK_TYPE, anchorCampfirePos, endOfFirstSegment)) != null : true;
                    } else if (shapeToBuild == FenceShape.U_SHAPE) {
                        BlockPos endOfU;
                        Direction thirdArmDirection;
                        BlockPos startOfThirdSegCandidate;
                        BlockPos groundStartOfThirdSeg;
                        BlockPos endOfSecondSegment;
                        Direction dirCw = initialFenceDirection.getClockWise();
                        dirCcw = initialFenceDirection.getCounterClockWise();
                        testPointCw = endOfFirstSegment.relative(dirCw, 2);
                        testPointCcw = endOfFirstSegment.relative(dirCcw, 2);
                        Direction firstTurnDirection = testPointCw.distSqr((Vec3i)anchorCampfirePos) <= testPointCcw.distSqr((Vec3i)anchorCampfirePos) ? dirCw : dirCcw;
                        startOfSecondSegCandidate = endOfFirstSegment.relative(firstTurnDirection, 1);
                        groundStartOfSecondSeg = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startOfSecondSegCandidate);
                        successThisAttempt = Math.abs(groundStartOfSecondSeg.getY() - endOfFirstSegment.getY()) <= 1 ? ((endOfSecondSegment = this.tryPlaceFenceLine(level, groundStartOfSecondSeg, firstTurnDirection, secondSegmentLength, FENCE_BLOCK_TYPE, anchorCampfirePos, endOfFirstSegment)) != null ? (Math.abs((groundStartOfThirdSeg = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startOfThirdSegCandidate = endOfSecondSegment.relative(thirdArmDirection = initialFenceDirection, 1))).getY() - endOfSecondSegment.getY()) <= 1 ? (endOfU = this.tryPlaceFenceLine(level, groundStartOfThirdSeg, thirdArmDirection, thirdSegmentLength, FENCE_BLOCK_TYPE, anchorCampfirePos, endOfSecondSegment)) != null : true) : true) : true;
                    }
                } else {
                    successThisAttempt = false;
                }
            }
            if (!successThisAttempt) continue;
            level.playSound(null, fenceLineStartPos, SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 0.8f, 1.0f + random.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos tryPlaceFenceLine(ServerLevel level, BlockPos lineStartGroundPos, Direction direction, int length, Block fenceBlock, BlockPos campCenter, @Nullable BlockPos segmentToConnectTo) {
        if (length < 2 && (length <= 0 || segmentToConnectTo == null) && length < 1) {
            return null;
        }
        int fencesPlacedCount = 0;
        BlockPos lastSuccessfullyPlacedPos = null;
        BlockPos previousFenceActualPos = lineStartGroundPos.relative(direction.getOpposite(), 1);
        for (int i = 0; i < length; ++i) {
            int yDiff;
            BlockPos currentTargetAbstractPos = lineStartGroundPos.relative(direction, i);
            BlockPos currentPlacementActualPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, currentTargetAbstractPos);
            if (currentPlacementActualPos.distManhattan((Vec3i)campCenter) < 5 && i < 2 && segmentToConnectTo == null) {
                if (fencesPlacedCount >= 2) break;
                return lastSuccessfullyPlacedPos;
            }
            BlockState blockBelowState = level.getBlockState(currentPlacementActualPos.below());
            if (!blockBelowState.isFaceSturdy((BlockGetter)level, currentPlacementActualPos.below(), Direction.UP)) {
                if (fencesPlacedCount >= 2) break;
                if (i != 0 || fencesPlacedCount != 0) continue;
                return null;
            }
            BlockState currentBlockState = level.getBlockState(currentPlacementActualPos);
            if (!(currentBlockState.isAir() || currentBlockState.canBeReplaced() || currentBlockState.is(Blocks.SNOW) || currentBlockState.is(fenceBlock))) {
                if (fencesPlacedCount >= 2) break;
                if (i != 0 || fencesPlacedCount != 0) continue;
                return null;
            }
            if (!level.isEmptyBlock(currentPlacementActualPos.above()) && !level.getBlockState(currentPlacementActualPos.above()).is(fenceBlock)) {
                if (fencesPlacedCount >= 2) break;
                if (i != 0 || fencesPlacedCount != 0) continue;
                return null;
            }
            if ((fencesPlacedCount > 0 || i > 0 && previousFenceActualPos != null) && (yDiff = Math.abs(currentPlacementActualPos.getY() - previousFenceActualPos.getY())) > 1) break;
            if (!level.getBlockState(currentPlacementActualPos).is(fenceBlock)) {
                level.setBlock(currentPlacementActualPos, fenceBlock.defaultBlockState(), 3);
            }
            ++fencesPlacedCount;
            lastSuccessfullyPlacedPos = currentPlacementActualPos;
            previousFenceActualPos = currentPlacementActualPos;
        }
        int requiredMin = segmentToConnectTo != null ? 1 : 2;
        return fencesPlacedCount >= requiredMin ? lastSuccessfullyPlacedPos : null;
    }

    private boolean tryPlaceZigZagFence(ServerLevel level, BlockPos initialStartPos, Direction initialDirection, RandomSource random, BlockPos campCenter) {
        int maxSegmentsToPlace = 3 + random.nextInt(3);
        boolean segmentLength = true;
        int minSuccessfulSegments = 2;
        BlockPos currentSegmentEndPos = initialStartPos;
        currentSegmentEndPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, currentSegmentEndPos);
        Direction currentDirection = initialDirection;
        TurnType lastActualTurn = TurnType.NONE;
        int segmentsSuccessfullyPlaced = 0;
        for (int i = 0; i < maxSegmentsToPlace; ++i) {
            BlockPos segmentPlacedPos = this.tryPlaceFenceLine(level, currentSegmentEndPos, currentDirection, 1, FENCE_BLOCK_TYPE, campCenter, (BlockPos)(segmentsSuccessfullyPlaced > 0 ? currentSegmentEndPos : null));
            if (segmentPlacedPos == null) {
                if (i != 0) break;
                return false;
            }
            ++segmentsSuccessfullyPlaced;
            BlockPos previousSegmentEndForYCheck = currentSegmentEndPos;
            currentSegmentEndPos = segmentPlacedPos;
            if (i == maxSegmentsToPlace - 1) break;
            ArrayList<TurnType> availableNextTurns = new ArrayList<TurnType>();
            if (lastActualTurn != TurnType.LEFT) {
                availableNextTurns.add(TurnType.LEFT);
            }
            if (lastActualTurn != TurnType.RIGHT) {
                availableNextTurns.add(TurnType.RIGHT);
            }
            availableNextTurns.add(TurnType.STRAIGHT);
            if (availableNextTurns.isEmpty()) break;
            TurnType chosenTurn = (TurnType)((Object)availableNextTurns.get(random.nextInt(availableNextTurns.size())));
            Direction nextDirectionCandidate = currentDirection;
            if (chosenTurn == TurnType.LEFT) {
                nextDirectionCandidate = currentDirection.getCounterClockWise();
                lastActualTurn = TurnType.LEFT;
            } else if (chosenTurn == TurnType.RIGHT) {
                nextDirectionCandidate = currentDirection.getClockWise();
                lastActualTurn = TurnType.RIGHT;
            } else {
                lastActualTurn = TurnType.STRAIGHT;
            }
            currentDirection = nextDirectionCandidate;
            BlockPos nextPotentialStartPos = currentSegmentEndPos.relative(currentDirection);
            BlockPos nextSegmentGroundStartPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, nextPotentialStartPos);
            if (Math.abs(nextSegmentGroundStartPos.getY() - currentSegmentEndPos.getY()) > 1) break;
            currentSegmentEndPos = nextSegmentGroundStartPos;
        }
        return segmentsSuccessfullyPlaced >= 2;
    }

    private static enum FenceShape {
        STRAIGHT,
        L_SHAPE,
        U_SHAPE,
        ZIG_ZAG;

    }

    private static enum TurnType {
        NONE,
        LEFT,
        RIGHT,
        STRAIGHT;

    }
}

