/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class WanderNearCampfireGoal
extends Goal {
    protected final GenshinEntity mob;
    private final double speedModifier;
    @Nullable
    private BlockPos anchorCampfirePos;
    @Nullable
    private Vec3 targetPos;
    private final int wanderExecutionChance;
    private static final double WANDER_RADIUS_NEAR_CAMP = 24.0;
    private static final double WANDER_APPROACH_THRESHOLD_SQ = 400.0;
    private static final double RETURN_TO_CAMP_TRIGGER_DISTANCE_SQ = 576.0;
    private static final double RETURN_TO_CAMP_MAX_SEARCH_RADIUS = 64.0;
    private static final double RETURN_TO_CAMP_TARGET_OFFSET = 4.0;
    private int returnToCampCooldownTicks;
    private static final int RETURN_TO_CAMP_COOLDOWN_BASE = 300;
    private static final int RETURN_TO_CAMP_COOLDOWN_RANDOM = 200;
    private boolean isReturningToSpecificCamp;

    public WanderNearCampfireGoal(GenshinEntity mob, double speedModifier) {
        this(mob, speedModifier, 100);
    }

    public WanderNearCampfireGoal(GenshinEntity mob, double speedModifier, int wanderExecutionChance) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.wanderExecutionChance = Math.max(1, wanderExecutionChance);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.returnToCampCooldownTicks = mob.getRandom().nextInt(75);
    }

    private Optional<BlockPos> findSpecificHilichurlCampfire(double radius) {
        if (this.mob.level().isClientSide()) {
            return Optional.empty();
        }
        return BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)((int)radius), (int)((int)(radius / 2.0)), pos -> {
            BlockState blockState = this.mob.level().getBlockState(pos);
            return blockState.is(ModBlocks.HILICHURL_CAMPFIRE.get()) && blockState.hasProperty((Property)CampfireBlock.LIT) && (Boolean)blockState.getValue((Property)CampfireBlock.LIT) != false;
        });
    }

    private Optional<BlockPos> findAnyNearbyLitCampfireForWandering(double radius) {
        return GenshinEntity.findClosestLitCampfire((LivingEntity)this.mob, radius);
    }

    @Nullable
    private Vec3 findSafeSpotNearTarget(BlockPos targetBlock, double desiredDistance) {
        RandomSource random = this.mob.getRandom();
        for (int i = 0; i < 10; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int xOff = (int)(Math.cos(angle) * desiredDistance);
            int zOff = (int)(Math.sin(angle) * desiredDistance);
            BlockPos potentialNavPos = targetBlock.offset(xOff, 0, zOff);
            BlockPos groundPos = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, potentialNavPos);
            if (!this.mob.level().getBlockState(groundPos.below()).isFaceSturdy((BlockGetter)this.mob.level(), groundPos.below(), Direction.UP) || !this.mob.level().isEmptyBlock(groundPos) || !this.mob.level().isEmptyBlock(groundPos.above()) || groundPos.equals((Object)targetBlock)) continue;
            return Vec3.atBottomCenterOf((Vec3i)groundPos);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = targetBlock.relative(dir, (int)Math.ceil(desiredDistance));
            BlockPos groundPos = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, adjacentPos);
            if (!this.mob.level().getBlockState(groundPos.below()).isFaceSturdy((BlockGetter)this.mob.level(), groundPos.below(), Direction.UP) || !this.mob.level().isEmptyBlock(groundPos) || !this.mob.level().isEmptyBlock(groundPos.above()) || groundPos.equals((Object)targetBlock)) continue;
            return Vec3.atBottomCenterOf((Vec3i)groundPos);
        }
        return null;
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null || this.mob.isVehicle() || !this.mob.onGround()) {
            return false;
        }
        if (this.mob.isLeader() && (this.mob.isPatrolGoalActive() || this.mob.isCampfireRitualGoalActive())) {
            return false;
        }
        if (!this.mob.isLeader() && this.mob.isFollowingLeaderGoalActive()) {
            return false;
        }
        if (this.returnToCampCooldownTicks > 0) {
            --this.returnToCampCooldownTicks;
        } else {
            Vec3 navPoint;
            BlockPos campPos;
            this.returnToCampCooldownTicks = 300 + this.mob.getRandom().nextInt(200);
            Optional<BlockPos> specificCampOpt = this.findSpecificHilichurlCampfire(64.0);
            if (specificCampOpt.isPresent() && this.mob.distanceToSqr(Vec3.atCenterOf((Vec3i)(campPos = specificCampOpt.get()))) > 576.0 && (navPoint = this.findSafeSpotNearTarget(campPos, 4.0)) != null) {
                this.anchorCampfirePos = campPos;
                this.targetPos = navPoint;
                this.isReturningToSpecificCamp = true;
                return true;
            }
        }
        this.isReturningToSpecificCamp = false;
        if (this.mob.getRandom().nextInt(this.wanderExecutionChance) != 0) {
            return false;
        }
        Optional<BlockPos> foundAnyCampOpt = this.findAnyNearbyLitCampfireForWandering(24.0);
        if (!foundAnyCampOpt.isPresent()) {
            this.anchorCampfirePos = null;
            return false;
        }
        this.anchorCampfirePos = foundAnyCampOpt.get();
        if (this.mob.distanceToSqr(Vec3.atCenterOf((Vec3i)this.anchorCampfirePos)) <= 400.0) {
            this.targetPos = this.findRandomTargetInCampRadius(false);
        } else {
            this.targetPos = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)Vec3.atCenterOf((Vec3i)this.anchorCampfirePos), (double)1.5707963267948966);
            if (this.targetPos == null) {
                this.targetPos = this.findRandomTargetInCampRadius(true);
            }
        }
        return this.targetPos != null;
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null || this.mob.isVehicle() || this.anchorCampfirePos == null) {
            return false;
        }
        if (this.mob.isLeader() && (this.mob.isPatrolGoalActive() || this.mob.isCampfireRitualGoalActive())) {
            return false;
        }
        if (!this.mob.isLeader() && this.mob.isFollowingLeaderGoalActive()) {
            return false;
        }
        BlockState anchorState = this.mob.level().getBlockState(this.anchorCampfirePos);
        boolean anchorValid = (anchorState.is(ModBlocks.HILICHURL_CAMPFIRE.get()) || anchorState.is(Blocks.CAMPFIRE)) && anchorState.hasProperty((Property)CampfireBlock.LIT) && (Boolean)anchorState.getValue((Property)CampfireBlock.LIT) != false;
        return anchorValid && !this.mob.getNavigation().isDone();
    }

    public void start() {
        if (this.targetPos != null) {
            this.mob.getNavigation().moveTo(this.targetPos.x, this.targetPos.y, this.targetPos.z, this.speedModifier);
            if (this.isReturningToSpecificCamp && this.anchorCampfirePos != null) {
                this.mob.getLookControl().setLookAt((double)this.anchorCampfirePos.getX() + 0.5, (double)((float)this.anchorCampfirePos.getY() + this.mob.getEyeHeight()), (double)this.anchorCampfirePos.getZ() + 0.5, 10.0f, (float)this.mob.getMaxHeadXRot());
            } else {
                this.mob.getLookControl().setLookAt(this.targetPos.x, this.targetPos.y + (double)this.mob.getEyeHeight(), this.targetPos.z, 10.0f, (float)this.mob.getMaxHeadXRot());
            }
        }
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.targetPos = null;
        this.anchorCampfirePos = null;
        this.isReturningToSpecificCamp = false;
    }

    public void tick() {
        if (this.anchorCampfirePos == null) {
            return;
        }
        if (!this.mob.getNavigation().isDone()) {
            if (this.isReturningToSpecificCamp && this.anchorCampfirePos != null) {
                this.mob.getLookControl().setLookAt((double)this.anchorCampfirePos.getX() + 0.5, (double)((float)this.anchorCampfirePos.getY() + this.mob.getEyeHeight()), (double)this.anchorCampfirePos.getZ() + 0.5, 10.0f, (float)this.mob.getMaxHeadXRot());
            } else if (this.targetPos != null) {
                this.mob.getLookControl().setLookAt(this.targetPos.x, this.targetPos.y + (double)this.mob.getEyeHeight(), this.targetPos.z, 10.0f, (float)this.mob.getMaxHeadXRot());
            }
        }
        if (this.mob.getNavigation().isDone() && this.isReturningToSpecificCamp) {
            this.isReturningToSpecificCamp = false;
        }
    }

    @Nullable
    protected Vec3 findRandomTargetInCampRadius(boolean isFallbackFromApproach) {
        if (this.anchorCampfirePos == null) {
            return null;
        }
        RandomSource random = this.mob.getRandom();
        for (int i = 0; i < 10; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double radiusFactor = isFallbackFromApproach ? 0.9 : Math.sqrt(random.nextDouble());
            double radius = radiusFactor * 24.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            BlockPos potentialTargetBlockPos = BlockPos.containing((double)((double)this.anchorCampfirePos.getX() + offsetX), (double)this.anchorCampfirePos.getY(), (double)((double)this.anchorCampfirePos.getZ() + offsetZ));
            Vec3 pathablePos = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)10, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)potentialTargetBlockPos), (double)Math.PI);
            if (pathablePos == null || !(Vec3.atCenterOf((Vec3i)this.anchorCampfirePos).distanceToSqr(pathablePos) <= 576.0)) continue;
            return pathablePos;
        }
        return null;
    }
}

