/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal.ambient;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.ai.goal.ambient.AmbientBehaviorParameters;
import net.zenith.hoyocraft.entity.ai.goal.ambient.TimedLoopingParticleConfig;
import net.zenith.hoyocraft.entity.ai.goal.ambient.TimedLoopingSoundConfig;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class AmbientBehaviorGoal
extends Goal {
    protected final GenshinEntity entity;
    private final RandomSource random;
    private AmbientBehaviorParameters currentBehaviorParams;
    private int behaviorTickCounter;
    private int awarenessScanCooldown;

    public AmbientBehaviorGoal(GenshinEntity entity) {
        this.entity = entity;
        this.random = entity.getRandom();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.entity.getTarget() != null || this.entity.isVehicle() || !this.entity.onGround() || this.entity.isPerformingAmbientBehavior() || this.entity.isAttackingGeckoLib() || this.entity.getTimeUntilNextAmbientBehavior() > 0) {
            return false;
        }
        List<AmbientBehaviorParameters> availableBehaviors = this.entity.getAmbientBehaviors();
        if (availableBehaviors == null || availableBehaviors.isEmpty()) {
            return false;
        }
        AmbientBehaviorParameters selectedBehavior = availableBehaviors.get(this.random.nextInt(availableBehaviors.size()));
        if (this.random.nextFloat() < 0.5f) {
            this.entity.resetAmbientBehaviorCooldown(false);
            this.currentBehaviorParams = null;
            return false;
        }
        this.currentBehaviorParams = selectedBehavior;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.entity.getTarget() != null || this.currentBehaviorParams == null) {
            return false;
        }
        return this.behaviorTickCounter < this.currentBehaviorParams.totalBehaviorDurationTicks();
    }

    public void start() {
        this.behaviorTickCounter = 0;
        this.awarenessScanCooldown = 0;
        this.entity.getNavigation().stop();
        this.entity.onAmbientBehaviorStarted(this.currentBehaviorParams);
        this.entity.resetAmbientBehaviorCooldown(false);
    }

    public void stop() {
        this.entity.onAmbientBehaviorStopped(this.currentBehaviorParams);
        if (!this.entity.level().isClientSide()) {
            this.entity.getNavigation().stop();
            this.entity.setDeltaMovement(0.0, this.entity.getDeltaMovement().y, 0.0);
        }
        this.currentBehaviorParams = null;
        this.behaviorTickCounter = 0;
    }

    public void tick() {
        Object object;
        if (this.currentBehaviorParams == null) {
            return;
        }
        this.entity.getNavigation().stop();
        --this.awarenessScanCooldown;
        if (this.awarenessScanCooldown <= 0) {
            this.awarenessScanCooldown = 100;
            this.scanForHostiles();
            if (this.entity.getTarget() != null) {
                return;
            }
        }
        for (TimedLoopingSoundConfig soundConfig : this.currentBehaviorParams.timedLoopingSounds()) {
            if (this.behaviorTickCounter < soundConfig.segmentStartTimeTicks() || this.behaviorTickCounter >= soundConfig.segmentStartTimeTicks() + soundConfig.segmentDurationTicks()) continue;
            if (soundConfig.loopIntervalTicks() <= 0) {
                if (this.behaviorTickCounter != soundConfig.segmentStartTimeTicks()) continue;
                this.entity.level().playSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), soundConfig.soundEvent(), soundConfig.soundSource(), soundConfig.volume(), soundConfig.pitch());
                continue;
            }
            if ((this.behaviorTickCounter - soundConfig.segmentStartTimeTicks()) % soundConfig.loopIntervalTicks() != 0) continue;
            this.entity.level().playSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), soundConfig.soundEvent(), soundConfig.soundSource(), soundConfig.volume(), soundConfig.pitch());
        }
        if (!this.entity.level().isClientSide() && (object = this.entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            for (TimedLoopingParticleConfig particleConfig : this.currentBehaviorParams.timedLoopingParticles()) {
                if (this.behaviorTickCounter < particleConfig.segmentStartTimeTicks() || this.behaviorTickCounter >= particleConfig.segmentStartTimeTicks() + particleConfig.segmentDurationTicks()) continue;
                if (particleConfig.loopIntervalTicks() <= 0) {
                    if (this.behaviorTickCounter != particleConfig.segmentStartTimeTicks()) continue;
                    this.spawnParticles(serverLevel, particleConfig);
                    continue;
                }
                if ((this.behaviorTickCounter - particleConfig.segmentStartTimeTicks()) % particleConfig.loopIntervalTicks() != 0) continue;
                this.spawnParticles(serverLevel, particleConfig);
            }
        }
        ++this.behaviorTickCounter;
    }

    private void spawnParticles(ServerLevel serverLevel, TimedLoopingParticleConfig config) {
        Vec3 entityPos = this.entity.position();
        double spawnX = entityPos.x() + config.offset().x();
        double spawnY = entityPos.y() + config.offset().y();
        double spawnZ = entityPos.z() + config.offset().z();
        serverLevel.sendParticles(config.particleOptions(), spawnX, spawnY, spawnZ, config.count(), config.spreadX(), config.spreadY(), config.spreadZ(), config.speed());
    }

    private void scanForHostiles() {
        if (this.currentBehaviorParams == null || this.currentBehaviorParams.awarenessRangeBlocks() <= 0.0f) {
            return;
        }
        List nearbyEntities = this.entity.level().getEntitiesOfClass(LivingEntity.class, this.entity.getBoundingBox().inflate((double)this.currentBehaviorParams.awarenessRangeBlocks()), e -> {
            Player p;
            return !(!e.isAlive() || this.entity.isGenshinFriend((LivingEntity)e) || !(e instanceof Player) && !(e instanceof Monster) || !this.entity.hasLineOfSight((Entity)e) || e.isSpectator() || e instanceof Player && (p = (Player)e).isCreative());
        });
        if (!nearbyEntities.isEmpty()) {
            LivingEntity newTarget = (LivingEntity)nearbyEntities.get(0);
            this.entity.setTarget(newTarget);
        }
    }

    public boolean isInterruptable() {
        return true;
    }
}

