/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal.vanillamonster;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zenith.hoyocraft.block.ModBlocks;

public class BreakHilichurlCampfireGoal
extends Goal {
    private final Mob mob;
    private BlockPos targetCampfirePos;
    private int breakingTick;
    private final int timeToBreak;
    private int lastBreakProgressSent;
    private static final double BREAKING_DISTANCE_SQR = 4.0;

    public BreakHilichurlCampfireGoal(Mob mob, int timeToBreak) {
        this.mob = mob;
        this.timeToBreak = Math.max(20, timeToBreak);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        Optional<BlockPos> closestCampfire = this.findNearbyLitCampfireToBreak();
        if (closestCampfire.isPresent()) {
            this.targetCampfirePos = closestCampfire.get();
            return true;
        }
        this.targetCampfirePos = null;
        return false;
    }

    private Optional<BlockPos> findNearbyLitCampfireToBreak() {
        return BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)2, (int)1, pos -> {
            BlockState state = this.mob.level().getBlockState(pos);
            return state.is(ModBlocks.HILICHURL_CAMPFIRE.get()) && state.hasProperty((Property)CampfireBlock.LIT) && (Boolean)state.getValue((Property)CampfireBlock.LIT) != false && this.mob.getNavigation().createPath(pos, 0) != null;
        });
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null || this.targetCampfirePos == null || this.breakingTick >= this.timeToBreak) {
            return false;
        }
        BlockState state = this.mob.level().getBlockState(this.targetCampfirePos);
        return state.is(ModBlocks.HILICHURL_CAMPFIRE.get()) && (Boolean)state.getValue((Property)CampfireBlock.LIT) != false && this.mob.blockPosition().distSqr((Vec3i)this.targetCampfirePos) <= 6.0;
    }

    public void start() {
        this.breakingTick = 0;
        this.lastBreakProgressSent = -1;
        this.mob.getNavigation().stop();
    }

    public void stop() {
        if (this.targetCampfirePos != null && this.breakingTick < this.timeToBreak) {
            this.mob.level().destroyBlockProgress(this.mob.getId(), this.targetCampfirePos, -1);
        }
        this.breakingTick = 0;
        this.lastBreakProgressSent = -1;
        this.targetCampfirePos = null;
    }

    public void tick() {
        Level level;
        int progress;
        if (this.targetCampfirePos == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((double)this.targetCampfirePos.getX() + 0.5, (double)this.targetCampfirePos.getY() + 0.5, (double)this.targetCampfirePos.getZ() + 0.5);
        this.mob.getNavigation().stop();
        ++this.breakingTick;
        if (this.breakingTick % 10 == 0) {
            this.mob.swing(InteractionHand.MAIN_HAND);
        }
        if ((progress = (int)((float)this.breakingTick / (float)this.timeToBreak * 10.0f)) != this.lastBreakProgressSent) {
            this.mob.level().destroyBlockProgress(this.mob.getId(), this.targetCampfirePos, progress);
            this.lastBreakProgressSent = progress;
        }
        if (this.breakingTick >= this.timeToBreak && (level = this.mob.level()).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            level.destroyBlock(this.targetCampfirePos, true, (Entity)this.mob);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

