/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.ai.goal.vanillamonster;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.zenith.hoyocraft.block.ModBlocks;

public class FindAndMoveToHilichurlCampfireGoal
extends Goal {
    private final Mob mob;
    private final double speedModifier;
    private final int searchRadius;
    private int searchCooldown;
    private BlockPos targetCampfirePos;
    private boolean reachedTarget;
    private static final int DEFAULT_SEARCH_COOLDOWN = 200;
    private static final double REACHED_DISTANCE_SQR = 4.0;

    public FindAndMoveToHilichurlCampfireGoal(Mob mob, double speedModifier, int searchRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.searchRadius = searchRadius;
        this.searchCooldown = mob.getRandom().nextInt(50);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        this.searchCooldown = 200 + this.mob.getRandom().nextInt(100);
        Optional<BlockPos> foundPos = this.findNearestLitHilichurlCampfire();
        if (foundPos.isPresent()) {
            this.targetCampfirePos = foundPos.get();
            Path path = this.mob.getNavigation().createPath(this.targetCampfirePos, 0);
            return path != null && path.canReach();
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null || this.targetCampfirePos == null || this.reachedTarget) {
            return false;
        }
        BlockState state = this.mob.level().getBlockState(this.targetCampfirePos);
        return state.is(ModBlocks.HILICHURL_CAMPFIRE.get()) && (Boolean)state.getValue((Property)CampfireBlock.LIT) != false;
    }

    public void start() {
        if (this.targetCampfirePos != null) {
            this.mob.getNavigation().moveTo((double)this.targetCampfirePos.getX() + 0.5, (double)this.targetCampfirePos.getY(), (double)this.targetCampfirePos.getZ() + 0.5, this.speedModifier);
        }
        this.reachedTarget = false;
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.targetCampfirePos = null;
    }

    public void tick() {
        if (this.targetCampfirePos == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((double)this.targetCampfirePos.getX() + 0.5, (double)this.targetCampfirePos.getY() + 0.5, (double)this.targetCampfirePos.getZ() + 0.5, 10.0f, (float)this.mob.getMaxHeadXRot());
        if (this.mob.blockPosition().distSqr((Vec3i)this.targetCampfirePos) <= 4.0) {
            this.reachedTarget = true;
        } else if (this.mob.getNavigation().isDone() && !this.reachedTarget) {
            this.mob.getNavigation().moveTo((double)this.targetCampfirePos.getX() + 0.5, (double)this.targetCampfirePos.getY(), (double)this.targetCampfirePos.getZ() + 0.5, this.speedModifier);
        }
    }

    private Optional<BlockPos> findNearestLitHilichurlCampfire() {
        Level level = this.mob.level();
        BlockPos mobPos = this.mob.blockPosition();
        return BlockPos.findClosestMatch((BlockPos)mobPos, (int)this.searchRadius, (int)(this.searchRadius / 2), currentPos -> {
            BlockState state = level.getBlockState(currentPos);
            return state.is(ModBlocks.HILICHURL_CAMPFIRE.get()) && state.hasProperty((Property)CampfireBlock.LIT) && (Boolean)state.getValue((Property)CampfireBlock.LIT) != false;
        });
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

