/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.client.model.finch;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.zenith.hoyocraft.entity.custom.animal.birds.finch.FinchEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class FinchGeoModel
extends GeoModel<FinchEntity> {
    private ResourceLocation buildEntityLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)path);
    }

    public ResourceLocation getModelResource(FinchEntity animatable) {
        return this.buildEntityLoc("geo/entity/finch.geo.json");
    }

    public ResourceLocation getTextureResource(FinchEntity finch) {
        FinchEntity.Variant variant = finch.getVariant();
        switch (variant) {
            case EMERALD: {
                return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/entity/finch/emerald_finch.png");
            }
            case CRIMSON: {
                return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/entity/finch/crimson_finch.png");
            }
            case SNOW: {
                return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/entity/finch/snow_finch.png");
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/entity/finch/golden_finch.png");
    }

    public ResourceLocation getAnimationResource(FinchEntity animatable) {
        return this.buildEntityLoc("animations/entity/finch.animation.json");
    }

    public void setCustomAnimations(FinchEntity animatable, long instanceId, AnimationState<FinchEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        this.getBone("head").ifPresent(headBone -> {
            FinchEntity entity = (FinchEntity)animationState.getAnimatable();
            float partialTick = animationState.getPartialTick();
            float yawDifference = Mth.wrapDegrees((float)(Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot) - Mth.rotLerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot)));
            float pitchRotation = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
            headBone.setRotX(-pitchRotation * ((float)Math.PI / 180));
            headBone.setRotY(-yawDifference * ((float)Math.PI / 180));
            headBone.setRotZ(0.0f);
        });
    }
}

