/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.client.model.hilichurl;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.HilichurlEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class HilichurlGeoModel
extends GeoModel<HilichurlEntity> {
    public static final String HURT_ANIM_ONE_NAME = "hilichurl.animation.hurt";
    public static final String HURT_ANIM_TWO_NAME = "hilichurl.animation.hurttwo";
    public static final String HURT_ANIM_THREE_NAME = "hilichurl.animation.hurtthree";

    private ResourceLocation buildEntityLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)path);
    }

    public ResourceLocation getModelResource(HilichurlEntity animatable) {
        return this.buildEntityLoc("geo/entity/hilichurl.geo.json");
    }

    public ResourceLocation getTextureResource(HilichurlEntity animatable) {
        return this.buildEntityLoc("textures/entity/hilichurl.png");
    }

    public ResourceLocation getAnimationResource(HilichurlEntity animatable) {
        return this.buildEntityLoc("animations/entity/hilichurl.animation.json");
    }

    public void setCustomAnimations(HilichurlEntity animatable, long instanceId, AnimationState<HilichurlEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        this.getBone("head").ifPresent(headBone -> {
            HilichurlEntity entity = (HilichurlEntity)animationState.getAnimatable();
            float partialTick = animationState.getPartialTick();
            float yawDifference = Mth.wrapDegrees((float)(Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot) - Mth.rotLerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot)));
            float pitchRotation = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
            headBone.setRotX(-pitchRotation * ((float)Math.PI / 180));
            headBone.setRotY(-yawDifference * ((float)Math.PI / 180));
            headBone.setRotZ(0.0f);
        });
    }
}

