/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.client.model.slime;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.zenith.hoyocraft.entity.custom.elemental.slime.CryoSlimeEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.model.GeoModel;

public class CryoSlimeGeoModel
extends GeoModel<CryoSlimeEntity> {
    public static final RawAnimation HURT_ANIM_ONE = RawAnimation.begin().thenPlay("hydro_slime.animation.hurt");
    public static final RawAnimation HURT_ANIM_TWO = RawAnimation.begin().thenPlay("hydro_slime.animation.hurttwo");
    public static final RawAnimation HURT_ANIM_THREE = RawAnimation.begin().thenPlay("hydro_slime.animation.hurtthree");
    public static final String HURT_ANIM_ONE_NAME = "hydro_slime.animation.hurt";
    public static final String HURT_ANIM_TWO_NAME = "hydro_slime.animation.hurttwo";
    public static final String HURT_ANIM_THREE_NAME = "hydro_slime.animation.hurtthree";

    private ResourceLocation buildEntityLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)path);
    }

    public ResourceLocation getModelResource(CryoSlimeEntity animatable) {
        return this.buildEntityLoc("geo/entity/cryo_slime.geo.json");
    }

    public ResourceLocation getTextureResource(CryoSlimeEntity animatable) {
        return this.buildEntityLoc("textures/entity/cryo_slime.png");
    }

    public ResourceLocation getAnimationResource(CryoSlimeEntity animatable) {
        return this.buildEntityLoc("animations/entity/cryo_slime.animation.json");
    }

    public void setCustomAnimations(CryoSlimeEntity animatable, long instanceId, AnimationState<CryoSlimeEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        this.getBone("head").ifPresent(mainBodyBone -> {
            CryoSlimeEntity entity = (CryoSlimeEntity)animationState.getAnimatable();
            float partialTick = animationState.getPartialTick();
            float yawDifference = Mth.wrapDegrees((float)(Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot) - Mth.rotLerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot)));
            mainBodyBone.setRotY(-yawDifference * ((float)Math.PI / 180));
            mainBodyBone.setRotZ(0.0f);
        });
    }
}

