/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.client.model.slime;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.zenith.hoyocraft.entity.custom.elemental.slime.DendroSlimeEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class DendroSlimeGeoModel
extends GeoModel<DendroSlimeEntity> {
    private ResourceLocation buildEntityLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)path);
    }

    public ResourceLocation getModelResource(DendroSlimeEntity animatable) {
        return this.buildEntityLoc("geo/entity/dendro_slime.geo.json");
    }

    public ResourceLocation getTextureResource(DendroSlimeEntity animatable) {
        if (animatable.isBurnt()) {
            return ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/entity/dendro_slime_noleaf.png");
        }
        return this.buildEntityLoc("textures/entity/dendro_slime.png");
    }

    public ResourceLocation getAnimationResource(DendroSlimeEntity animatable) {
        return this.buildEntityLoc("animations/entity/dendro_slime.animation.json");
    }

    public void setCustomAnimations(DendroSlimeEntity animatable, long instanceId, AnimationState<DendroSlimeEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        this.getBone("head").ifPresent(mainBodyBone -> {
            DendroSlimeEntity entity = (DendroSlimeEntity)animationState.getAnimatable();
            float partialTick = animationState.getPartialTick();
            float yawDifference = Mth.wrapDegrees((float)(Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot) - Mth.rotLerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot)));
            mainBodyBone.setRotY(-yawDifference * ((float)Math.PI / 180));
            mainBodyBone.setRotZ(0.0f);
        });
    }
}

