/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class AggroIndicatorRenderLayer<T extends GenshinEntity, M extends GeoModel<T>>
extends GeoRenderLayer<T> {
    public AggroIndicatorRenderLayer(GeoRenderer<T> geoRenderer) {
        super(geoRenderer);
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        GeoBone overlayBone = bakedModel.getBone("overlay").orElse(null);
        if (((GenshinEntity)((Object)animatable)).isShowingAggroIndicator() && overlayBone != null) {
            poseStack.pushPose();
            poseStack.mulPose(overlayBone.getModelSpaceMatrix());
            float offsetY = 1.0f;
            float offsetZ = 0.0f;
            float offsetX = 0.0f;
            float scale = 0.4f;
            poseStack.translate(offsetX, offsetY, offsetZ);
            poseStack.scale(scale, scale, scale);
            Matrix4f modelViewMatrix = poseStack.last().pose();
            Matrix3f normalMatrix = poseStack.last().normal();
            float halfSize = 0.5f;
            int color = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
            Vector3f localNormal = new Vector3f(0.0f, 0.0f, 1.0f);
            ResourceLocation indicatorTexture = ResourceLocation.fromNamespaceAndPath((String)"hoyocraft", (String)"textures/gui/aggro_indicator.png");
            RenderType renderTypeIndicator = RenderType.entityCutoutNoCull((ResourceLocation)indicatorTexture);
            VertexConsumer indicatorBuffer = bufferSource.getBuffer(renderTypeIndicator);
            Vector3f pos1 = modelViewMatrix.transformPosition(new Vector3f(-halfSize, -halfSize, 0.0f));
            Vector3f normal1 = normalMatrix.transform(new Vector3f((Vector3fc)localNormal));
            indicatorBuffer.addVertex(pos1.x(), pos1.y(), pos1.z(), color, 0.0f, 1.0f, packedOverlay, packedLight, normal1.x(), normal1.y(), normal1.z());
            Vector3f pos2 = modelViewMatrix.transformPosition(new Vector3f(halfSize, -halfSize, 0.0f));
            Vector3f normal2 = normalMatrix.transform(new Vector3f((Vector3fc)localNormal));
            indicatorBuffer.addVertex(pos2.x(), pos2.y(), pos2.z(), color, 1.0f, 1.0f, packedOverlay, packedLight, normal2.x(), normal2.y(), normal2.z());
            Vector3f pos3 = modelViewMatrix.transformPosition(new Vector3f(halfSize, halfSize, 0.0f));
            Vector3f normal3 = normalMatrix.transform(new Vector3f((Vector3fc)localNormal));
            indicatorBuffer.addVertex(pos3.x(), pos3.y(), pos3.z(), color, 1.0f, 0.0f, packedOverlay, packedLight, normal3.x(), normal3.y(), normal3.z());
            Vector3f pos4 = modelViewMatrix.transformPosition(new Vector3f(-halfSize, halfSize, 0.0f));
            Vector3f normal4 = normalMatrix.transform(new Vector3f((Vector3fc)localNormal));
            indicatorBuffer.addVertex(pos4.x(), pos4.y(), pos4.z(), color, 0.0f, 0.0f, packedOverlay, packedLight, normal4.x(), normal4.y(), normal4.z());
            poseStack.popPose();
        }
    }
}

