/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.zenith.hoyocraft.entity.custom.elemental.slime.ElectroSlimeEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ConditionalAutoGlowingGeoLayer<T extends ElectroSlimeEntity>
extends GeoRenderLayer<T> {
    public ConditionalAutoGlowingGeoLayer(GeoRenderer<T> entityRendererIn) {
        super(entityRendererIn);
    }

    protected ResourceLocation getActualGlowTextureLocation(T animatable) {
        ResourceLocation baseTexture = this.renderer.getTextureLocation(animatable);
        String path = baseTexture.getPath();
        String glowPath = path.substring(0, path.lastIndexOf(46)) + "_glowmask" + path.substring(path.lastIndexOf(46));
        return ResourceLocation.fromNamespaceAndPath((String)baseTexture.getNamespace(), (String)glowPath);
    }

    protected RenderType getActualGlowRenderType(T animatable) {
        return RenderType.eyes((ResourceLocation)this.getActualGlowTextureLocation(animatable));
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType originalRenderType, MultiBufferSource bufferSource, VertexConsumer originalBuffer, float partialTick, int packedLight, int packedOverlay) {
        if (!((ElectroSlimeEntity)animatable).isCharged()) {
            return;
        }
        RenderType emissiveRenderType = this.getActualGlowRenderType(animatable);
        VertexConsumer emissiveBuffer = bufferSource.getBuffer(emissiveRenderType);
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, animatable, emissiveRenderType, emissiveBuffer, partialTick, packedLight, OverlayTexture.NO_OVERLAY, -1);
    }
}

