/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.api.capability.shield.IShield;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.capability.ShieldCapability;
import net.zenith.hoyocraft.entity.ai.goal.HilichurlCampGoal;
import net.zenith.hoyocraft.entity.ai.goal.HilichurlFollowLeaderGoal;
import net.zenith.hoyocraft.entity.ai.goal.HilichurlLeaderPatrolGoal;
import net.zenith.hoyocraft.entity.ai.goal.WanderNearCampfireGoal;
import net.zenith.hoyocraft.entity.ai.goal.ambient.AmbientBehaviorParameters;
import net.zenith.hoyocraft.entity.core.HoyoEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.CombatAction;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.AbyssalEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;

public abstract class GenshinEntity
extends HoyoEntity
implements GeoAnimatable {
    protected static final EntityDataAccessor<Boolean> SHOW_AGGRO_INDICATOR = SynchedEntityData.defineId(GenshinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_IS_SPRINTING = SynchedEntityData.defineId(GenshinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_IS_CIRCLING_LEFT = SynchedEntityData.defineId(GenshinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_IS_JUMPING_ATTACK = SynchedEntityData.defineId(GenshinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected int entityLevel = 1;
    private boolean needsAggroReaction = false;
    public int ticksSinceLastAte;
    private int aggroReactionCooldown = 0;
    private static final int AGGRO_REACTION_DEFAULT_COOLDOWN = 100;
    protected List<EntityType<?>> huntableAnimals = Collections.emptyList();
    public boolean isAttemptingToCook = false;
    public boolean isSignalingPatrol = false;
    public int patrolSignalTicks = 0;
    public static final int PATROL_SIGNAL_DURATION_TICKS = 40;
    protected Map<Item, Float> edibleItems = Collections.emptyMap();
    private boolean specificGoalsRegistered = false;
    @Nullable
    private UUID invasionTargetUUID;
    private int invasionTargetLostCooldown;
    private int timeUntilNextAmbientBehavior = 0;
    private int currentAmbientBehaviorCooldownTier = 0;
    private boolean isPerformingAmbientBehaviorFlag = false;
    private static final int AMBIENT_BEHAVIOR_COOLDOWN_TIER_MINUTES_BASE = 2;
    private static final int AMBIENT_BEHAVIOR_COOLDOWN_TIER_MINUTES_EXTENSION = 1;
    private static final int AMBIENT_BEHAVIOR_MAX_COOLDOWN_TIERS = 3;
    private Map<Block, Float> edibleBlocks = Collections.emptyMap();
    private boolean needsCampfireRitual = false;
    protected static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING_GECKOLIB = SynchedEntityData.defineId(GenshinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<String> DATA_CURRENT_ACTION_ANIMATION_NAME = SynchedEntityData.defineId(GenshinEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private boolean isLeader = false;
    public static final Set<Item> COOKABLE_RAW_MEATS = Set.of(Items.BEEF, Items.PORKCHOP, Items.MUTTON, Items.CHICKEN, Items.RABBIT, Items.COD, Items.SALMON);

    public Map<Block, Float> getEdibleBlocks() {
        return this.edibleBlocks;
    }

    public void setEdibleBlocks(Map<Block, Float> edibleBlocks) {
        this.edibleBlocks = edibleBlocks != null ? edibleBlocks : Collections.emptyMap();
    }

    public void setInvasionTarget(LivingEntity target) {
        if (target != null) {
            this.invasionTargetUUID = target.getUUID();
            this.setTarget(target);
            this.setPersistenceRequired();
        }
    }

    public boolean getNeedsToPerformCampfireRitual() {
        return this.needsCampfireRitual;
    }

    public void setNeedsToPerformCampfireRitual(boolean value) {
        this.needsCampfireRitual = value;
    }

    public void onAmbientBehaviorStarted(AmbientBehaviorParameters behavior) {
        this.setPerformingAmbientBehavior(true, behavior.animationName());
    }

    public void onAmbientBehaviorStopped(@Nullable AmbientBehaviorParameters behavior) {
        this.setPerformingAmbientBehavior(false, behavior != null ? behavior.animationName() : null);
    }

    public abstract List<Supplier<IGenshinAction>> getAvailableCombatActions();

    public boolean isLeader() {
        return this.isLeader;
    }

    protected abstract void registerSpecificGoals();

    public abstract double getNavigationSpeedMultiplier();

    public GenshinEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.setCanPickUpLoot(true);
    }

    protected float getModifiedDamage(float baseDamage, CombatAction.DamageEventConfig damageConfig) {
        return baseDamage;
    }

    protected boolean naturallyHasNoGravity() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOW_AGGRO_INDICATOR, (Object)Boolean.FALSE);
        builder.define(DATA_CURRENT_ACTION_ANIMATION_NAME, (Object)"");
        builder.define(DATA_IS_ATTACKING_GECKOLIB, (Object)false);
        builder.define(DATA_IS_SPRINTING, (Object)false);
        builder.define(DATA_IS_CIRCLING_LEFT, (Object)false);
        builder.define(DATA_IS_JUMPING_ATTACK, (Object)false);
    }

    public boolean isAttackingGeckoLib() {
        return (Boolean)this.entityData.get(DATA_IS_ATTACKING_GECKOLIB);
    }

    public void setAttackingGeckoLib(boolean attacking) {
        this.entityData.set(DATA_IS_ATTACKING_GECKOLIB, (Object)attacking);
        if (!this.level().isClientSide()) {
            // empty if block
        }
    }

    public void playAnimation(String animationName) {
        System.out.println("[GenshinEntity " + this.getId() + (this.level().isClientSide() ? " CLIENT" : " SERVER") + "] playAnimation called with: " + animationName);
        if (!this.level().isClientSide()) {
            this.entityData.set(DATA_CURRENT_ACTION_ANIMATION_NAME, (Object)(animationName == null ? "" : animationName));
            this.setAttackingGeckoLib(true);
        }
    }

    public void stopCurrentActionAnimation() {
        if (!this.level().isClientSide()) {
            this.entityData.set(DATA_CURRENT_ACTION_ANIMATION_NAME, (Object)"");
        }
    }

    @Nullable
    public String getCurrentActionAnimationName() {
        String animName = (String)this.entityData.get(DATA_CURRENT_ACTION_ANIMATION_NAME);
        if (this.level().isClientSide()) {
            // empty if block
        }
        return animName == null || animName.isEmpty() ? null : animName;
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity attacker;
        boolean damageWasActuallyTaken = super.hurt(source, amount);
        if (damageWasActuallyTaken && !this.level().isClientSide() && (attacker = source.getEntity()) instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            GenshinEntity genshinEntity = this;
            if (genshinEntity instanceof AbyssalEntity) {
                AbyssalEntity abyssalSelf = (AbyssalEntity)genshinEntity;
                if (!this.isGenshinFriend(livingAttacker)) {
                    abyssalSelf.alertNearbyAllies(livingAttacker);
                }
            }
        }
        return damageWasActuallyTaken;
    }

    public void executeConfiguredDamage(CombatAction.DamageEventConfig damageConfig, LivingEntity primaryTarget) {
        if (this.level().isClientSide()) {
            return;
        }
        Vec3 entityLook = this.getLookAngle();
        Vec3 forwardOffset = entityLook.scale(damageConfig.damageCenterOffset().z());
        Vec3 rightOffset = new Vec3(-entityLook.z, 0.0, entityLook.x).normalize().scale(damageConfig.damageCenterOffset().x);
        Vec3 upOffset = new Vec3(0.0, 1.0, 0.0).scale(damageConfig.damageCenterOffset().y);
        Vec3 aoeCenter = this.position().add(forwardOffset).add(rightOffset).add(upOffset);
        AABB aoeBounds = AABB.ofSize((Vec3)aoeCenter, (double)((double)damageConfig.aoeRadius() * 2.0), (double)((double)damageConfig.aoeRadius() * 2.0), (double)((double)damageConfig.aoeRadius() * 2.0));
        List entitiesToHit = this.level().getEntitiesOfClass(LivingEntity.class, aoeBounds, e -> e.isAlive() && e != this && !this.isGenshinFriend((LivingEntity)e));
        for (LivingEntity victim : entitiesToHit) {
            Level level;
            double dZ;
            if (!this.canAttack(victim)) continue;
            float finalDamage = this.getModifiedDamage(damageConfig.damageAmount(), damageConfig);
            boolean damageApplied = victim.hurt(this.damageSources().mobAttack((LivingEntity)this), finalDamage);
            if (!damageApplied) continue;
            double dX = victim.getX() - this.getX();
            double dist = Math.sqrt(dX * dX + (dZ = victim.getZ() - this.getZ()) * dZ);
            if (dist > 1.0E-4) {
                dX /= dist;
                dZ /= dist;
            } else {
                dX = (this.getRandom().nextDouble() - 0.5) * 0.1;
                dZ = (this.getRandom().nextDouble() - 0.5) * 0.1;
            }
            victim.setDeltaMovement(victim.getDeltaMovement().x + dX * (double)damageConfig.knockbackHorizontalStrength(), victim.getDeltaMovement().y + (double)damageConfig.knockbackVerticalStrength(), victim.getDeltaMovement().z + dZ * (double)damageConfig.knockbackHorizontalStrength());
            if (damageConfig.particleOnHitOptions() != null && damageConfig.particleOnHitCount() > 0 && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles(damageConfig.particleOnHitOptions(), victim.getX(), victim.getY() + (double)victim.getBbHeight() * 0.5, victim.getZ(), damageConfig.particleOnHitCount(), (double)victim.getBbWidth() * 0.5 * (double)damageConfig.particleOnHitSpread(), (double)victim.getBbHeight() * 0.25 * (double)damageConfig.particleOnHitSpread(), (double)victim.getBbWidth() * 0.5 * (double)damageConfig.particleOnHitSpread(), (double)damageConfig.particleOnHitSpeed());
            }
            if (damageConfig.soundOnHitEvent() == null || damageConfig.soundOnHitSource() == null) continue;
            victim.level().playSound(null, victim.getX(), victim.getY(), victim.getZ(), damageConfig.soundOnHitEvent(), damageConfig.soundOnHitSource(), damageConfig.soundOnHitVolume(), damageConfig.soundOnHitPitch());
        }
    }

    protected void setHuntableAnimals(List<EntityType<?>> animals) {
        this.huntableAnimals = animals != null ? List.copyOf(animals) : Collections.emptyList();
    }

    protected void setEdibleItems(Map<Item, Float> items) {
        this.edibleItems = items != null ? Map.copyOf(items) : Collections.emptyMap();
    }

    public boolean wantsToPickUp(ItemStack stack) {
        return this.edibleItems.containsKey(stack.getItem());
    }

    public List<EntityType<?>> getHuntableAnimals() {
        return this.huntableAnimals;
    }

    public Map<Item, Float> getEdibleItems() {
        return this.edibleItems;
    }

    public boolean isGenshinFriend(LivingEntity entity) {
        return false;
    }

    public int getLevel() {
        return this.entityLevel;
    }

    public void setLevel(int level) {
        this.entityLevel = Math.max(1, level);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("EntityLevel", this.entityLevel);
        pCompound.putBoolean("SpecificGoalsRegistered", this.specificGoalsRegistered);
        pCompound.putBoolean("IsLeader", this.isLeader);
        pCompound.putBoolean("NeedsCampfireRitual", this.needsCampfireRitual);
        pCompound.putInt("TimeUntilNextAmbientBehavior", this.timeUntilNextAmbientBehavior);
        pCompound.putInt("AmbientBehaviorCooldownTier", this.currentAmbientBehaviorCooldownTier);
        if (this.invasionTargetUUID != null) {
            pCompound.putUUID("InvasionTargetUUID", this.invasionTargetUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("EntityLevel")) {
            this.entityLevel = pCompound.getInt("EntityLevel");
        }
        this.specificGoalsRegistered = pCompound.contains("SpecificGoalsRegistered") ? pCompound.getBoolean("SpecificGoalsRegistered") : false;
        this.isLeader = pCompound.contains("IsLeader") ? pCompound.getBoolean("IsLeader") : false;
        if (pCompound.contains("NeedsCampfireRitual")) {
            this.needsCampfireRitual = pCompound.getBoolean("NeedsCampfireRitual");
        }
        if (pCompound.contains("TimeUntilNextAmbientBehavior")) {
            this.timeUntilNextAmbientBehavior = pCompound.getInt("TimeUntilNextAmbientBehavior");
        } else {
            this.resetAmbientBehaviorCooldown(true);
        }
        this.currentAmbientBehaviorCooldownTier = pCompound.contains("AmbientBehaviorCooldownTier") ? pCompound.getInt("AmbientBehaviorCooldownTier") : 0;
        if (pCompound.hasUUID("InvasionTargetUUID")) {
            this.invasionTargetUUID = pCompound.getUUID("InvasionTargetUUID");
        }
        this.ensureSpecificGoalsRegistered();
    }

    public boolean isShowingAggroIndicator() {
        return (Boolean)this.entityData.get(SHOW_AGGRO_INDICATOR);
    }

    public void setShowAggroIndicator(boolean show) {
        this.entityData.set(SHOW_AGGRO_INDICATOR, (Object)show);
    }

    public boolean isNeedsAggroReaction() {
        return this.needsAggroReaction;
    }

    public void setNeedsAggroReaction(boolean value) {
        this.needsAggroReaction = value;
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        LivingEntity oldTarget = this.getTarget();
        super.setTarget(pTarget);
        boolean targetsEqual = Objects.equals(pTarget, oldTarget);
        boolean shouldSetNeedsReactionFlag = false;
        if (pTarget != null) {
            if (!targetsEqual) {
                shouldSetNeedsReactionFlag = true;
            }
        } else if (oldTarget != null) {
            this.setNeedsAggroReaction(false);
            this.setShowAggroIndicator(false);
        }
        if (shouldSetNeedsReactionFlag) {
            this.setNeedsAggroReaction(true);
        }
    }

    protected abstract Goal createAttackGoal();

    public boolean isPersistenceRequired() {
        return true;
    }

    public void eatFoodItem(ItemStack foodStack, float healAmountPercent) {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ(), 7, 0.5, 0.3, 0.5, 0.1);
            }
            float amountToHeal = this.getMaxHealth() * healAmountPercent;
            this.heal(amountToHeal);
        }
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem();
        ItemStack itemInMainHand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (this.wantsToPickUp(itemstack)) {
            boolean canEquip;
            boolean bl = canEquip = itemInMainHand.isEmpty() || itemstack.has(DataComponents.FOOD) && !this.edibleItems.containsKey(itemInMainHand.getItem());
            if (canEquip) {
                ItemStack stackToEquip = itemstack.split(1);
                if (!itemInMainHand.isEmpty()) {
                    this.spawnAtLocation(itemInMainHand);
                }
                this.setItemSlot(EquipmentSlot.MAINHAND, stackToEquip);
                this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
                this.ticksSinceLastAte = 0;
                if (!itemstack.isEmpty()) {
                    itemEntity.setItem(itemstack);
                } else {
                    itemEntity.discard();
                }
                this.onItemPickup(itemEntity);
            }
        } else {
            super.pickUpItem(itemEntity);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            IShield shield;
            if (this.getTarget() == null && this.invasionTargetUUID != null) {
                Player targetPlayer = this.level().getPlayerByUUID(this.invasionTargetUUID);
                if (targetPlayer != null && targetPlayer.isAlive()) {
                    this.setTarget((LivingEntity)targetPlayer);
                    this.invasionTargetLostCooldown = 0;
                } else {
                    ++this.invasionTargetLostCooldown;
                    if (this.invasionTargetLostCooldown > 600) {
                        this.invasionTargetUUID = null;
                        this.invasionTargetLostCooldown = 0;
                    }
                }
            }
            if ((shield = (IShield)this.getCapability(ShieldCapability.SHIELD_CAPABILITY)) != null) {
                shield.tick();
            }
            if (this.timeUntilNextAmbientBehavior > 0) {
                --this.timeUntilNextAmbientBehavior;
            }
            if (this.patrolSignalTicks > 0) {
                --this.patrolSignalTicks;
                if (this.patrolSignalTicks == 0) {
                    this.isSignalingPatrol = false;
                }
            }
            if (this.isAlive() && this.isEffectiveAi()) {
                boolean isHoldingEdible;
                ItemStack itemInMainHand = this.getItemBySlot(EquipmentSlot.MAINHAND);
                boolean bl = isHoldingEdible = !itemInMainHand.isEmpty() && this.edibleItems.containsKey(itemInMainHand.getItem());
                if (isHoldingEdible) {
                    boolean isCookableRaw = COOKABLE_RAW_MEATS.contains(itemInMainHand.getItem());
                    if (this.isAttemptingToCook && isCookableRaw) {
                        this.ticksSinceLastAte = 0;
                    } else {
                        int eatDelayTicks;
                        ++this.ticksSinceLastAte;
                        int n = eatDelayTicks = isCookableRaw && !this.isAttemptingToCook ? 40 : 60;
                        if (this.ticksSinceLastAte >= eatDelayTicks) {
                            Float healAmountPercent = this.edibleItems.get(itemInMainHand.getItem());
                            if (healAmountPercent != null) {
                                this.eatFoodItem(itemInMainHand.copy(), healAmountPercent.floatValue());
                                ItemStack resultStack = itemInMainHand.finishUsingItem(this.level(), (LivingEntity)this);
                                this.setItemSlot(EquipmentSlot.MAINHAND, resultStack);
                                this.ticksSinceLastAte = 0;
                            }
                        } else if (this.ticksSinceLastAte > eatDelayTicks - 20 && this.random.nextFloat() < 0.1f) {
                            Level level = this.level();
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemInMainHand), this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ(), 7, 0.5, 0.3, 0.5, 0.1);
                            }
                            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f);
                        }
                    }
                } else {
                    this.ticksSinceLastAte = 0;
                }
            }
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnGroupData) {
        SpawnGroupData spawnData = super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnGroupData);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.ensureSpecificGoalsRegistered();
        if (!this.level().isClientSide()) {
            this.resetAmbientBehaviorCooldown(true);
        }
        return spawnData;
    }

    public void resetAmbientBehaviorCooldown(boolean isInitialSpawn) {
        if (this.level().isClientSide()) {
            return;
        }
        this.currentAmbientBehaviorCooldownTier = isInitialSpawn ? this.random.nextInt(2) : this.random.nextInt(4);
        int baseTicks = 2400;
        int extensionTicks = this.currentAmbientBehaviorCooldownTier * 1 * 60 * 20;
        this.timeUntilNextAmbientBehavior = baseTicks + extensionTicks;
        this.timeUntilNextAmbientBehavior += this.random.nextInt(1200) - 600;
        if (this.timeUntilNextAmbientBehavior < 1200) {
            this.timeUntilNextAmbientBehavior = 1200 + this.random.nextInt(200);
        }
    }

    public int getTimeUntilNextAmbientBehavior() {
        return this.timeUntilNextAmbientBehavior;
    }

    protected void ensureSpecificGoalsRegistered() {
        if (!this.specificGoalsRegistered) {
            this.registerSpecificGoals();
            this.specificGoalsRegistered = true;
        }
    }

    public void setLeader(boolean leader) {
        if (this.isLeader != leader) {
            this.isLeader = leader;
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.isNoGravity() && !this.naturallyHasNoGravity() && !this.isAttackingGeckoLib()) {
            this.setNoGravity(false);
        }
        if (this.aggroReactionCooldown > 0) {
            --this.aggroReactionCooldown;
        }
    }

    public boolean canStartAggroReaction() {
        return this.aggroReactionCooldown <= 0;
    }

    public void triggerAggroReactionCooldown() {
        this.aggroReactionCooldown = 100;
    }

    public void die(DamageSource p_21016_) {
        super.die(p_21016_);
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
    }

    public void triggerHurtMarkedForSync() {
        this.markHurt();
    }

    @Nullable
    public Vec3 getLeaderPatrolGoalTargetPosition() {
        if (this.goalSelector != null && this.isLeader()) {
            for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
                Goal goal = wrappedGoal.getGoal();
                if (!(goal instanceof HilichurlLeaderPatrolGoal)) continue;
                HilichurlLeaderPatrolGoal patrolGoal = (HilichurlLeaderPatrolGoal)goal;
                if (!wrappedGoal.isRunning()) break;
                return patrolGoal.getCurrentLegTargetPos();
            }
        }
        return null;
    }

    public boolean isLeaderActivelyPatrolling() {
        if (this.goalSelector != null && this.isLeader()) {
            for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
                Goal goal = wrappedGoal.getGoal();
                if (!(goal instanceof HilichurlLeaderPatrolGoal)) continue;
                return wrappedGoal.isRunning() && !this.getNavigation().isDone();
            }
        }
        return false;
    }

    public boolean isSignalingPatrol() {
        return this.isSignalingPatrol;
    }

    public boolean isPatrolGoalActive() {
        if (this.goalSelector != null && this.isLeader()) {
            for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
                if (!(wrappedGoal.getGoal() instanceof HilichurlLeaderPatrolGoal)) continue;
                return wrappedGoal.isRunning();
            }
        }
        return false;
    }

    public boolean isFollowingLeaderGoalActive() {
        if (this.goalSelector != null && !this.isLeader()) {
            for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
                if (!(wrappedGoal.getGoal() instanceof HilichurlFollowLeaderGoal)) continue;
                return wrappedGoal.isRunning();
            }
        }
        return false;
    }

    public boolean isCampfireRitualGoalActive() {
        if (this.goalSelector != null && this.isLeader()) {
            for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
                if (!(wrappedGoal.getGoal() instanceof HilichurlCampGoal)) continue;
                return wrappedGoal.isRunning();
            }
        }
        return false;
    }

    public boolean isWanderingNearCampfire() {
        if (this.goalSelector != null) {
            for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
                if (!(wrappedGoal.getGoal() instanceof WanderNearCampfireGoal)) continue;
                return wrappedGoal.isRunning();
            }
        }
        return false;
    }

    public static Optional<BlockPos> findClosestLitCampfire(LivingEntity mob, double searchRadiusBlocks) {
        if (mob.level().isClientSide()) {
            return Optional.empty();
        }
        int searchRadius = (int)searchRadiusBlocks;
        int verticalSearchRadius = (int)(searchRadiusBlocks / 2.0);
        if (verticalSearchRadius < 1) {
            verticalSearchRadius = 1;
        }
        return BlockPos.findClosestMatch((BlockPos)mob.blockPosition(), (int)searchRadius, (int)verticalSearchRadius, pos -> {
            BlockState blockState = mob.level().getBlockState(pos);
            boolean isRecognized = blockState.is(Blocks.CAMPFIRE) || blockState.is(ModBlocks.HILICHURL_CAMPFIRE.get());
            return isRecognized && blockState.hasProperty((Property)CampfireBlock.LIT) && (Boolean)blockState.getValue((Property)CampfireBlock.LIT) != false;
        });
    }

    public List<AmbientBehaviorParameters> getAmbientBehaviors() {
        return List.of();
    }

    public void setPerformingAmbientBehavior(boolean isPerforming, @Nullable String animationName) {
        if (this.level().isClientSide()) {
            return;
        }
        this.isPerformingAmbientBehaviorFlag = isPerforming;
        if (isPerforming && animationName != null) {
            this.entityData.set(DATA_CURRENT_ACTION_ANIMATION_NAME, (Object)animationName);
            this.setAttackingGeckoLib(true);
        } else if (Objects.equals(this.entityData.get(DATA_CURRENT_ACTION_ANIMATION_NAME), animationName) || animationName == null) {
            this.stopCurrentActionAnimation();
        }
    }

    public boolean isPerformingAmbientBehavior() {
        return this.isPerformingAmbientBehaviorFlag;
    }

    public boolean isSprinting() {
        return (Boolean)this.entityData.get(DATA_IS_SPRINTING);
    }

    public void setSprinting(boolean sprinting) {
        this.entityData.set(DATA_IS_SPRINTING, (Object)sprinting);
    }

    public boolean isCirclingLeft() {
        return (Boolean)this.entityData.get(DATA_IS_CIRCLING_LEFT);
    }

    public void setLeftCircling(boolean circling) {
        this.entityData.set(DATA_IS_CIRCLING_LEFT, (Object)circling);
    }

    public boolean isJumpingAttack() {
        return (Boolean)this.entityData.get(DATA_IS_JUMPING_ATTACK);
    }

    public void setJumpingAttack(boolean jumping) {
        this.entityData.set(DATA_IS_JUMPING_ATTACK, (Object)jumping);
    }
}

