/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class GenshinWildlife
extends Animal
implements GeoEntity {
    @Nullable
    private LivingEntity fleeFromAttackerTarget;
    private int fleeFromAttackerTimeRemaining;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int FLEE_DURATION_ON_ALERT_TICKS = 200;
    private static final double ALLY_ALERT_RADIUS = 24.0;
    private static final float PLAYER_AVOID_DISTANCE = 8.0f;
    private static final float ATTACKER_AVOID_DISTANCE = 10.0f;

    protected GenshinWildlife(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 10.0f, 1.1, 1.3, entityToAvoid -> this.fleeFromAttackerTarget != null && this.fleeFromAttackerTarget.equals(entityToAvoid) && this.fleeFromAttackerTimeRemaining > 0));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.0, 1.2, entityToAvoid -> {
            if (entityToAvoid instanceof Player) {
                Player player = (Player)entityToAvoid;
                return !player.isCreative() && !player.isSpectator();
            }
            return false;
        }));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level;
        boolean wasHurt = super.hurt(source, amount);
        if (wasHurt && !this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            Entity attacker;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = attacker = source.getDirectEntity() instanceof LivingEntity ? source.getDirectEntity() : source.getEntity();
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                this.setFleeFromAttacker(livingAttacker, 200);
                List nearbyWildlife = serverLevel.getEntitiesOfClass(GenshinWildlife.class, this.getBoundingBox().inflate(24.0, 12.0, 24.0), wildlife -> wildlife != this && wildlife.isAlive() && wildlife.hasLineOfSight((Entity)livingAttacker));
                for (GenshinWildlife ally : nearbyWildlife) {
                    ally.setFleeFromAttacker(livingAttacker, 200);
                }
            }
        }
        return wasHurt;
    }

    public void setFleeFromAttacker(@Nullable LivingEntity attacker, int ticks) {
        this.fleeFromAttackerTarget = attacker;
        this.fleeFromAttackerTimeRemaining = ticks;
    }

    public void aiStep() {
        super.aiStep();
        if (this.fleeFromAttackerTimeRemaining > 0) {
            --this.fleeFromAttackerTimeRemaining;
            if (this.fleeFromAttackerTimeRemaining == 0) {
                this.fleeFromAttackerTarget = null;
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Nullable
    public LivingEntity getFleeFromAttackerTarget() {
        if (this.fleeFromAttackerTimeRemaining > 0) {
            return this.fleeFromAttackerTarget;
        }
        return null;
    }

    public int getFleeFromAttackerTimeRemaining() {
        return this.fleeFromAttackerTimeRemaining;
    }

    public void triggerHurtMarkedForSync() {
        this.markHurt();
    }
}

