/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public abstract class HoyoEntity
extends PathfinderMob {
    protected HoyoEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public static boolean checkHoyoEntitySpawnRules(EntityType<? extends HoyoEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.DISPENSER) {
            return true;
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        BlockState spawnBlock = level.getBlockState(pos);
        if (!spawnBlock.isAir() && !spawnBlock.canBeReplaced()) {
            return false;
        }
        BlockState blockAbove = level.getBlockState(pos.above());
        return blockAbove.isAir() || blockAbove.canBeReplaced();
    }

    public static boolean isDaytime(Level level) {
        long dayTime = level.getDayTime() % 24000L;
        return dayTime >= 0L && dayTime < 13000L;
    }

    public static boolean isNighttime(Level level) {
        return !HoyoEntity.isDaytime(level);
    }

    public static boolean hasSolidGround(ServerLevelAccessor level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        return blockBelow.isSolid();
    }

    public static boolean isOnLeaves(ServerLevelAccessor level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        return blockBelow.is(BlockTags.LEAVES);
    }

    public static int getLightLevel(ServerLevelAccessor level, BlockPos pos) {
        return level.getMaxLocalRawBrightness(pos);
    }

    public static boolean hasMinimumLight(ServerLevelAccessor level, BlockPos pos, int minLight) {
        return HoyoEntity.getLightLevel(level, pos) >= minLight;
    }
}

