/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core.combat;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class AggroReactionGoal<T extends GenshinEntity>
extends Goal {
    protected final T entity;
    private int reactionTimer = 0;
    private final int reactionDurationTicks;

    public AggroReactionGoal(T entity, int reactionDurationTicks) {
        this.entity = entity;
        this.reactionDurationTicks = reactionDurationTicks;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        boolean canStartDueToCooldown = ((GenshinEntity)((Object)this.entity)).canStartAggroReaction();
        boolean needsToReactFlag = ((GenshinEntity)((Object)this.entity)).isNeedsAggroReaction();
        boolean hasValidTarget = this.entity.getTarget() != null && this.entity.getTarget().isAlive();
        boolean result = canStartDueToCooldown && needsToReactFlag && hasValidTarget;
        return result;
    }

    public void start() {
        this.reactionTimer = 0;
        ((GenshinEntity)((Object)this.entity)).setNeedsAggroReaction(false);
        ((GenshinEntity)((Object)this.entity)).triggerAggroReactionCooldown();
        this.entity.getNavigation().stop();
        LivingEntity target = this.entity.getTarget();
        if (target != null) {
            this.entity.lookAt((Entity)target, 360.0f, 360.0f);
        }
        ((GenshinEntity)((Object)this.entity)).setShowAggroIndicator(true);
    }

    public void tick() {
        ++this.reactionTimer;
        LivingEntity target = this.entity.getTarget();
        if (target != null) {
            this.entity.lookAt((Entity)target, 360.0f, 360.0f);
        }
        this.entity.getNavigation().stop();
    }

    public boolean canContinueToUse() {
        return this.reactionTimer < this.reactionDurationTicks && this.entity.getTarget() != null && this.entity.getTarget().isAlive();
    }

    public void stop() {
        this.reactionTimer = 0;
        ((GenshinEntity)((Object)this.entity)).setShowAggroIndicator(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

