/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core.combat;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;

public abstract class GenshinAttackGoal
extends Goal {
    protected final GenshinEntity entity;
    protected LivingEntity target;
    protected final Random random = new Random();
    protected int cooldown = 20;
    protected int actionTime = 0;
    protected IGenshinAction currentAction = null;
    protected boolean hasAttacked = false;

    public GenshinAttackGoal(GenshinEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.entity.getTarget();
        return this.target != null && this.target.isAlive();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        this.target = this.entity.getTarget();
        if (this.target == null) {
            return;
        }
        if (this.currentAction == null) {
            this.handleDefaultBehavior();
        } else {
            this.handleActionExecution();
        }
    }

    protected void handleActionExecution() {
        if (this.target == null || !this.target.isAlive() || this.currentAction == null) {
            if (this.currentAction == null) {
                return;
            }
            if ((this.target == null || !this.target.isAlive()) && this.currentAction.requiresImmediateFinish()) {
                this.currentAction.stop(this.entity);
                this.resetEntityAnimationStates();
                this.currentAction = null;
                return;
            }
        }
        this.currentAction.perform(this.entity, this.target);
        ++this.actionTime;
        if (this.actionTime >= this.getActionDuration(this.currentAction)) {
            System.out.println("[SERVER GenshinAttackGoal for " + this.entity.getEncodeId() + " Tick: " + this.entity.tickCount + "] Action " + (this.currentAction != null ? this.currentAction.getName() : "null") + " deemed finished. Duration: " + this.actionTime + "/" + this.getActionDuration(this.currentAction) + ". Calling currentAction.stop().");
            if (this.currentAction != null) {
                this.currentAction.stop(this.entity);
            }
            this.resetEntityAnimationStates();
            this.currentAction = null;
            this.cooldown = this.getActionCooldown();
            System.out.println("[SERVER GenshinAttackGoal for " + this.entity.getEncodeId() + " Tick: " + this.entity.tickCount + "] Action finished. Resetting inter-action cooldown to: " + this.cooldown);
            this.hasAttacked = false;
        }
    }

    protected void moveNormally(double speedMultiplier) {
        if (this.target == null || !this.target.isAlive()) {
            this.entity.getNavigation().stop();
            return;
        }
        double distanceSq = this.entity.distanceToSqr((Entity)this.target);
        double stopDistanceSq = this.getStopDistanceSq();
        double tooCloseDistanceSq = this.getTooCloseDistanceSq();
        if (distanceSq > stopDistanceSq) {
            this.entity.getNavigation().moveTo((Entity)this.target, speedMultiplier);
        } else if (distanceSq < tooCloseDistanceSq) {
            float maxYawChangePerTick = 30.0f;
            float maxPitchChangePerTick = 30.0f;
            this.entity.lookAt((Entity)this.target, maxYawChangePerTick, maxPitchChangePerTick);
            double dx_away = this.entity.getX() - this.target.getX();
            double dz_away = this.entity.getZ() - this.target.getZ();
            double dist_away = Math.sqrt(dx_away * dx_away + dz_away * dz_away);
            if (dist_away > 0.01) {
                this.entity.setDeltaMovement((dx_away /= dist_away) * this.getTooCloseBackoffSpeed(), this.entity.getDeltaMovement().y(), (dz_away /= dist_away) * this.getTooCloseBackoffSpeed());
                if (!this.entity.getNavigation().isDone()) {
                    this.entity.getNavigation().stop();
                }
            }
        } else {
            this.entity.getNavigation().stop();
            this.entity.lookAt((Entity)this.target, 30.0f, 30.0f);
        }
    }

    public void stop() {
        super.stop();
        if (this.currentAction != null) {
            this.currentAction.stop(this.entity);
            this.currentAction = null;
        }
        this.actionTime = 0;
        this.resetEntityAnimationStates();
    }

    protected void handleDefaultBehavior() {
        boolean isInActionDistance;
        LivingEntity target = this.entity.getTarget();
        if (target == null || !target.isAlive()) {
            return;
        }
        double distanceSq = this.entity.distanceToSqr((Entity)target);
        double minActionDistanceSq = this.getMinActionDistance() * this.getMinActionDistance();
        double maxActionDistanceSq = this.getMaxActionDistance() * this.getMaxActionDistance();
        boolean bl = isInActionDistance = distanceSq >= minActionDistanceSq && distanceSq <= maxActionDistanceSq;
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.cooldown <= 0 && isInActionDistance) {
            System.out.println("[SERVER GenshinAttackGoal for " + this.entity.getEncodeId() + " Tick: " + this.entity.tickCount + "] Inter-action cooldown expired and in range. Selecting new action.");
            this.currentAction = this.selectRandomAction();
            if (this.currentAction != null) {
                System.out.println("[SERVER GenshinAttackGoal for " + this.entity.getEncodeId() + " Tick: " + this.entity.tickCount + "] Selected action: " + this.currentAction.getName() + ". Calling currentAction.start().");
                this.currentAction.start(this.entity);
            } else {
                System.out.println("[SERVER GenshinAttackGoal for " + this.entity.getEncodeId() + " Tick: " + this.entity.tickCount + "] No valid action selected. Moving normally.");
                double speedMultiplier = this.entity.getNavigationSpeedMultiplier();
                this.moveNormally(speedMultiplier);
            }
            this.actionTime = 0;
            this.hasAttacked = false;
        } else {
            double speedMultiplier = this.entity.getNavigationSpeedMultiplier();
            this.moveNormally(speedMultiplier);
        }
    }

    protected IGenshinAction selectRandomAction() {
        List<Supplier<IGenshinAction>> actions = this.entity.getAvailableCombatActions();
        if (actions == null || actions.isEmpty()) {
            return null;
        }
        List validActions = actions.stream().map(Supplier::get).filter(action -> {
            boolean canPerform = action.canPerform(this.entity);
            return canPerform;
        }).collect(Collectors.toList());
        if (validActions.isEmpty()) {
            return null;
        }
        IGenshinAction selected = (IGenshinAction)validActions.get(this.random.nextInt(validActions.size()));
        return selected;
    }

    protected abstract void resetEntityAnimationStates();

    protected double getMinActionDistance() {
        return 3.0;
    }

    protected double getMaxActionDistance() {
        return 5.0;
    }

    protected double getStopDistanceSq() {
        return 25.0;
    }

    protected double getTooCloseDistanceSq() {
        return 16.0;
    }

    protected double getTooCloseBackoffSpeed() {
        return 0.2;
    }

    protected double getMoveSpeed() {
        return 1.0;
    }

    protected int getActionCooldown() {
        return 21;
    }

    protected int getActionDuration(IGenshinAction action) {
        return action.getCooldown();
    }
}

