/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core.combat.actions;

import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.HilichurlFighterEntity;

public class CircleAction
implements IGenshinAction {
    private int durationTicks;
    private double moveSpeed;
    private boolean circleLeft;
    private double preferredCircleDistance;
    private double distanceCorrectionSpeed = 0.15;
    private double maxRadialCorrectionSpeed = 0.3;

    @Override
    public void start(GenshinEntity entity) {
        RandomSource random = entity.getRandom();
        this.durationTicks = 8 + random.nextInt(3) * 8;
        this.moveSpeed = 0.2 + random.nextDouble() * 0.1;
        this.circleLeft = random.nextBoolean();
        this.preferredCircleDistance = 4.2 + random.nextDouble() * 0.6;
        if (entity instanceof HilichurlFighterEntity) {
            HilichurlFighterEntity fighter = (HilichurlFighterEntity)entity;
            fighter.setLeftCircling(this.circleLeft);
        }
    }

    @Override
    public void stop(GenshinEntity entity) {
        System.out.println("CircleAction: stop called for entity: " + entity.getId());
    }

    @Override
    public boolean requiresImmediateFinish() {
        return false;
    }

    @Override
    public boolean canPerform(GenshinEntity entity) {
        LivingEntity target = entity.getTarget();
        if (target == null) {
            return false;
        }
        double distanceSq = entity.distanceToSqr((Entity)target);
        return distanceSq >= 16.0 && distanceSq <= 25.0;
    }

    @Override
    public void perform(GenshinEntity entity, LivingEntity target) {
        double finalMoveZ;
        double finalMoveX;
        double combinedMoveZ;
        double dz;
        if (!this.canPerform(entity)) {
            entity.setDeltaMovement(0.0, entity.getDeltaMovement().y(), 0.0);
            return;
        }
        double dx = target.getX() - entity.getX();
        double distance = Math.sqrt(dx * dx + (dz = target.getZ() - entity.getZ()) * dz);
        if (distance < 0.1) {
            entity.getNavigation().stop();
            return;
        }
        double angle = Math.toRadians(this.circleLeft ? 90.0 : -90.0);
        double tanX = (dx /= distance) * Math.cos(angle) - (dz /= distance) * Math.sin(angle);
        double tanZ = dx * Math.sin(angle) + dz * Math.cos(angle);
        double radialCorrectionAmount = 0.0;
        double distanceError = distance - this.preferredCircleDistance;
        radialCorrectionAmount = distanceError * this.distanceCorrectionSpeed;
        double combinedMoveX = tanX + dx * (radialCorrectionAmount = Math.max(-this.maxRadialCorrectionSpeed, Math.min(this.maxRadialCorrectionSpeed, radialCorrectionAmount)));
        double combinedLength = Math.sqrt(combinedMoveX * combinedMoveX + (combinedMoveZ = tanZ + dz * radialCorrectionAmount) * combinedMoveZ);
        if (combinedLength > 1.0E-6) {
            double normalizedCombinedX = combinedMoveX / combinedLength;
            double normalizedCombinedZ = combinedMoveZ / combinedLength;
            finalMoveX = normalizedCombinedX * this.moveSpeed;
            finalMoveZ = normalizedCombinedZ * this.moveSpeed;
        } else {
            finalMoveX = 0.0;
            finalMoveZ = 0.0;
        }
        entity.setDeltaMovement(finalMoveX, entity.getDeltaMovement().y(), finalMoveZ);
        entity.lookAt((Entity)target, 30.0f, 30.0f);
    }

    @Override
    public int getCooldown() {
        return this.durationTicks;
    }

    @Override
    public String getName() {
        return "Circle";
    }
}

