/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core.combat.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.AbyssalEntity;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.HilichurlEntity;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.HilichurlFighterEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.AnemoSlimeEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.CryoSlimeEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.DendroSlimeEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.ElectroSlimeEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.GeoSlimeEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.HydroSlimeEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.PyroSlimeEntity;

public class CombatAction
implements IGenshinAction {
    private final CombatActionParameters params;
    private int currentActionTick;
    private final Set<DamageEventConfig> dealtDamageEventsInThisExecution;
    private boolean originalNoGravityState = false;
    private Vec3 calculatedDashVector = null;

    protected Set<DamageEventConfig> getDealtDamageEventsInThisExecution() {
        return this.dealtDamageEventsInThisExecution;
    }

    public CombatAction(CombatActionParameters params) {
        this.params = params;
        this.dealtDamageEventsInThisExecution = new HashSet<DamageEventConfig>();
    }

    @Override
    public String getName() {
        return this.params.actionNameForLogging();
    }

    @Override
    public void start(GenshinEntity entity) {
        AbyssalEntity he;
        this.currentActionTick = 0;
        this.dealtDamageEventsInThisExecution.clear();
        this.calculatedDashVector = null;
        this.originalNoGravityState = entity.isNoGravity();
        entity.playAnimation(this.params.animationName());
        if (entity instanceof HilichurlEntity) {
            he = (HilichurlEntity)entity;
            ((HilichurlEntity)he).setAttackingGeckoLib(true);
        }
        if (entity instanceof HilichurlFighterEntity) {
            he = (HilichurlFighterEntity)entity;
            ((HilichurlFighterEntity)he).setAttackingGeckoLib(true);
        } else if (entity instanceof GeoSlimeEntity) {
            GeoSlimeEntity hse = (GeoSlimeEntity)entity;
            hse.setAttackingGeckoLib(true);
        } else if (entity instanceof HydroSlimeEntity) {
            HydroSlimeEntity hse = (HydroSlimeEntity)entity;
            hse.setAttackingGeckoLib(true);
        } else if (entity instanceof PyroSlimeEntity) {
            PyroSlimeEntity hse = (PyroSlimeEntity)entity;
            hse.setAttackingGeckoLib(true);
        } else if (entity instanceof ElectroSlimeEntity) {
            ElectroSlimeEntity hse = (ElectroSlimeEntity)entity;
            hse.setAttackingGeckoLib(true);
        } else if (entity instanceof CryoSlimeEntity) {
            CryoSlimeEntity hse = (CryoSlimeEntity)entity;
            hse.setAttackingGeckoLib(true);
        } else if (entity instanceof AnemoSlimeEntity) {
            AnemoSlimeEntity hse = (AnemoSlimeEntity)entity;
            hse.setAttackingGeckoLib(true);
        } else if (entity instanceof DendroSlimeEntity) {
            DendroSlimeEntity hse = (DendroSlimeEntity)entity;
            hse.setAttackingGeckoLib(true);
        }
        if (!entity.getNavigation().isDone()) {
            entity.getNavigation().stop();
        }
    }

    @Override
    public void perform(GenshinEntity entity, LivingEntity target) {
        Object object;
        if (target == null || !target.isAlive()) {
            return;
        }
        if (this.params.continuouslyFaceTarget()) {
            entity.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        boolean movementSegmentActiveThisTick = false;
        boolean currentSegmentIgnoresGravity = false;
        for (MovementSegmentConfig moveSegment : this.params.movementSegments()) {
            if (this.currentActionTick < moveSegment.startTimeTicks() || this.currentActionTick >= moveSegment.startTimeTicks() + moveSegment.durationTicks()) continue;
            movementSegmentActiveThisTick = true;
            currentSegmentIgnoresGravity = moveSegment.ignoreGravity();
            this.applyMovementSegment(entity, target, moveSegment);
            break;
        }
        if (movementSegmentActiveThisTick) {
            if (currentSegmentIgnoresGravity) {
                if (!entity.isNoGravity()) {
                    entity.setNoGravity(true);
                }
            } else if (entity.isNoGravity()) {
                entity.setNoGravity(this.originalNoGravityState);
            }
        } else {
            if (entity.isNoGravity() && !this.originalNoGravityState) {
                entity.setNoGravity(false);
            }
            if (!entity.getNavigation().isDone()) {
                entity.getNavigation().stop();
            }
        }
        if (!movementSegmentActiveThisTick && !entity.getNavigation().isDone()) {
            entity.getNavigation().stop();
        }
        for (DamageEventConfig damageEvent : this.params.damageEvents()) {
            if (this.currentActionTick != damageEvent.triggerTimeTicks() || this.dealtDamageEventsInThisExecution.contains(damageEvent)) continue;
            entity.executeConfiguredDamage(damageEvent, target);
            this.dealtDamageEventsInThisExecution.add(damageEvent);
        }
        if (!entity.level().isClientSide()) {
            for (TimedSoundEventConfig soundConfig : this.params.timedSoundEvents()) {
                if (this.currentActionTick != soundConfig.triggerTimeTicks()) continue;
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), soundConfig.soundEvent(), soundConfig.soundSource(), soundConfig.volume(), soundConfig.pitch());
            }
        }
        if (!entity.level().isClientSide() && (object = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            for (TimedParticleEventConfig particleEvent : this.params.timedParticleEvents()) {
                if (this.currentActionTick != particleEvent.triggerTimeTicks()) continue;
                Vec3 entityPos = entity.position();
                double spawnX = entityPos.x() + particleEvent.positionOffset().x();
                double spawnY = entityPos.y() + particleEvent.positionOffset().y();
                double spawnZ = entityPos.z() + particleEvent.positionOffset().z();
                serverLevel.sendParticles(particleEvent.particleOptions(), spawnX, spawnY, spawnZ, particleEvent.count(), particleEvent.spreadX(), particleEvent.spreadY(), particleEvent.spreadZ(), particleEvent.speed());
            }
        }
        ++this.currentActionTick;
    }

    private void applyMovementSegment(GenshinEntity entity, LivingEntity target, MovementSegmentConfig moveSegment) {
        switch (moveSegment.type().ordinal()) {
            case 1: {
                double distanceSq = entity.distanceToSqr((Entity)target);
                double stopDistance = (double)entity.getBbWidth() * 1.5;
                if (moveSegment.stopAtTarget() && distanceSq <= stopDistance * stopDistance) {
                    if (entity.getNavigation().isDone()) break;
                    entity.getNavigation().stop();
                    break;
                }
                entity.getNavigation().moveTo((Entity)target, (double)moveSegment.speed());
                break;
            }
            case 2: {
                if (this.currentActionTick != moveSegment.startTimeTicks()) break;
                if (!entity.getNavigation().isDone()) {
                    entity.getNavigation().stop();
                }
                Vec3 lookDir = entity.getLookAngle();
                double horizontalPower = moveSegment.speed() * moveSegment.leapHorizontalMultiplier();
                entity.setDeltaMovement(lookDir.x * horizontalPower, moveSegment.leapVerticalStrength(), lookDir.z * horizontalPower);
                entity.triggerHurtMarkedForSync();
                break;
            }
            case 3: {
                if (this.currentActionTick != moveSegment.startTimeTicks() || moveSegment.fixedVelocity() == null) break;
                if (!entity.getNavigation().isDone()) {
                    entity.getNavigation().stop();
                }
                entity.setDeltaMovement(moveSegment.fixedVelocity().scale((double)moveSegment.speed()));
                entity.triggerHurtMarkedForSync();
                break;
            }
            case 4: {
                if (!entity.getNavigation().isDone()) {
                    entity.getNavigation().stop();
                }
                if (moveSegment.trackTargetDirection()) {
                    if (target != null && target.isAlive()) {
                        Vec3 directionToTarget = target.getEyePosition().subtract(entity.getEyePosition()).normalize();
                        entity.setDeltaMovement(directionToTarget.scale((double)moveSegment.speed()));
                        this.calculatedDashVector = null;
                        break;
                    }
                    entity.setDeltaMovement(Vec3.ZERO);
                    break;
                }
                if (moveSegment.fixedVelocity() != null) {
                    entity.setDeltaMovement(moveSegment.fixedVelocity().scale((double)moveSegment.speed()));
                    this.calculatedDashVector = null;
                    break;
                }
                if (target != null && target.isAlive()) {
                    if (this.calculatedDashVector == null) {
                        this.calculatedDashVector = target.getEyePosition().subtract(entity.getEyePosition()).normalize();
                        System.out.println("[CombatAction DEBUG] Calculated ballistic vector: " + String.valueOf(this.calculatedDashVector) + " for entity " + entity.getId());
                    }
                    if (this.calculatedDashVector != null) {
                        entity.setDeltaMovement(this.calculatedDashVector.scale((double)moveSegment.speed()));
                        break;
                    }
                    entity.setDeltaMovement(Vec3.ZERO);
                    break;
                }
                if (this.calculatedDashVector != null) {
                    entity.setDeltaMovement(this.calculatedDashVector.scale((double)moveSegment.speed()));
                    break;
                }
                entity.setDeltaMovement(Vec3.ZERO);
                break;
            }
            default: {
                if (entity.getNavigation().isDone()) break;
                entity.getNavigation().stop();
            }
        }
    }

    @Override
    public int getCooldown() {
        return this.params.totalActionDurationTicks();
    }

    @Override
    public void stop(GenshinEntity entity) {
        AbyssalEntity hfe;
        entity.setNoGravity(this.originalNoGravityState);
        this.calculatedDashVector = null;
        entity.stopCurrentActionAnimation();
        if (entity instanceof HilichurlFighterEntity) {
            hfe = (HilichurlFighterEntity)entity;
            ((HilichurlFighterEntity)hfe).setAttackingGeckoLib(false);
        }
        if (entity instanceof HilichurlEntity) {
            hfe = (HilichurlEntity)entity;
            ((HilichurlEntity)hfe).setAttackingGeckoLib(false);
        } else if (entity instanceof GeoSlimeEntity) {
            GeoSlimeEntity hse = (GeoSlimeEntity)entity;
            hse.setAttackingGeckoLib(false);
        } else if (entity instanceof HydroSlimeEntity) {
            HydroSlimeEntity hse = (HydroSlimeEntity)entity;
            hse.setAttackingGeckoLib(false);
        } else if (entity instanceof PyroSlimeEntity) {
            PyroSlimeEntity hse = (PyroSlimeEntity)entity;
            hse.setAttackingGeckoLib(false);
        } else if (entity instanceof ElectroSlimeEntity) {
            ElectroSlimeEntity hse = (ElectroSlimeEntity)entity;
            hse.setAttackingGeckoLib(false);
        } else if (entity instanceof CryoSlimeEntity) {
            CryoSlimeEntity hse = (CryoSlimeEntity)entity;
            hse.setAttackingGeckoLib(false);
        } else if (entity instanceof AnemoSlimeEntity) {
            AnemoSlimeEntity hse = (AnemoSlimeEntity)entity;
            hse.setAttackingGeckoLib(false);
        } else if (entity instanceof DendroSlimeEntity) {
            DendroSlimeEntity hse = (DendroSlimeEntity)entity;
            hse.setAttackingGeckoLib(false);
        }
        if (!entity.getNavigation().isDone()) {
            entity.getNavigation().stop();
        }
    }

    @Override
    public boolean canPerform(GenshinEntity entity) {
        LivingEntity target = entity.getTarget();
        return target != null && target.isAlive();
    }

    @Override
    public boolean requiresImmediateFinish() {
        return true;
    }

    public record CombatActionParameters(String actionNameForLogging, String animationName, int totalActionDurationTicks, List<MovementSegmentConfig> movementSegments, List<DamageEventConfig> damageEvents, List<TimedParticleEventConfig> timedParticleEvents, List<TimedSoundEventConfig> timedSoundEvents, boolean continuouslyFaceTarget) {
        public CombatActionParameters(String actionNameForLogging, String animationName, int totalActionDurationTicks, List<MovementSegmentConfig> movementSegments, List<DamageEventConfig> damageEvents, List<TimedParticleEventConfig> timedParticleEvents, boolean continuouslyFaceTarget) {
            this(actionNameForLogging, animationName, totalActionDurationTicks, movementSegments, damageEvents, timedParticleEvents, List.of(), continuouslyFaceTarget);
        }

        public CombatActionParameters(String actionNameForLogging, String animationName, int totalActionDurationTicks, List<MovementSegmentConfig> movementSegments, List<DamageEventConfig> damageEvents, boolean continuouslyFaceTarget) {
            this(actionNameForLogging, animationName, totalActionDurationTicks, movementSegments, damageEvents, List.of(), List.of(), continuouslyFaceTarget);
        }
    }

    public record MovementSegmentConfig(int startTimeTicks, int durationTicks, MovementType type, float speed, boolean stopAtTarget, float leapVerticalStrength, float leapHorizontalMultiplier, @Nullable Vec3 fixedVelocity, boolean ignoreGravity, boolean trackTargetDirection) {
        public MovementSegmentConfig(int startTimeTicks, int durationTicks, MovementType type, float speed, boolean stopAtTarget, float leapVerticalStrength, float leapHorizontalMultiplier, @Nullable Vec3 fixedVelocity, boolean ignoreGravity) {
            this(startTimeTicks, durationTicks, type, speed, stopAtTarget, leapVerticalStrength, leapHorizontalMultiplier, fixedVelocity, ignoreGravity, false);
        }

        public MovementSegmentConfig(int startTimeTicks, int durationTicks, MovementType type, float speed, boolean stopAtTarget, float leapVerticalStrength, float leapHorizontalMultiplier, @Nullable Vec3 fixedVelocity) {
            this(startTimeTicks, durationTicks, type, speed, stopAtTarget, leapVerticalStrength, leapHorizontalMultiplier, fixedVelocity, false, false);
        }

        public static MovementSegmentConfig createContinuousHomingToTarget(int startTime, int duration, float speed, boolean ignoreGrav) {
            return new MovementSegmentConfig(startTime, duration, MovementType.CONTINUOUS_DIRECTED_VELOCITY, speed, false, 0.0f, 0.0f, null, ignoreGrav, true);
        }

        public static MovementSegmentConfig createContinuousBallisticToInitialTarget(int startTime, int duration, float speed, boolean ignoreGrav) {
            return new MovementSegmentConfig(startTime, duration, MovementType.CONTINUOUS_DIRECTED_VELOCITY, speed, false, 0.0f, 0.0f, null, ignoreGrav, false);
        }

        public static MovementSegmentConfig createContinuousStaticVector(int startTime, int duration, float speed, Vec3 staticVector, boolean ignoreGrav) {
            return new MovementSegmentConfig(startTime, duration, MovementType.CONTINUOUS_DIRECTED_VELOCITY, speed, false, 0.0f, 0.0f, staticVector, ignoreGrav, false);
        }
    }

    public record DamageEventConfig(int triggerTimeTicks, float damageAmount, float aoeRadius, Vec3 damageCenterOffset, float knockbackHorizontalStrength, float knockbackVerticalStrength, @Nullable ParticleOptions particleOnHitOptions, int particleOnHitCount, float particleOnHitSpread, float particleOnHitSpeed, @Nullable SoundEvent soundOnHitEvent, @Nullable SoundSource soundOnHitSource, float soundOnHitVolume, float soundOnHitPitch) {
        public DamageEventConfig(int triggerTimeTicks, float damageAmount, float aoeRadius, Vec3 damageCenterOffset, float knockbackHorizontalStrength, float knockbackVerticalStrength) {
            this(triggerTimeTicks, damageAmount, aoeRadius, damageCenterOffset, knockbackHorizontalStrength, knockbackVerticalStrength, null, 0, 0.0f, 0.0f, null, null, 0.0f, 0.0f);
        }

        public DamageEventConfig(int triggerTimeTicks, float damageAmount, float aoeRadius, Vec3 damageCenterOffset, float knockbackHorizontalStrength, float knockbackVerticalStrength, @Nullable ParticleOptions particleOnHitOptions, int particleOnHitCount, float particleOnHitSpread, float particleOnHitSpeed) {
            this(triggerTimeTicks, damageAmount, aoeRadius, damageCenterOffset, knockbackHorizontalStrength, knockbackVerticalStrength, particleOnHitOptions, particleOnHitCount, particleOnHitSpread, particleOnHitSpeed, null, null, 0.0f, 0.0f);
        }
    }

    public record TimedSoundEventConfig(int triggerTimeTicks, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch) {
    }

    public record TimedParticleEventConfig(int triggerTimeTicks, ParticleOptions particleOptions, int count, Vec3 positionOffset, double spreadX, double spreadY, double spreadZ, double speed) {
    }

    public static enum MovementType {
        NONE,
        NAVIGATE_TO_TARGET,
        LEAP_TOWARDS_TARGET,
        FIXED_DIRECTION_VELOCITY,
        CONTINUOUS_DIRECTED_VELOCITY;

    }
}

