/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core.combat.actions;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.custom.elemental.slime.HydroSlimeEntity;

public class TauntAction
implements IGenshinAction {
    private int actionTicks = 0;
    private final Random random = new Random();

    @Override
    public boolean canPerform(GenshinEntity entity) {
        HydroSlimeEntity slimeEntity;
        if (entity instanceof HydroSlimeEntity && (slimeEntity = (HydroSlimeEntity)entity).isJumpingAttack()) {
            System.out.println("TauntAction: canPerform - HydroSlime entity " + entity.getId() + " is currently jumping. Returning false.");
            return false;
        }
        if (!(entity instanceof ITauntableGenshinEntity)) {
            System.out.println("TauntAction: canPerform - Entity does not implement ITauntableGenshinEntity. Returning false.");
            return false;
        }
        ITauntableGenshinEntity tauntableEntity = (ITauntableGenshinEntity)((Object)entity);
        if (tauntableEntity.getAvailableTauntStates().length == 0) {
            System.out.println("TauntAction: canPerform - No available taunt states. Returning false.");
            return false;
        }
        LivingEntity target = entity.getTarget();
        if (target == null || !target.isAlive()) {
            System.out.println("TauntAction: canPerform - No valid target. Returning false.");
            return false;
        }
        double distanceToTargetSq = entity.distanceToSqr((Entity)target);
        double tauntDistance = 4.0;
        double tauntTolerance = 0.5;
        double minTauntDistanceSq = (tauntDistance - tauntTolerance) * (tauntDistance - tauntTolerance);
        double maxTauntDistanceSq = (tauntDistance + tauntTolerance) * (tauntDistance + tauntTolerance);
        boolean isWithinTauntDistance = distanceToTargetSq >= minTauntDistanceSq && distanceToTargetSq <= maxTauntDistanceSq;
        System.out.println("TauntAction: canPerform check for entity " + entity.getId() + ". DistanceSq=" + distanceToTargetSq + ". Within range [" + minTauntDistanceSq + "-" + maxTauntDistanceSq + "]? " + isWithinTauntDistance);
        return isWithinTauntDistance;
    }

    @Override
    public boolean requiresImmediateFinish() {
        return false;
    }

    @Override
    public void start(GenshinEntity entity) {
        this.actionTicks = 0;
        if (entity instanceof ITauntableGenshinEntity) {
            ITauntableGenshinEntity tauntableEntity = (ITauntableGenshinEntity)((Object)entity);
            int[] availableStates = tauntableEntity.getAvailableTauntStates();
            if (availableStates.length > 0) {
                int chosenIndex = availableStates[this.random.nextInt(availableStates.length)];
                tauntableEntity.setTauntState(chosenIndex);
            } else {
                tauntableEntity.setTauntState(0);
            }
        }
        entity.getNavigation().stop();
    }

    @Override
    public void stop(GenshinEntity entity) {
        if (entity instanceof ITauntableGenshinEntity) {
            ITauntableGenshinEntity tauntableEntity = (ITauntableGenshinEntity)((Object)entity);
            tauntableEntity.setTauntState(0);
            System.out.println("TauntAction: Setting taunt state to 0 on stop.");
        }
    }

    @Override
    public void perform(GenshinEntity entity, LivingEntity target) {
        entity.getNavigation().stop();
        if (target != null) {
            entity.lookAt((Entity)target, 30.0f, 30.0f);
        }
        ++this.actionTicks;
    }

    @Override
    public int getCooldown() {
        return 20;
    }

    @Override
    public String getName() {
        return "Taunt";
    }
}

