/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.core.types;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public abstract class AbyssalEntity
extends GenshinEntity {
    private static final double ALLY_ANGER_BROADCAST_RANGE = 24.0;

    protected AbyssalEntity(EntityType<? extends AbyssalEntity> type, Level level) {
        super(type, level);
    }

    protected void broadcastTargetToNearbyFollowers(@Nullable LivingEntity targetToBroadcast) {
        if (!this.isLeader() || this.level().isClientSide()) {
            return;
        }
        double broadcastRadius = 24.0;
        AABB searchBox = this.getBoundingBox().inflate(broadcastRadius);
        List nearbyFollowers = this.level().getEntitiesOfClass(AbyssalEntity.class, searchBox, potentialFollower -> !potentialFollower.isLeader() && potentialFollower.isAlive() && potentialFollower != this && !Objects.equals(potentialFollower.getTarget(), targetToBroadcast));
        for (AbyssalEntity follower : nearbyFollowers) {
            follower.setTarget(targetToBroadcast);
        }
    }

    @Override
    public void setTarget(@Nullable LivingEntity newTarget) {
        LivingEntity oldTarget = this.getTarget();
        super.setTarget(newTarget);
        if (!Objects.equals(oldTarget, newTarget) && !this.level().isClientSide()) {
            if (newTarget != null) {
                this.setNeedsAggroReaction(true);
                if (this.isLeader()) {
                    this.broadcastTargetToNearbyFollowers(newTarget);
                }
            } else {
                this.setNeedsAggroReaction(false);
                this.setShowAggroIndicator(false);
                if (this.isLeader()) {
                    this.broadcastTargetToNearbyFollowers(null);
                }
            }
        }
    }

    @Override
    public boolean isGenshinFriend(LivingEntity entity) {
        return entity instanceof AbyssalEntity;
    }

    public void alertNearbyAllies(LivingEntity attacker) {
        AABB searchBox = this.getBoundingBox().inflate(24.0);
        List nearbyAllies = this.level().getEntitiesOfClass(AbyssalEntity.class, searchBox, ally -> ally != this && ally.isAlive() && (ally.getTarget() == null || !ally.getTarget().is((Entity)attacker)) && !this.isGenshinFriend(attacker));
        if (!nearbyAllies.isEmpty()) {
            for (AbyssalEntity ally2 : nearbyAllies) {
                ally2.setTarget(attacker);
            }
        }
    }
}

