/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.abyssal.hilichurl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.api.capability.shield.IShield;
import net.zenith.hoyocraft.api.capability.shield.ShieldDefinitions;
import net.zenith.hoyocraft.block.ModBlocks;
import net.zenith.hoyocraft.capability.ShieldCapability;
import net.zenith.hoyocraft.entity.ai.goal.CookRawFoodGoal;
import net.zenith.hoyocraft.entity.ai.goal.GenshinHungerHealGoal;
import net.zenith.hoyocraft.entity.ai.goal.HilichurlCampGoal;
import net.zenith.hoyocraft.entity.ai.goal.HilichurlFollowLeaderGoal;
import net.zenith.hoyocraft.entity.ai.goal.HilichurlLeaderPatrolGoal;
import net.zenith.hoyocraft.entity.ai.goal.WanderNearCampfireGoal;
import net.zenith.hoyocraft.entity.ai.goal.ambient.AmbientBehaviorGoal;
import net.zenith.hoyocraft.entity.ai.goal.ambient.AmbientBehaviorParameters;
import net.zenith.hoyocraft.entity.ai.goal.ambient.TimedLoopingParticleConfig;
import net.zenith.hoyocraft.entity.ai.goal.ambient.TimedLoopingSoundConfig;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.AggroReactionGoal;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.CircleAction;
import net.zenith.hoyocraft.entity.core.combat.actions.CombatAction;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.combat.actions.TauntAction;
import net.zenith.hoyocraft.entity.core.types.AbyssalEntity;
import net.zenith.hoyocraft.entity.custom.abyssal.hilichurl.attacks.FighterClubAttackGoal;
import net.zenith.hoyocraft.network.ModNetworking;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HilichurlFighterEntity
extends AbyssalEntity
implements GeoEntity,
ITauntableGenshinEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private AnimationController<HilichurlFighterEntity> hitAnimationController;
    private int currentTauntIndex = 0;
    private boolean sprinting = false;
    private boolean leftCircling;
    private boolean attackingGeckoLib = false;
    final double MONSTER_AGGRO_RANGE_SQR = 64.0;
    private static final EntityDataAccessor<Boolean> DATA_IS_USING_AFK_TEXTURE = SynchedEntityData.defineId(HilichurlFighterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final AmbientBehaviorParameters HILICHURL_SLEEP_BEHAVIOR = new AmbientBehaviorParameters("HilichurlSleep", "hilichurl_fighter.animation.sleep", 2000, 3.0f, List.of(new TimedLoopingSoundConfig(SoundEvents.CAT_PURR, SoundSource.HOSTILE, 0.4f, 0.8f, 40, 1160, 100)), List.of(new TimedLoopingParticleConfig((ParticleOptions)ParticleTypes.NOTE, 1, new Vec3(0.0, 1.8, -0.5), 0.1, 0.1, 0.1, 0.02, 60, 1140, 60)));
    private static final AmbientBehaviorParameters HILICHURL_DIG_BEHAVIOR = new AmbientBehaviorParameters("HilichurlDig", "hilichurl_fighter.animation.digging", 1200, 4.0f, List.of(new TimedLoopingSoundConfig(SoundEvents.GRAVEL_PLACE, SoundSource.HOSTILE, 0.8f, 1.2f, 20, 1180, 10)), List.of(new TimedLoopingParticleConfig((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), 3, new Vec3(0.0, 0.2, 0.0), 0.5, 0.1, 0.2, 0.1, 20, 1180, 5)));
    private static final AmbientBehaviorParameters HILICHURL_SIT_BEHAVIOR = new AmbientBehaviorParameters("HilichurlSit", "hilichurl_fighter.animation.sitting", 812, 4.0f, List.of(new TimedLoopingSoundConfig(SoundEvents.BEE_LOOP, SoundSource.HOSTILE, 0.5f, 1.2f, 320, 100, 40)), List.of(new TimedLoopingParticleConfig((ParticleOptions)ParticleTypes.MYCELIUM, 2, new Vec3(0.0, 0.2, 0.0), 0.4, 0.4, 0.4, 0.01, 320, 100, 2)));

    @Override
    public boolean isAttackingGeckoLib() {
        return this.attackingGeckoLib;
    }

    public HilichurlFighterEntity(EntityType<? extends HilichurlFighterEntity> entityType, Level level) {
        super((EntityType<? extends AbyssalEntity>)entityType, level);
        List<EntityType<?>> fighterHuntableAnimals = List.of(EntityType.COW, EntityType.PIG, EntityType.SHEEP, EntityType.CHICKEN, EntityType.RABBIT);
        HashMap<Item, Float> fighterEdibleItems = new HashMap<Item, Float>();
        fighterEdibleItems.put(Items.BEEF, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.PORKCHOP, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.MUTTON, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.CHICKEN, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.COOKED_BEEF, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.COOKED_PORKCHOP, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.COOKED_MUTTON, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.COOKED_CHICKEN, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.COOKED_RABBIT, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.APPLE, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.CARROT, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.POTATO, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.BREAD, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.MELON, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.COD, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.COOKED_COD, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.SALMON, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.COOKED_SALMON, Float.valueOf(0.2f));
        fighterEdibleItems.put(Items.RABBIT, Float.valueOf(0.1f));
        fighterEdibleItems.put(Items.EGG, Float.valueOf(0.1f));
        HashMap<Block, Float> fighterEdibleBlocks = new HashMap<Block, Float>();
        fighterEdibleBlocks.put(Blocks.HAY_BLOCK, Float.valueOf(0.4f));
        fighterEdibleBlocks.put(Blocks.PUMPKIN, Float.valueOf(0.4f));
        fighterEdibleBlocks.put(Blocks.MELON, Float.valueOf(0.4f));
        fighterEdibleBlocks.put(Blocks.CARROTS, Float.valueOf(0.2f));
        fighterEdibleBlocks.put(Blocks.WHEAT, Float.valueOf(0.2f));
        fighterEdibleBlocks.put(Blocks.POTATOES, Float.valueOf(0.2f));
        fighterEdibleBlocks.put(ModBlocks.LARGE_CRATE.get(), Float.valueOf(0.5f));
        fighterEdibleBlocks.put(ModBlocks.HILICHURL_BARREL.get(), Float.valueOf(0.4f));
        this.setEdibleBlocks(fighterEdibleBlocks);
        this.setHuntableAnimals(fighterHuntableAnimals);
        this.setEdibleItems(fighterEdibleItems);
        PathNavigation pathNavigation = this.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundNavigation = (GroundPathNavigation)pathNavigation;
            this.setPathfindingMalus(PathType.DOOR_WOOD_CLOSED, 0.0f);
            this.setPathfindingMalus(PathType.DOOR_IRON_CLOSED, -1.0f);
            this.setPathfindingMalus(PathType.DOOR_OPEN, 0.0f);
        }
        this.ensureSpecificGoalsRegistered();
    }

    @Override
    public List<AmbientBehaviorParameters> getAmbientBehaviors() {
        return List.of(HILICHURL_SLEEP_BEHAVIOR, HILICHURL_DIG_BEHAVIOR, HILICHURL_SIT_BEHAVIOR);
    }

    private static CombatAction.CombatActionParameters createHilichurlJumpSwingParams() {
        String actionNameForLogging = "HilichurlJumpSwing";
        String animationName = "hilichurl_fighter.animation.jumpswing";
        int totalActionDurationTicks = 19;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int walkMovementStartTime = 0;
        float desiredEffectiveSpeed = 0.25f;
        float entityBaseSpeed = 0.2f;
        float speedMultiplierForWalk = desiredEffectiveSpeed / entityBaseSpeed;
        int walkMovementDurationTicks = 10;
        movements.add(new CombatAction.MovementSegmentConfig(walkMovementStartTime, walkMovementDurationTicks, CombatAction.MovementType.NAVIGATE_TO_TARGET, speedMultiplierForWalk, true, 0.0f, 0.0f, null));
        int leapStartTime = 10;
        int leapMovementDurationTicks = totalActionDurationTicks - leapStartTime;
        movements.add(new CombatAction.MovementSegmentConfig(leapStartTime, leapMovementDurationTicks, CombatAction.MovementType.LEAP_TOWARDS_TARGET, 0.9f, false, 0.3f, 0.8f, null));
        ArrayList<CombatAction.DamageEventConfig> damages = new ArrayList<CombatAction.DamageEventConfig>();
        damages.add(new CombatAction.DamageEventConfig(11, 9.0f, 1.4f, new Vec3(0.0, 0.5, 1.0), 0.6f, 0.1f, (ParticleOptions)ParticleTypes.CRIT, 10, 0.7f, 0.05f, SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.HOSTILE, 1.0f, 0.8f));
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damages, continuouslyFaceTarget);
    }

    private static CombatAction.CombatActionParameters createHilichurlTripleSwingParams() {
        String actionNameForLogging = "HilichurlTripleSwing";
        String animationName = "hilichurl_fighter.animation.tripleswing";
        int totalActionDurationTicks = 36;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int walkMovementStartTime = 3;
        int walkMovementDurationTicks = totalActionDurationTicks - walkMovementStartTime;
        float walkSpeedMultiplier = 1.8f;
        movements.add(new CombatAction.MovementSegmentConfig(walkMovementStartTime, walkMovementDurationTicks, CombatAction.MovementType.NAVIGATE_TO_TARGET, walkSpeedMultiplier, true, 0.0f, 0.0f, null));
        ArrayList<CombatAction.DamageEventConfig> damages = new ArrayList<CombatAction.DamageEventConfig>();
        Vec3 commonDamageOffset = new Vec3(0.0, 0.5, 1.0);
        damages.add(new CombatAction.DamageEventConfig(8, 5.0f, 1.4f, commonDamageOffset, 0.3f, 0.0f, (ParticleOptions)ParticleTypes.SWEEP_ATTACK, 1, 0.7f, 0.05f, SoundEvents.PLAYER_ATTACK_STRONG, SoundSource.HOSTILE, 1.0f, 0.8f));
        damages.add(new CombatAction.DamageEventConfig(14, 4.0f, 1.4f, commonDamageOffset, 0.0f, 0.3f, (ParticleOptions)ParticleTypes.CRIT, 10, 0.7f, 0.05f, SoundEvents.PLAYER_ATTACK_WEAK, SoundSource.HOSTILE, 1.2f, 1.0f));
        damages.add(new CombatAction.DamageEventConfig(22, 7.0f, 1.6f, commonDamageOffset, 1.0f, 0.2f, (ParticleOptions)ParticleTypes.GUST, 1, 0.7f, 0.05f, SoundEvents.PLAYER_ATTACK_KNOCKBACK, SoundSource.HOSTILE, 2.0f, 0.8f));
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damages, continuouslyFaceTarget);
    }

    private static CombatAction.CombatActionParameters createHilichurlSmashParams() {
        String actionNameForLogging = "HilichurlSmash";
        String animationName = "hilichurl_fighter.animation.smash";
        int totalActionDurationTicks = 35;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int leapStartTimeSmash = 14;
        int leapMovementDurationSmash = totalActionDurationTicks - leapStartTimeSmash;
        movements.add(new CombatAction.MovementSegmentConfig(leapStartTimeSmash, leapMovementDurationSmash, CombatAction.MovementType.LEAP_TOWARDS_TARGET, 0.5f, false, 0.7f, 1.2f, null));
        ArrayList<CombatAction.DamageEventConfig> damages = new ArrayList<CombatAction.DamageEventConfig>();
        damages.add(new CombatAction.DamageEventConfig(24, 14.0f, 4.0f, new Vec3(0.0, 0.5, 0.5), 0.6f, 0.3f, (ParticleOptions)ParticleTypes.CRIT, 10, 0.7f, 0.05f, SoundEvents.PLAYER_ATTACK_KNOCKBACK, SoundSource.HOSTILE, 1.2f, 0.8f));
        ArrayList<CombatAction.TimedParticleEventConfig> timedParticles = new ArrayList<CombatAction.TimedParticleEventConfig>();
        timedParticles.add(new CombatAction.TimedParticleEventConfig(24, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), 30, new Vec3(0.0, 0.0, 0.0), 1.0, 0.1, 1.0, 0.05));
        ArrayList<CombatAction.TimedSoundEventConfig> timedSounds = new ArrayList<CombatAction.TimedSoundEventConfig>();
        timedSounds.add(new CombatAction.TimedSoundEventConfig(3, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.HOSTILE, 0.8f, 0.05f));
        timedSounds.add(new CombatAction.TimedSoundEventConfig(6, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.HOSTILE, 0.8f, 0.05f));
        timedSounds.add(new CombatAction.TimedSoundEventConfig(9, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.HOSTILE, 0.8f, 0.05f));
        timedSounds.add(new CombatAction.TimedSoundEventConfig(leapStartTimeSmash, SoundEvents.BREEZE_JUMP, SoundSource.HOSTILE, 0.8f, 0.8f));
        timedSounds.add(new CombatAction.TimedSoundEventConfig(22, SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.HOSTILE, 0.9f, 1.2f));
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damages, timedParticles, timedSounds, continuouslyFaceTarget);
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        ArrayList<Supplier<IGenshinAction>> actions = new ArrayList<Supplier<IGenshinAction>>();
        actions.add(() -> new TauntAction());
        actions.add(() -> new CircleAction());
        actions.add(() -> new CombatAction(HilichurlFighterEntity.createHilichurlJumpSwingParams()));
        actions.add(() -> new CombatAction(HilichurlFighterEntity.createHilichurlTripleSwingParams()));
        actions.add(() -> new CombatAction(HilichurlFighterEntity.createHilichurlSmashParams()));
        return actions;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController baseController = new AnimationController((GeoAnimatable)this, "base_controller", 5, this::basePredicate);
        controllerRegistrar.add(baseController);
        AnimationController instantStateController = new AnimationController((GeoAnimatable)this, "instant_state_controller", 0, this::instantStatePredicate);
        controllerRegistrar.add(instantStateController);
        AnimationController upperBodyController = new AnimationController((GeoAnimatable)this, "upper_body_controller", 5, this::upperBodyPredicate);
        controllerRegistrar.add(upperBodyController);
        this.hitAnimationController = new AnimationController((GeoAnimatable)this, "hit_controller", 0, event -> PlayState.CONTINUE);
        controllerRegistrar.add(this.hitAnimationController);
    }

    private PlayState instantStatePredicate(AnimationState<HilichurlFighterEntity> event) {
        RawAnimation aggroAnim = RawAnimation.begin().thenPlay("hilichurl_fighter.animation.aggro");
        AnimationController controller = event.getController();
        HilichurlFighterEntity entity = (HilichurlFighterEntity)event.getAnimatable();
        boolean conditionResult = entity.isShowingAggroIndicator();
        if (conditionResult) {
            controller.setAnimation(aggroAnim);
            return PlayState.CONTINUE;
        }
        controller.setAnimation(null);
        return PlayState.STOP;
    }

    private PlayState basePredicate(AnimationState<HilichurlFighterEntity> event) {
        HilichurlFighterEntity entity = (HilichurlFighterEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        if (this.hitAnimationController != null && this.hitAnimationController.getAnimationState() != AnimationController.State.STOPPED) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        RawAnimation sprintAnim = RawAnimation.begin().thenLoop("hilichurl_fighter.animation.sprint");
        RawAnimation walkAnim = RawAnimation.begin().thenLoop("hilichurl_fighter.animation.walk");
        RawAnimation idleAnim = RawAnimation.begin().thenLoop("hilichurl_fighter.animation.idle");
        if (entity.isSprintingEntity() && event.isMoving()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("hilichurl_fighter.animation.sprint") || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(sprintAnim);
            }
        } else if (event.isMoving()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("hilichurl_fighter.animation.walk") || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(walkAnim);
            }
        } else if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("hilichurl_fighter.animation.idle") || controller.getAnimationState() == AnimationController.State.STOPPED) {
            controller.setAnimation(idleAnim);
        }
        return PlayState.CONTINUE;
    }

    private PlayState upperBodyPredicate(AnimationState<HilichurlFighterEntity> event) {
        HilichurlFighterEntity entity = (HilichurlFighterEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        String currentActualActionAnim = entity.getCurrentActionAnimationName();
        if (this.hitAnimationController != null && this.hitAnimationController.getAnimationState() != AnimationController.State.STOPPED) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        if (entity.isAttackingGeckoLib() && currentActualActionAnim != null && !currentActualActionAnim.isEmpty()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals(currentActualActionAnim) || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(RawAnimation.begin().thenPlay(currentActualActionAnim));
            }
            return PlayState.CONTINUE;
        }
        if (entity.getTauntState() > 0) {
            RawAnimation selectedTaunt = null;
            switch (entity.getTauntState()) {
                case 1: {
                    selectedTaunt = RawAnimation.begin().thenPlay("hilichurl_fighter.animation.taunt");
                    break;
                }
                case 2: {
                    selectedTaunt = RawAnimation.begin().thenPlay("hilichurl_fighter.animation.taunttwo");
                    break;
                }
                case 3: {
                    selectedTaunt = RawAnimation.begin().thenPlay("hilichurl_fighter.animation.tauntthree");
                }
            }
            if (selectedTaunt != null) {
                if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals(((RawAnimation.Stage)selectedTaunt.getAnimationStages().get(0)).animationName()) || controller.getAnimationState() == AnimationController.State.STOPPED) {
                    controller.setAnimation(selectedTaunt);
                }
                return PlayState.CONTINUE;
            }
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    @Override
    public void setAttackingGeckoLib(boolean attacking) {
        if (this.attackingGeckoLib != attacking) {
            AnimationController controller;
            AnimatableInstanceCache cache;
            this.attackingGeckoLib = attacking;
            if (attacking && (cache = this.getAnimatableInstanceCache()) != null && (controller = (AnimationController)cache.getManagerForId((long)this.getId()).getAnimationControllers().get("upper_body_controller")) != null) {
                controller.forceAnimationReset();
            }
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, this.sprinting, this.attackingGeckoLib, this.leftCircling, false);
            }
        }
    }

    @Override
    public void setTauntState(int index) {
        if (this.currentTauntIndex != index) {
            this.currentTauntIndex = index;
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, this.sprinting, this.attackingGeckoLib, this.leftCircling, false);
            }
        }
    }

    @Override
    public int getTauntState() {
        return this.currentTauntIndex;
    }

    @Override
    public int[] getAvailableTauntStates() {
        return new int[]{1, 2, 3};
    }

    @Override
    public void setSprinting(boolean sprint) {
        if (sprint != this.sprinting) {
            this.sprinting = sprint;
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, this.sprinting, this.attackingGeckoLib, this.leftCircling, false);
            }
        }
    }

    public boolean isSprintingEntity() {
        return this.sprinting;
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        double baseAttributeSpeed = this.getAttributeBaseValue(Attributes.MOVEMENT_SPEED);
        double sprintSpeed = 0.36;
        double walkSpeed = 0.2;
        if (baseAttributeSpeed < 0.001) {
            baseAttributeSpeed = 0.15;
        }
        if (this.isSprintingEntity()) {
            return sprintSpeed / baseAttributeSpeed;
        }
        return walkSpeed / baseAttributeSpeed;
    }

    public boolean isLeftCircling() {
        return this.leftCircling;
    }

    @Override
    public void setLeftCircling(boolean leftCircling) {
        if (this.leftCircling != leftCircling) {
            this.leftCircling = leftCircling;
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, this.sprinting, this.attackingGeckoLib, this.leftCircling, false);
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void registerSpecificGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, new AggroReactionGoal<HilichurlFighterEntity>(this, 15));
        this.goalSelector.addGoal(1, this.createAttackGoal());
        this.goalSelector.addGoal(2, new CookRawFoodGoal<HilichurlFighterEntity>(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new HilichurlCampGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SprintAtTargetGoal(this, 5.0));
        this.goalSelector.addGoal(3, (Goal)new HilichurlLeaderPatrolGoal(this, 1.0, 400));
        this.goalSelector.addGoal(3, (Goal)new HilichurlFollowLeaderGoal(this));
        this.goalSelector.addGoal(4, (Goal)new AmbientBehaviorGoal(this));
        this.goalSelector.addGoal(4, (Goal)new WanderNearCampfireGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, new GenshinHungerHealGoal<HilichurlFighterEntity>(this));
        this.goalSelector.addGoal(6, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, GenshinEntity.class, true, potentialTarget -> !this.isGenshinFriend((LivingEntity)potentialTarget)));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, potentialTarget -> {
            if (this.isGenshinFriend((LivingEntity)potentialTarget)) {
                return false;
            }
            if (potentialTarget instanceof Creeper) {
                return false;
            }
            return !(this.distanceToSqr((Entity)potentialTarget) > 64.0);
        }));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, potentialTarget -> {
            boolean isHungry;
            LivingEntity currentActualTarget = this.getTarget();
            if (currentActualTarget != null && currentActualTarget.isAlive() && (currentActualTarget instanceof Player || currentActualTarget instanceof Monster || currentActualTarget instanceof Villager || currentActualTarget instanceof GenshinEntity)) {
                return false;
            }
            boolean bl = isHungry = (double)this.getHealth() <= (double)this.getMaxHealth() * 0.75;
            if (!isHungry) {
                return false;
            }
            Predicate<ItemEntity> isEdibleFoodItem = itemEntity -> itemEntity.isAlive() && this.getEdibleItems().containsKey(itemEntity.getItem().getItem());
            List nearbyFoodItems = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(10.0), isEdibleFoodItem);
            if (!nearbyFoodItems.isEmpty()) {
                return false;
            }
            boolean isHuntableType = this.getHuntableAnimals().contains(potentialTarget.getType());
            return isHuntableType && this.canAttack((LivingEntity)potentialTarget);
        }));
    }

    @Override
    @Deprecated
    @Nullable
    @ApiStatus.OverrideOnly
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        SpawnGroupData spawnData = super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
        if (!pLevel.isClientSide()) {
            IShield shield = (IShield)this.getCapability(ShieldCapability.SHIELD_CAPABILITY);
            if (shield != null) {
                System.out.println("[FINALIZE SPAWN] Found shield capability for HilichurlFighter " + this.getId() + ". Applying default shield.");
                shield.setDefinition(ShieldDefinitions.ABYSSAL);
                shield.setMaxHealth(100.0f);
                shield.setCurrentHealth(100.0f);
                shield.setRegenRate(0.0f);
                shield.setRegenCooldown(0);
            } else {
                System.out.println("[FINALIZE SPAWN] ERROR: Shield capability was NULL for HilichurlFighter " + this.getId());
            }
        }
        return spawnData;
    }

    @Override
    protected Goal createAttackGoal() {
        return new FighterClubAttackGoal(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 73.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.STEP_HEIGHT, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 1.0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
    }

    public boolean doHurtTarget(Entity entity) {
        boolean success = super.doHurtTarget(entity);
        return success;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.sprinting && this.onGround() && this.random.nextFloat() < 0.5f) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), this.getX(), this.getY() + 0.1, this.getZ(), 1, (this.random.nextDouble() - 0.5) * 0.2, 0.0, (this.random.nextDouble() - 0.5) * 0.2, 0.0);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 2) {
            if (this.level().isClientSide()) {
                AnimatableInstanceCache cache = this.getAnimatableInstanceCache();
                if (cache == null) {
                    super.handleEntityEvent(id);
                    return;
                }
                AnimatableManager animManager = cache.getManagerForId((long)this.getId());
                if (animManager == null) {
                    super.handleEntityEvent(id);
                    return;
                }
                AnimationController upperBodyController = (AnimationController)animManager.getAnimationControllers().get("upper_body_controller");
                AnimationController hitController = (AnimationController)animManager.getAnimationControllers().get("hit_controller");
                boolean isActionPlaying = false;
                if (upperBodyController != null && upperBodyController.getCurrentAnimation() != null && upperBodyController.getAnimationState() != AnimationController.State.STOPPED) {
                    isActionPlaying = true;
                }
                if (hitController != null && !isActionPlaying) {
                    String selectedHurtAnimationName = "";
                    if (this instanceof HilichurlFighterEntity) {
                        int randomIndex = this.random.nextInt(3);
                        switch (randomIndex) {
                            case 0: {
                                selectedHurtAnimationName = "hilichurl_fighter.animation.hurt";
                                break;
                            }
                            case 1: {
                                selectedHurtAnimationName = "hilichurl_fighter.animation.hurttwo";
                                break;
                            }
                            default: {
                                selectedHurtAnimationName = "hilichurl_fighter.animation.hurtthree";
                            }
                        }
                    }
                    if (!selectedHurtAnimationName.isEmpty()) {
                        hitController.setAnimation(RawAnimation.begin().thenPlay(selectedHurtAnimationName));
                    }
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_USING_AFK_TEXTURE, (Object)false);
    }

    public boolean isUsingAfkTexture() {
        return (Boolean)this.entityData.get(DATA_IS_USING_AFK_TEXTURE);
    }

    public void setUsingAfkTexture(boolean usingAfkTexture) {
        this.entityData.set(DATA_IS_USING_AFK_TEXTURE, (Object)usingAfkTexture);
    }

    @Override
    public void onAmbientBehaviorStarted(AmbientBehaviorParameters behavior) {
        super.onAmbientBehaviorStarted(behavior);
        if (!this.level().isClientSide()) {
            this.setUsingAfkTexture(true);
        }
    }

    @Override
    public void onAmbientBehaviorStopped(@Nullable AmbientBehaviorParameters behavior) {
        super.onAmbientBehaviorStopped(behavior);
        if (!this.level().isClientSide()) {
            this.setUsingAfkTexture(false);
        }
    }

    static class SprintAtTargetGoal
    extends Goal {
        private final HilichurlFighterEntity hilichurl;
        private final double sprintRange;
        private int pathingStuckTimer;
        private static final int MAX_PATHING_STUCK_TICKS = 60;

        public SprintAtTargetGoal(HilichurlFighterEntity hilichurl, double sprintRange) {
            this.hilichurl = hilichurl;
            this.sprintRange = sprintRange;
            this.setFlags(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean canUse() {
            LivingEntity target = this.hilichurl.getTarget();
            boolean isTargetHostile = target != null && target.isAlive() && (target instanceof Player || target instanceof Monster || target instanceof Villager || target instanceof IronGolem || target instanceof GenshinEntity);
            return isTargetHostile && this.hilichurl.distanceToSqr((Entity)target) >= this.sprintRange * this.sprintRange && !this.hilichurl.isSprintingEntity();
        }

        public boolean canContinueToUse() {
            LivingEntity target = this.hilichurl.getTarget();
            boolean isTargetHostile = target != null && target.isAlive() && (target instanceof Player || target instanceof Monster || target instanceof Villager || target instanceof IronGolem || target instanceof GenshinEntity);
            return isTargetHostile && this.hilichurl.isSprintingEntity();
        }

        public void start() {
            this.hilichurl.setSprinting(true);
            this.pathingStuckTimer = 0;
        }

        public void stop() {
            this.hilichurl.setSprinting(false);
            this.pathingStuckTimer = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity target = this.hilichurl.getTarget();
            if (target == null || !target.isAlive()) {
                if (this.hilichurl.isSprintingEntity()) {
                    this.hilichurl.setSprinting(false);
                }
                return;
            }
            if (this.hilichurl.isSprintingEntity()) {
                double distanceSqToTarget = this.hilichurl.distanceToSqr((Entity)target);
                if (distanceSqToTarget < (this.sprintRange - 1.0) * (this.sprintRange - 1.0)) {
                    this.hilichurl.setSprinting(false);
                    this.pathingStuckTimer = 0;
                    return;
                }
                if (this.hilichurl.getNavigation().isDone() && distanceSqToTarget >= (this.sprintRange - 1.0) * (this.sprintRange - 1.0)) {
                    ++this.pathingStuckTimer;
                    if (this.pathingStuckTimer > 60) {
                        this.hilichurl.setSprinting(false);
                    }
                } else {
                    this.pathingStuckTimer = 0;
                }
            }
        }
    }
}

