/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.abyssal.invasion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.AbyssalEntity;
import net.zenith.hoyocraft.invasion.AbyssalInvasionManager;
import net.zenith.hoyocraft.invasion.IncursionPattern;
import net.zenith.hoyocraft.invasion.InvasionSavedData;
import net.zenith.hoyocraft.network.ModNetworking;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AbyssPortalEntity
extends AbyssalEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Logger LOGGER = LogManager.getLogger();
    private PortalState state = PortalState.WAITING;
    private int cooldown;
    private int currentWave = 0;
    @Nullable
    private UUID invasionTargetUUID;
    private List<IncursionPattern.IncursionWave> waveData = new ArrayList<IncursionPattern.IncursionWave>();
    private int waveIntervalTicks = 1200;
    private static final int INITIAL_DELAY_TICKS = 200;
    private static final int SPAWN_INTERVAL_TICKS = 20;
    private final List<EntityType<? extends Mob>> spawnQueue = new ArrayList<EntityType<? extends Mob>>();
    private final List<UUID> spawnedMobUUIDs = new ArrayList<UUID>();
    private final List<UUID> currentWaveMobUUIDs = new ArrayList<UUID>();
    private boolean isInitialized = false;

    public AbyssPortalEntity(EntityType<? extends AbyssPortalEntity> entityType, Level level) {
        super((EntityType<? extends AbyssalEntity>)entityType, level);
        this.noPhysics = true;
        this.cooldown = 200;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public void reinitializeFromSave(List<IncursionPattern.IncursionWave> waveData, int waveIntervalTicks, @Nullable UUID invasionTargetUUID) {
        LOGGER.info("Portal {} is being re-initialized by the manager.", (Object)this.getId());
        this.waveData = waveData;
        this.waveIntervalTicks = waveIntervalTicks;
        this.invasionTargetUUID = invasionTargetUUID;
        this.isInitialized = true;
    }

    @Override
    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, 0.0, 0.0);
        if (this.level().isClientSide) {
            this.tickClient();
        } else {
            if (!this.isInitialized) {
                return;
            }
            this.tickServer();
        }
    }

    private void tickClient() {
        for (int i = 0; i < 32; ++i) {
            double d0 = this.getX() + this.random.nextDouble() - 0.5;
            double d1 = this.getY() + this.random.nextDouble();
            double d2 = this.getZ() + this.random.nextDouble() - 0.5;
            double d3 = (this.random.nextDouble() - 0.5) * 2.0;
            double d4 = -this.random.nextDouble();
            double d5 = (this.random.nextDouble() - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
        if (this.tickCount % 200 == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.CONDUIT_AMBIENT, SoundSource.HOSTILE, 0.5f, this.random.nextFloat() * 0.4f + 0.8f, false);
        }
    }

    private void tickServer() {
        if (this.state == PortalState.DONE) {
            this.checkIfSpawnedMobsAreDead();
            return;
        }
        if (this.state == PortalState.WAITING) {
            this.checkWaveCompletion();
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.state == PortalState.WAITING) {
            if (this.currentWave < this.waveData.size()) {
                this.prepareWave(this.currentWave);
                this.state = PortalState.SPAWNING;
                this.cooldown = 1;
            }
        } else if (this.state == PortalState.SPAWNING) {
            if (!this.spawnQueue.isEmpty()) {
                EntityType<? extends Mob> toSpawn = this.spawnQueue.remove(0);
                this.spawnMob((ServerLevel)this.level(), toSpawn);
                this.cooldown = 20;
            }
            if (this.spawnQueue.isEmpty()) {
                ++this.currentWave;
                if (this.currentWave >= this.waveData.size()) {
                    this.state = PortalState.DONE;
                    LOGGER.info("Portal {} finished spawning all waves. Now tracking {} mobs.", (Object)this.getId(), (Object)this.spawnedMobUUIDs.size());
                } else {
                    this.state = PortalState.WAITING;
                    this.cooldown = this.waveIntervalTicks;
                }
            }
        }
    }

    private void checkIfSpawnedMobsAreDead() {
        if (this.level().isClientSide()) {
            return;
        }
        this.spawnedMobUUIDs.removeIf(uuid -> {
            Entity mob = ((ServerLevel)this.level()).getEntity(uuid);
            return mob == null || !mob.isAlive();
        });
        if (this.spawnedMobUUIDs.isEmpty()) {
            LOGGER.info("All mobs spawned by portal {} have been defeated. Initiating self-destruct.", (Object)this.getId());
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private void prepareWave(int waveIndex) {
        if (waveIndex >= this.waveData.size()) {
            return;
        }
        this.spawnQueue.clear();
        this.currentWaveMobUUIDs.clear();
        IncursionPattern.IncursionWave wave = this.waveData.get(waveIndex);
        for (IncursionPattern.SpawnInfo spawnInfo : wave.spawns()) {
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(spawnInfo.entityId());
            if (entityType == null || !(entityType.create(this.level()) instanceof Mob)) continue;
            int count = Mth.nextInt((RandomSource)this.random, (int)spawnInfo.minCount(), (int)spawnInfo.maxCount());
            for (int i = 0; i < count; ++i) {
                this.spawnQueue.add((EntityType<? extends Mob>)entityType);
            }
        }
        Collections.shuffle(this.spawnQueue, new Random(this.random.nextLong()));
    }

    private void spawnMob(ServerLevel level, EntityType<? extends Mob> entityType) {
        BlockPos spawnPos = this.blockPosition();
        Mob mob = (Mob)entityType.create((Level)level);
        if (mob != null) {
            mob.setPos(this.getX(), this.getY(), this.getZ());
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(spawnPos), MobSpawnType.EVENT, null);
            if (mob instanceof GenshinEntity) {
                Player targetPlayer;
                GenshinEntity genshinMob = (GenshinEntity)mob;
                if (this.invasionTargetUUID != null && (targetPlayer = level.getPlayerByUUID(this.invasionTargetUUID)) != null && targetPlayer.isAlive()) {
                    genshinMob.setInvasionTarget((LivingEntity)targetPlayer);
                }
            }
            this.spawnedMobUUIDs.add(mob.getUUID());
            this.currentWaveMobUUIDs.add(mob.getUUID());
            level.addFreshEntity((Entity)mob);
            level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.HOSTILE, 1.0f, 1.0f);
            InvasionSavedData savedData = InvasionSavedData.get(level);
            int portalIndex = savedData.activePortalUUIDs.indexOf(this.getUUID());
            if (portalIndex != -1) {
                ModNetworking.sendPortalSpawnMobEvent(portalIndex);
            }
        }
    }

    private void checkWaveCompletion() {
        if (this.level().isClientSide() || this.currentWaveMobUUIDs.isEmpty()) {
            return;
        }
        this.currentWaveMobUUIDs.removeIf(uuid -> {
            Entity mob = ((ServerLevel)this.level()).getEntity(uuid);
            return mob == null || !mob.isAlive();
        });
        if (this.currentWaveMobUUIDs.isEmpty()) {
            LOGGER.info("Portal {} detected wave clear.", (Object)this.getId());
            InvasionSavedData savedData = InvasionSavedData.get((ServerLevel)this.level());
            int portalIndex = savedData.activePortalUUIDs.indexOf(this.getUUID());
            if (portalIndex != -1) {
                ModNetworking.sendIncursionWaveClearEvent(portalIndex);
            } else {
                LOGGER.warn("Portal {} cleared a wave but was not found in the active portal list!", (Object)this.getId());
            }
        }
    }

    public void setInvasionData(List<IncursionPattern.IncursionWave> waveData, int waveIntervalTicks, @Nullable UUID invasionTargetUUID) {
        this.waveData = waveData;
        this.waveIntervalTicks = waveIntervalTicks;
        this.invasionTargetUUID = invasionTargetUUID;
        this.isInitialized = true;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        return Collections.emptyList();
    }

    @Override
    protected void registerSpecificGoals() {
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        return 0.0;
    }

    @Override
    protected Goal createAttackGoal() {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("abyss_portal.animation.idle"));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putString("PortalState", this.state.name());
        pCompound.putInt("Cooldown", this.cooldown);
        pCompound.putInt("CurrentWave", this.currentWave);
        ListTag uuidList = new ListTag();
        for (UUID uuid : this.spawnedMobUUIDs) {
            uuidList.add((Object)StringTag.valueOf((String)uuid.toString()));
        }
        pCompound.put("SpawnedMobs", (Tag)uuidList);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.state = PortalState.valueOf(pCompound.getString("PortalState"));
        this.cooldown = pCompound.getInt("Cooldown");
        this.currentWave = pCompound.getInt("CurrentWave");
        this.spawnedMobUUIDs.clear();
        if (pCompound.contains("SpawnedMobs", 9)) {
            ListTag uuidList = pCompound.getList("SpawnedMobs", 8);
            for (int i = 0; i < uuidList.size(); ++i) {
                this.spawnedMobUUIDs.add(UUID.fromString(uuidList.getString(i)));
            }
        }
    }

    @Override
    public boolean isPersistenceRequired() {
        return true;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ChunkPos chunkPos = this.chunkPosition();
            serverLevel.setChunkForced(chunkPos.x, chunkPos.z, true);
        }
    }

    public void remove(Entity.RemovalReason pReason) {
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ChunkPos chunkPos = this.chunkPosition();
            serverLevel.setChunkForced(chunkPos.x, chunkPos.z, false);
            LOGGER.info("Abyss Portal {} un-forcing chunk [{}, {}].", (Object)this.getId(), (Object)chunkPos.x, (Object)chunkPos.z);
        }
        if (!this.level().isClientSide()) {
            AbyssalInvasionManager.getInstance().onPortalDestroyed((ServerLevel)this.level(), this);
        }
        super.remove(pReason);
    }

    private static enum PortalState {
        WAITING,
        SPAWNING,
        DONE;

    }
}

