/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.abyssal.invasion;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.AbyssalEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AbyssalPylonEntity
extends AbyssalEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AbyssalPylonEntity(EntityType<? extends AbyssalPylonEntity> entityType, Level level) {
        super((EntityType<? extends AbyssalEntity>)entityType, level);
        this.noPhysics = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        return Collections.emptyList();
    }

    @Override
    protected void registerSpecificGoals() {
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        return 0.0;
    }

    @Override
    protected Goal createAttackGoal() {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("abyssal_pylon.animation.idle"));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean isPersistenceRequired() {
        return true;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.level().isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ChunkPos chunkPos = this.chunkPosition();
            serverLevel.setChunkForced(chunkPos.x, chunkPos.z, true);
        }
    }
}

