/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.animal.birds;

import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.zenith.hoyocraft.entity.ai.goal.BirdFlightGoal;
import net.zenith.hoyocraft.entity.core.GenshinWildlife;

public abstract class BirdEntity
extends GenshinWildlife {
    public boolean hasCompletedInitialAscent = false;
    private FlightMode currentFlightMode = FlightMode.GROUNDED;

    public abstract double getConfigurableAscentHeight();

    protected BirdEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected PathNavigation createNavigation(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new BirdFlightGoal(this, 1.0, 5.0, 15.0));
    }

    public FlightMode getCurrentFlightMode() {
        return this.currentFlightMode;
    }

    public void setCurrentFlightMode(FlightMode mode) {
        if (this.currentFlightMode != mode) {
            this.currentFlightMode = mode;
            if (mode == FlightMode.GROUNDED) {
                this.hasCompletedInitialAscent = false;
            }
            this.getNavigation().stop();
        }
    }

    public static enum FlightMode {
        GROUNDED,
        FLYING;

    }
}

