/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.animal.birds.finch;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.zenith.hoyocraft.entity.ModEntities;
import net.zenith.hoyocraft.entity.ai.goal.BirdLandingGoal;
import net.zenith.hoyocraft.entity.ai.goal.FinchMoveControl;
import net.zenith.hoyocraft.entity.custom.animal.birds.BirdEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FinchEntity
extends BirdEntity {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(FinchEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int airborneTimer = 0;
    private static final int FLYING_ANIMATION_DELAY = 20;

    public FinchEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FinchMoveControl(this, 20, true);
    }

    @Override
    public double getConfigurableAscentHeight() {
        return 15.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)Variant.GOLDEN.ordinal());
    }

    public Variant getVariant() {
        return Variant.values()[(Integer)this.entityData.get(DATA_VARIANT_ID)];
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.ordinal());
    }

    public void tick() {
        super.tick();
        this.airborneTimer = !this.onGround() ? ++this.airborneTimer : 0;
    }

    private boolean shouldPlayFlyingAnimation() {
        return !this.onGround() && this.airborneTimer >= 20;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        if (reason != MobSpawnType.BREEDING) {
            this.setVariant(Variant.getRandom(this.random));
        }
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(Items.WHEAT_SEEDS) || pStack.is(Items.MELON_SEEDS) || pStack.is(Items.PUMPKIN_SEEDS) || pStack.is(Items.BEETROOT_SEEDS) || pStack.is(Items.TORCHFLOWER_SEEDS) || pStack.is(Items.PITCHER_POD);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.STEP_HEIGHT, 2.0).add(Attributes.JUMP_STRENGTH, 0.12);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        FinchEntity baby = (FinchEntity)ModEntities.FINCH.get().create((Level)serverLevel);
        if (baby != null && ageableMob instanceof FinchEntity) {
            FinchEntity otherParent = (FinchEntity)ageableMob;
            baby.setVariant(Variant.getRandom(serverLevel.random));
        }
        return baby;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "FinchController", 0, this::predicate));
    }

    private <E extends FinchEntity> PlayState predicate(AnimationState<E> event) {
        FinchEntity finch = (FinchEntity)event.getAnimatable();
        if (finch.getFleeFromAttackerTarget() != null && finch.getFleeFromAttackerTimeRemaining() > 0) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("finch.animation.idle"));
            return PlayState.CONTINUE;
        }
        if (finch.shouldPlayFlyingAnimation()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("finch.animation.flying"));
            return PlayState.CONTINUE;
        }
        if (finch.getCurrentFlightMode() == BirdEntity.FlightMode.GROUNDED && event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("finch.animation.walking"));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().thenLoop("finch.animation.idle"));
        return PlayState.CONTINUE;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new BirdLandingGoal(this, 1.0));
    }

    public static enum Variant {
        GOLDEN,
        SNOW,
        CRIMSON,
        EMERALD;


        public static Variant getRandom(RandomSource random) {
            Variant[] variants = Variant.values();
            return variants[random.nextInt(variants.length)];
        }
    }
}

