/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.AggroReactionGoal;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.CombatAction;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.ElementalEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.AnemoSlimeAttackGoal;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.ISlimeAttackState;
import net.zenith.hoyocraft.network.ModNetworking;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnemoSlimeEntity
extends ElementalEntity
implements GeoEntity,
ISlimeAttackState,
ITauntableGenshinEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isJumpingAttack = false;
    private int currentTauntIndex = 0;
    private boolean attackingGeckoLib = false;
    private boolean leftCircling = false;
    private int ticksAirborne = 0;
    private static final EntityDataAccessor<Boolean> DATA_IS_SLOW_FALLING = SynchedEntityData.defineId(AnemoSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private AnimationController<AnemoSlimeEntity> actionAnimationController;

    @Override
    public boolean isAttackingGeckoLib() {
        return this.attackingGeckoLib;
    }

    public AnemoSlimeEntity(EntityType<? extends AnemoSlimeEntity> entityType, Level level) {
        super((EntityType<? extends ElementalEntity>)entityType, level);
        this.ensureSpecificGoalsRegistered();
    }

    private static CombatAction.CombatActionParameters createAnemoSlimeShortDashParams() {
        String actionNameForLogging = "AnemoSlimeShortDash";
        String animationName = "anemo_slime.animation.shortdash";
        int totalActionDurationTicks = 28;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int upwardMovementStartTime = 2;
        int upwardMovementDuration = 2;
        float upwardSpeed = 0.2f;
        movements.add(CombatAction.MovementSegmentConfig.createContinuousStaticVector(upwardMovementStartTime, upwardMovementDuration, upwardSpeed, new Vec3(0.0, 2.0, 0.0), true));
        int hoverStartTime = upwardMovementStartTime + upwardMovementDuration;
        int hoverDuration = 10;
        float hoverSpeed = 0.0f;
        movements.add(CombatAction.MovementSegmentConfig.createContinuousStaticVector(hoverStartTime, hoverDuration, hoverSpeed, Vec3.ZERO, true));
        int dashStartTime = hoverStartTime + hoverDuration;
        int dashDuration = 2;
        float dashSpeed = 0.9f;
        movements.add(CombatAction.MovementSegmentConfig.createContinuousBallisticToInitialTarget(dashStartTime, dashDuration, dashSpeed, true));
        ArrayList<CombatAction.DamageEventConfig> damageEvents = new ArrayList<CombatAction.DamageEventConfig>();
        damageEvents.add(new CombatAction.DamageEventConfig(20, 4.0f, 2.2f, new Vec3(0.0, 0.0, 1.0), 0.1f, 0.7f, (ParticleOptions)ParticleTypes.GUST, 1, 0.2f, 0.0f, (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.HOSTILE, 2.0f, 1.0f));
        damageEvents.add(new CombatAction.DamageEventConfig(3, 3.0f, 2.5f, new Vec3(0.0, 0.0, 0.5), 0.1f, 0.3f, (ParticleOptions)ParticleTypes.SMALL_GUST, 10, 1.0f, 0.0f, (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.HOSTILE, 1.5f, 1.0f));
        ArrayList<CombatAction.TimedParticleEventConfig> timedParticles = new ArrayList<CombatAction.TimedParticleEventConfig>();
        timedParticles.add(new CombatAction.TimedParticleEventConfig(1, (ParticleOptions)ParticleTypes.SMALL_GUST, 10, new Vec3(0.0, 0.0, 0.0), 0.8, 0.3, 0.8, 0.5));
        timedParticles.add(new CombatAction.TimedParticleEventConfig(14, (ParticleOptions)ParticleTypes.GUST, 1, new Vec3(0.0, 0.0, 0.0), 0.0, 0.0, 0.0, 0.0));
        ArrayList<CombatAction.TimedSoundEventConfig> timedSounds = new ArrayList<CombatAction.TimedSoundEventConfig>();
        timedSounds.add(new CombatAction.TimedSoundEventConfig(1, SoundEvents.PUFFER_FISH_BLOW_UP, SoundSource.HOSTILE, 1.1f, 0.6f));
        timedSounds.add(new CombatAction.TimedSoundEventConfig(14, SoundEvents.BREEZE_SHOOT, SoundSource.HOSTILE, 0.8f, 1.3f));
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damageEvents, timedParticles, timedSounds, continuouslyFaceTarget);
    }

    public static IGenshinAction createActualAnemoSlimeShortDashAction() {
        return new AnemoSlimeShortDashAction(AnemoSlimeEntity.createAnemoSlimeShortDashParams());
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        ArrayList<Supplier<IGenshinAction>> actions = new ArrayList<Supplier<IGenshinAction>>();
        actions.add(AnemoSlimeEntity::createActualAnemoSlimeShortDashAction);
        return actions;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_SLOW_FALLING, (Object)false);
    }

    public boolean isSlowFalling() {
        return (Boolean)this.entityData.get(DATA_IS_SLOW_FALLING);
    }

    public void setSlowFalling(boolean slowFalling) {
        this.entityData.set(DATA_IS_SLOW_FALLING, (Object)slowFalling);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 58.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.STEP_HEIGHT, 64.0);
    }

    private PlayState instantStatePredicate(AnimationState<AnemoSlimeEntity> event) {
        AnemoSlimeEntity entity = (AnemoSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        RawAnimation aggroAnim = RawAnimation.begin().thenPlay("anemo_slime.animation.aggro");
        if (entity.isNeedsAggroReaction()) {
            controller.setAnimation(aggroAnim);
            entity.setNeedsAggroReaction(false);
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController baseController = new AnimationController((GeoAnimatable)this, "base_controller", 5, this::basePredicate);
        controllerRegistrar.add(baseController);
        this.actionAnimationController = new AnimationController((GeoAnimatable)this, "action_controller", 5, this::actionPredicate);
        controllerRegistrar.add(this.actionAnimationController);
        AnimationController instantStateController = new AnimationController((GeoAnimatable)this, "instant_state_controller", 0, this::instantStatePredicate);
        controllerRegistrar.add(instantStateController);
    }

    private PlayState basePredicate(AnimationState<AnemoSlimeEntity> event) {
        AnemoSlimeEntity entity = (AnemoSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        if (entity.isAttackingGeckoLib() || entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        if (entity.isSlowFalling() && !entity.onGround()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("anemo_slime.animation.falling")) {
                controller.setAnimation(RawAnimation.begin().thenLoop("anemo_slime.animation.falling"));
            }
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animation().name().equals("anemo_slime.animation.falling")) {
            controller.setAnimation(null);
        }
        RawAnimation idleAnim = RawAnimation.begin().thenLoop("anemo_slime.animation.idle");
        RawAnimation walkAnim = RawAnimation.begin().thenLoop("anemo_slime.animation.walk");
        if (event.isMoving() && entity.onGround()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("anemo_slime.animation.walk")) {
                controller.setAnimation(walkAnim);
            }
        } else if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("anemo_slime.animation.idle")) {
            controller.setAnimation(idleAnim);
        }
        return PlayState.CONTINUE;
    }

    private PlayState actionPredicate(AnimationState<AnemoSlimeEntity> event) {
        AnemoSlimeEntity entity = (AnemoSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        String currentGlobalActionAnimName = entity.getCurrentActionAnimationName();
        if (controller.getCurrentAnimation() != null) {
            // empty if block
        }
        if (entity.isAttackingGeckoLib() && currentGlobalActionAnimName != null && !currentGlobalActionAnimName.isEmpty()) {
            controller.setAnimation(RawAnimation.begin().thenPlay(currentGlobalActionAnimName));
            return PlayState.CONTINUE;
        }
        if (entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("anemo_slime.animation.hop") || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(RawAnimation.begin().thenPlay("anemo_slime.animation.hop"));
            }
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void registerSpecificGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new AggroReactionGoal<AnemoSlimeEntity>(this, 15));
        this.goalSelector.addGoal(1, this.createAttackGoal());
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    protected Goal createAttackGoal() {
        return new AnemoSlimeAttackGoal(this);
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        return 1.0;
    }

    @Override
    public void setJumpingAttack(boolean jumping) {
        boolean previousState = this.isJumpingAttack;
        if (previousState == jumping && this.level().isClientSide()) {
            return;
        }
        this.isJumpingAttack = jumping;
        if (jumping && this.actionAnimationController != null) {
            if (this.actionAnimationController.getAnimationState() != null) {
                // empty if block
            }
            this.actionAnimationController.forceAnimationReset();
        }
        if (!this.level().isClientSide()) {
            ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack);
        }
    }

    @Override
    public boolean isJumpingAttack() {
        return this.isJumpingAttack;
    }

    @Override
    public void setTauntState(int index) {
        this.currentTauntIndex = index;
    }

    @Override
    public int getTauntState() {
        return this.currentTauntIndex;
    }

    @Override
    public int[] getAvailableTauntStates() {
        return new int[]{1};
    }

    @Override
    public void setAttackingGeckoLib(boolean attacking) {
        if (this.attackingGeckoLib != attacking) {
            this.attackingGeckoLib = attacking;
            if (attacking && this.level().isClientSide() && this.actionAnimationController != null) {
                this.actionAnimationController.forceAnimationReset();
            }
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack());
            }
        }
    }

    @Override
    public void setLeftCircling(boolean leftCircling) {
        this.leftCircling = leftCircling;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.ticksAirborne = this.onGround() ? 0 : ++this.ticksAirborne;
            if (this.random.nextFloat() < 0.1f) {
                double particleX = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
                double particleY = this.getY() + this.random.nextDouble() * (double)this.getBbHeight();
                double particleZ = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void travel(Vec3 pTravelInput) {
        if (!this.level().isClientSide) {
            boolean canStartSlowFall;
            boolean isPerformingActiveManeuver = this.isAttackingGeckoLib() || this.isJumpingAttack();
            boolean bl = canStartSlowFall = !this.onGround() && !this.isInWater() && !this.isInLava() && !this.isVehicle() && !isPerformingActiveManeuver && this.ticksAirborne >= 10;
            if (canStartSlowFall) {
                if (!this.isSlowFalling()) {
                    this.setSlowFalling(true);
                }
            } else if (this.isSlowFalling()) {
                this.setSlowFalling(false);
            }
        }
        if (this.isSlowFalling() && !this.onGround() && !this.isNoGravity()) {
            Vec3 currentDelta = this.getDeltaMovement();
            double newY = currentDelta.y;
            if (newY < 0.0) {
                newY *= 0.5;
            }
            this.setDeltaMovement(currentDelta.x, newY, currentDelta.z);
        }
        super.travel(pTravelInput);
    }

    public void handleEntityEvent(byte pId) {
        super.handleEntityEvent(pId);
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        if (pSource.is(DamageTypes.FALL)) {
            return true;
        }
        return super.isInvulnerableTo(pSource);
    }

    private static class AnemoSlimeShortDashAction
    extends CombatAction {
        public AnemoSlimeShortDashAction(CombatAction.CombatActionParameters params) {
            super(params);
        }

        @Override
        public boolean canPerform(GenshinEntity entity) {
            if (!super.canPerform(entity)) {
                return false;
            }
            boolean isOnSolidGround = entity.onGround();
            boolean isInWater = entity.isInWater();
            return isOnSolidGround || isInWater;
        }
    }
}

