/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.AggroReactionGoal;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.CombatAction;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.ElementalEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.CryoSlimeMoveControl;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.ISlimeAttackState;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.SlimeAttackGoal;
import net.zenith.hoyocraft.network.ModNetworking;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CryoSlimeEntity
extends ElementalEntity
implements GeoEntity,
ISlimeAttackState,
ITauntableGenshinEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isJumpingAttack = false;
    private int currentTauntIndex = 0;
    private boolean attackingGeckoLib = false;
    private boolean leftCircling = false;
    private static final double WATER_SOLIDIFICATION_DISTANCE = 1.1;
    private static final double WATER_SOLIDIFICATION_DISTANCE_SQ = 1.2100000000000002;
    private static final double SLIME_WATER_SURFACE_OFFSET = 0.0;
    private int regenerationCooldown = 0;
    private static final int REGENERATION_INTERVAL = 40;
    private static final float REGENERATION_AMOUNT = 1.0f;
    private AnimationController<CryoSlimeEntity> actionAnimationController;

    @Override
    public boolean isAttackingGeckoLib() {
        return this.attackingGeckoLib;
    }

    public CryoSlimeEntity(EntityType<? extends CryoSlimeEntity> entityType, Level level) {
        super((EntityType<? extends ElementalEntity>)entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.moveControl = new CryoSlimeMoveControl(this, 0.0);
        this.ensureSpecificGoalsRegistered();
    }

    private static CombatAction.CombatActionParameters createCryoSlimeBumpParams() {
        String actionNameForLogging = "CryoSlimeBump";
        String animationName = "cryo_slime.animation.bump";
        int totalActionDurationTicks = 20;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int walkMovementStartTime = 2;
        float desiredEffectiveSpeed = 0.1f;
        float entityBaseSpeed = 0.15f;
        float speedMultiplierForWalk = desiredEffectiveSpeed / entityBaseSpeed;
        int walkMovementDurationTicks = 10;
        movements.add(new CombatAction.MovementSegmentConfig(walkMovementStartTime, walkMovementDurationTicks, CombatAction.MovementType.NAVIGATE_TO_TARGET, speedMultiplierForWalk, true, 0.0f, 0.0f, null));
        ArrayList<CombatAction.DamageEventConfig> damageEvents = new ArrayList<CombatAction.DamageEventConfig>();
        damageEvents.add(new CombatAction.DamageEventConfig(10, 5.0f, 1.6f, new Vec3(0.0, 1.0, 2.4), 0.3f, 0.1f, (ParticleOptions)ParticleTypes.SNOWFLAKE, 15, 0.5f, 0.05f, SoundEvents.PLAYER_HURT_FREEZE, SoundSource.HOSTILE, 0.8f, 1.1f));
        ArrayList timedParticles = new ArrayList();
        ArrayList timedSounds = new ArrayList();
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damageEvents, continuouslyFaceTarget);
    }

    public static IGenshinAction createActualCryoSlimeBumpAction() {
        return new GroundedBumpAction(CryoSlimeEntity.createCryoSlimeBumpParams());
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        ArrayList<Supplier<IGenshinAction>> actions = new ArrayList<Supplier<IGenshinAction>>();
        actions.add(CryoSlimeEntity::createActualCryoSlimeBumpAction);
        return actions;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 58.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.STEP_HEIGHT, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.4);
    }

    private PlayState instantStatePredicate(AnimationState<CryoSlimeEntity> event) {
        CryoSlimeEntity entity = (CryoSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        RawAnimation aggroAnim = RawAnimation.begin().thenPlay("cryo_slime.animation.aggro");
        if (entity.isNeedsAggroReaction()) {
            controller.setAnimation(aggroAnim);
            entity.setNeedsAggroReaction(false);
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController baseController = new AnimationController((GeoAnimatable)this, "base_controller", 5, this::basePredicate);
        controllerRegistrar.add(baseController);
        this.actionAnimationController = new AnimationController((GeoAnimatable)this, "action_controller", 5, this::actionPredicate);
        controllerRegistrar.add(this.actionAnimationController);
        AnimationController instantStateController = new AnimationController((GeoAnimatable)this, "instant_state_controller", 0, this::instantStatePredicate);
        controllerRegistrar.add(instantStateController);
    }

    private PlayState basePredicate(AnimationState<CryoSlimeEntity> event) {
        CryoSlimeEntity entity = (CryoSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        if (entity.isAttackingGeckoLib() || entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        RawAnimation idleAnim = RawAnimation.begin().thenLoop("cryo_slime.animation.idle");
        RawAnimation walkAnim = RawAnimation.begin().thenLoop("cryo_slime.animation.walk");
        if (event.isMoving()) {
            controller.setAnimation(walkAnim);
        } else {
            controller.setAnimation(idleAnim);
        }
        return PlayState.CONTINUE;
    }

    private PlayState actionPredicate(AnimationState<CryoSlimeEntity> event) {
        CryoSlimeEntity entity = (CryoSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        String currentGlobalActionAnimName = entity.getCurrentActionAnimationName();
        if (controller.getCurrentAnimation() != null) {
            // empty if block
        }
        if (entity.isAttackingGeckoLib() && currentGlobalActionAnimName != null && !currentGlobalActionAnimName.isEmpty()) {
            controller.setAnimation(RawAnimation.begin().thenPlay(currentGlobalActionAnimName));
            return PlayState.CONTINUE;
        }
        if (entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("cryo_slime.animation.hop") || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(RawAnimation.begin().thenPlay("cryo_slime.animation.hop"));
            }
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void registerSpecificGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new AggroReactionGoal<CryoSlimeEntity>(this, 15));
        this.goalSelector.addGoal(1, this.createAttackGoal());
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    protected Goal createAttackGoal() {
        return new SlimeAttackGoal<CryoSlimeEntity>(this);
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        return 1.0;
    }

    @Override
    public void setJumpingAttack(boolean jumping) {
        boolean previousState = this.isJumpingAttack;
        if (previousState == jumping && this.level().isClientSide()) {
            return;
        }
        this.isJumpingAttack = jumping;
        if (jumping && this.actionAnimationController != null) {
            if (this.actionAnimationController.getAnimationState() != null) {
                // empty if block
            }
            this.actionAnimationController.forceAnimationReset();
        }
        if (!this.level().isClientSide()) {
            ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack);
        }
    }

    @Override
    public boolean isJumpingAttack() {
        return this.isJumpingAttack;
    }

    @Override
    public void setTauntState(int index) {
        this.currentTauntIndex = index;
    }

    @Override
    public int getTauntState() {
        return this.currentTauntIndex;
    }

    @Override
    public int[] getAvailableTauntStates() {
        return new int[]{1};
    }

    @Override
    public void setAttackingGeckoLib(boolean attacking) {
        if (this.attackingGeckoLib != attacking) {
            this.attackingGeckoLib = attacking;
            if (attacking && this.level().isClientSide() && this.actionAnimationController != null) {
                this.actionAnimationController.forceAnimationReset();
            }
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack());
            }
        }
    }

    @Override
    public void setLeftCircling(boolean leftCircling) {
        this.leftCircling = leftCircling;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            Vec3 entityPos = this.position();
            BlockPos originBlock = this.blockPosition();
            int maxOffset = (int)Math.ceil(1.1) + 1;
            for (int x = -maxOffset; x <= maxOffset; ++x) {
                for (int y = -1; y <= 0; ++y) {
                    for (int z = -maxOffset; z <= maxOffset; ++z) {
                        BlockState targetState;
                        BlockPos targetPos = originBlock.offset(x, y, z);
                        Vec3 targetBlockCenter = Vec3.atCenterOf((Vec3i)targetPos);
                        double distanceSq = entityPos.distanceToSqr(targetBlockCenter);
                        if (!(distanceSq <= 1.2100000000000002) || !(targetState = this.level().getBlockState(targetPos)).is(Blocks.WATER)) continue;
                        this.level().setBlockAndUpdate(targetPos, Blocks.ICE.defaultBlockState());
                        this.level().playSound(null, targetPos, SoundEvents.SNOW_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
                        Level level = this.level();
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5, 10, 0.3, 0.3, 0.3, 0.01);
                    }
                }
            }
        }
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.isAlive() && this.getHealth() < this.getMaxHealth()) {
                boolean shouldRegenerate = false;
                if (this.isInWater()) {
                    shouldRegenerate = true;
                } else if (this.level().isRainingAt(this.blockPosition())) {
                    shouldRegenerate = true;
                }
                if (shouldRegenerate) {
                    if (this.regenerationCooldown > 0) {
                        --this.regenerationCooldown;
                    } else {
                        this.heal(1.0f);
                        this.regenerationCooldown = 40;
                    }
                }
            } else {
                this.regenerationCooldown = 0;
            }
        }
        if (!this.level().isClientSide() && this.random.nextFloat() < 0.1f) {
            double particleX = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double particleY = this.getY() + this.random.nextDouble() * (double)this.getBbHeight();
            double particleZ = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void travel(Vec3 pTravelInput) {
        super.travel(pTravelInput);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canStandOnFluid(FluidState pFluidState) {
        return pFluidState.is(FluidTags.WATER) || super.canStandOnFluid(pFluidState);
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        if (pSource.is(DamageTypes.FREEZE)) {
            return true;
        }
        return super.isInvulnerableTo(pSource);
    }

    private static class GroundedBumpAction
    extends CombatAction {
        public GroundedBumpAction(CombatAction.CombatActionParameters params) {
            super(params);
        }

        @Override
        public boolean canPerform(GenshinEntity entity) {
            if (!super.canPerform(entity)) {
                return false;
            }
            boolean isOnSolidGround = entity.onGround();
            boolean isInWater = entity.isInWater();
            return isOnSolidGround || isInWater;
        }
    }
}

