/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.ai.goal.CustomFirePanicGoal;
import net.zenith.hoyocraft.entity.ai.goal.DendroSlimeUndergroundBehaviorGoal;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.AggroReactionGoal;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.CombatAction;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.ElementalEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.ISlimeAttackState;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.SlimeAttackGoal;
import net.zenith.hoyocraft.network.ModNetworking;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DendroSlimeEntity
extends ElementalEntity
implements GeoEntity,
ISlimeAttackState,
ITauntableGenshinEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isJumpingAttack = false;
    private int currentTauntIndex = 0;
    private boolean attackingGeckoLib = false;
    private boolean leftCircling = false;
    private boolean hasLostUndergroundAI = false;
    private static final EntityDataAccessor<Boolean> DATA_IS_UNDERGROUND = SynchedEntityData.defineId(DendroSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_MOVING_UNDERGROUND = SynchedEntityData.defineId(DendroSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_STARTLED = SynchedEntityData.defineId(DendroSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_BURNT = SynchedEntityData.defineId(DendroSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private AnimationController<DendroSlimeEntity> actionAnimationController;

    public boolean hasLostUndergroundAI() {
        return this.hasLostUndergroundAI;
    }

    public void setHasLostUndergroundAI(boolean lost) {
        boolean oldState = this.hasLostUndergroundAI;
        this.hasLostUndergroundAI = lost;
        if (oldState != lost && !this.level().isClientSide()) {
            System.out.println("[DendroSlime SERVER " + this.getId() + "] hasLostUndergroundAI set to: " + lost);
            if (lost) {
                if (this.isUnderground()) {
                    this.setUnderground(false);
                }
                if (this.isMovingUnderground()) {
                    this.setMovingUnderground(false);
                }
                this.stopCurrentActionAnimation();
            }
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HasLostUndergroundAI", this.hasLostUndergroundAI);
        compound.putBoolean("IsBurnt", ((Boolean)this.entityData.get(DATA_IS_BURNT)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.hasLostUndergroundAI = compound.contains("HasLostUndergroundAI", 1) ? compound.getBoolean("HasLostUndergroundAI") : false;
        this.entityData.set(DATA_IS_BURNT, (Object)compound.getBoolean("IsBurnt"));
        if (this.isBurnt() && !this.hasLostUndergroundAI) {
            System.out.println("[DendroSlime SERVER " + this.getId() + "] Loaded as burnt, ensuring hasLostUndergroundAI is true.");
            this.hasLostUndergroundAI = true;
        }
    }

    public boolean isBurnt() {
        return (Boolean)this.entityData.get(DATA_IS_BURNT);
    }

    public void igniteForTicks(int ticks) {
        boolean wasUndergroundCurrently = this.isUnderground();
        boolean wasNotYetBurnt = !this.isBurnt();
        boolean hadSpecialAIIntact = !this.hasLostUndergroundAI();
        super.igniteForTicks(ticks);
        if (!this.level().isClientSide() && ticks > 0 && wasUndergroundCurrently && wasNotYetBurnt && hadSpecialAIIntact) {
            System.out.println("[DendroSlime SERVER " + this.getId() + "] Was ignited for ticks (ticks=" + ticks + ") while underground with special AI and not previously burnt. Triggering burnt mechanic.");
            this.setBurnt(true);
        }
    }

    public void setBurnt(boolean burnt) {
        if (this.level().isClientSide()) {
            this.entityData.set(DATA_IS_BURNT, (Object)burnt);
            return;
        }
        boolean oldServerBurntState = (Boolean)this.entityData.get(DATA_IS_BURNT);
        if (oldServerBurntState == burnt) {
            return;
        }
        this.entityData.set(DATA_IS_BURNT, (Object)burnt);
        if (burnt) {
            System.out.println("[DendroSlime SERVER " + this.getId() + "] setBurnt: true. Forcing hasLostUndergroundAI to true.");
            if (!this.hasLostUndergroundAI) {
                this.setHasLostUndergroundAI(true);
            }
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_BURN, SoundSource.HOSTILE, 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 20, 0.4, 0.3, 0.4, 0.02);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 5, 0.2, 0.1, 0.2, 0.01);
            }
        }
    }

    @Override
    public boolean isAttackingGeckoLib() {
        return this.attackingGeckoLib;
    }

    public DendroSlimeEntity(EntityType<? extends DendroSlimeEntity> entityType, Level level) {
        super((EntityType<? extends ElementalEntity>)entityType, level);
        this.ensureSpecificGoalsRegistered();
    }

    private static CombatAction.CombatActionParameters createDendroSlimeHitHideParams() {
        String actionNameForLogging = "DendroSlimeHitHide";
        String animationName = "dendro_slime.animation.hithide";
        int totalActionDurationTicks = 20;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        ArrayList<CombatAction.DamageEventConfig> damageEvents = new ArrayList<CombatAction.DamageEventConfig>();
        damageEvents.add(new CombatAction.DamageEventConfig(8, 5.0f, 2.0f, new Vec3(0.0, 0.5, 1.8), 0.1f, 0.2f, (ParticleOptions)ParticleTypes.COMPOSTER, 10, 0.5f, 0.05f, SoundEvents.SLIME_ATTACK, SoundSource.HOSTILE, 0.8f, 1.1f));
        ArrayList<CombatAction.TimedParticleEventConfig> timedParticles = new ArrayList<CombatAction.TimedParticleEventConfig>();
        timedParticles.add(new CombatAction.TimedParticleEventConfig(3, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.DIRT.defaultBlockState()), 30, new Vec3(0.0, 0.0, 0.0), 0.7, 0.2, 0.7, 0.05));
        ArrayList<CombatAction.TimedSoundEventConfig> timedSounds = new ArrayList<CombatAction.TimedSoundEventConfig>();
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damageEvents, timedParticles, timedSounds, continuouslyFaceTarget);
    }

    private static CombatAction.CombatActionParameters createDendroSlimeBumpParams() {
        String actionNameForLogging = "DendroSlimeBump";
        String animationName = "dendro_slime.animation.bump";
        int totalActionDurationTicks = 20;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int walkMovementStartTime = 2;
        float desiredEffectiveSpeed = 0.1f;
        float entityBaseSpeed = 0.15f;
        float speedMultiplierForWalk = desiredEffectiveSpeed / entityBaseSpeed;
        int walkMovementDurationTicks = 10;
        movements.add(new CombatAction.MovementSegmentConfig(walkMovementStartTime, walkMovementDurationTicks, CombatAction.MovementType.NAVIGATE_TO_TARGET, speedMultiplierForWalk, true, 0.0f, 0.0f, null));
        ArrayList<CombatAction.DamageEventConfig> damageEvents = new ArrayList<CombatAction.DamageEventConfig>();
        damageEvents.add(new CombatAction.DamageEventConfig(10, 5.0f, 1.6f, new Vec3(0.0, 1.0, 2.4), 0.3f, 0.1f, (ParticleOptions)ParticleTypes.COMPOSTER, 10, 0.5f, 0.05f, SoundEvents.SLIME_ATTACK, SoundSource.HOSTILE, 0.8f, 1.1f));
        ArrayList timedParticles = new ArrayList();
        ArrayList timedSounds = new ArrayList();
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damageEvents, continuouslyFaceTarget);
    }

    public static IGenshinAction createActualDendroSlimeBumpAction() {
        return new GroundedBumpAction(DendroSlimeEntity.createDendroSlimeBumpParams());
    }

    public static IGenshinAction createActualDendroSlimeHitHideAction() {
        return new CombatAction(DendroSlimeEntity.createDendroSlimeHitHideParams());
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        ArrayList<Supplier<IGenshinAction>> actions = new ArrayList<Supplier<IGenshinAction>>();
        if (this.hasLostUndergroundAI()) {
            System.out.println("[DendroSlime " + this.getId() + "] AI Lost. Offering DENDRO_SLIME_BUMP action for SlimeAttackGoal.");
            actions.add(DendroSlimeEntity::createActualDendroSlimeBumpAction);
        } else {
            actions.add(DendroSlimeEntity::createActualDendroSlimeHitHideAction);
        }
        return actions;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 58.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.STEP_HEIGHT, 2.0);
    }

    private PlayState instantStatePredicate(AnimationState<DendroSlimeEntity> event) {
        DendroSlimeEntity entity = (DendroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        RawAnimation aggroAnim = RawAnimation.begin().thenPlay("dendro_slime.animation.aggro");
        if (entity.isNeedsAggroReaction()) {
            controller.setAnimation(aggroAnim);
            entity.setNeedsAggroReaction(false);
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController baseController = new AnimationController((GeoAnimatable)this, "base_controller", 5, this::basePredicate);
        baseController.setAnimationSpeedHandler(slime -> {
            if (slime.isMovingUnderground()) {
                return 10.0;
            }
            return 1.0;
        });
        controllerRegistrar.add(baseController);
        this.actionAnimationController = new AnimationController((GeoAnimatable)this, "action_controller", 5, this::actionPredicate);
        controllerRegistrar.add(this.actionAnimationController);
        AnimationController instantStateController = new AnimationController((GeoAnimatable)this, "instant_state_controller", 0, this::instantStatePredicate);
        controllerRegistrar.add(instantStateController);
    }

    private PlayState basePredicate(AnimationState<DendroSlimeEntity> event) {
        DendroSlimeEntity entity = (DendroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        if (entity.isAttackingGeckoLib() || entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        if (entity.isUnderground()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("dendro_slime.animation.undergroundidle")) {
                controller.setAnimation(RawAnimation.begin().thenLoop("dendro_slime.animation.undergroundidle"));
            }
            return PlayState.CONTINUE;
        }
        RawAnimation surfaceIdleAnim = RawAnimation.begin().thenLoop("dendro_slime.animation.idle");
        RawAnimation walkAnim = RawAnimation.begin().thenLoop("dendro_slime.animation.walk");
        if (event.isMoving() && entity.onGround()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("dendro_slime.animation.walk")) {
                controller.setAnimation(walkAnim);
            }
        } else if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("dendro_slime.animation.idle")) {
            controller.setAnimation(surfaceIdleAnim);
        }
        return PlayState.CONTINUE;
    }

    private PlayState actionPredicate(AnimationState<DendroSlimeEntity> event) {
        DendroSlimeEntity entity = (DendroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        String currentGlobalActionAnimName = entity.getCurrentActionAnimationName();
        if (entity.isAttackingGeckoLib() && currentGlobalActionAnimName != null && !currentGlobalActionAnimName.isEmpty()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals(currentGlobalActionAnimName) || controller.getAnimationState() == AnimationController.State.STOPPED) {
                if (controller.getAnimationState() == AnimationController.State.STOPPED && controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animation().name().equals(currentGlobalActionAnimName)) {
                    controller.forceAnimationReset();
                }
                controller.setAnimation(RawAnimation.begin().thenPlay(currentGlobalActionAnimName));
            }
            return PlayState.CONTINUE;
        }
        if (entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("dendro_slime.animation.hop") || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(RawAnimation.begin().thenPlay("dendro_slime.animation.hop"));
            }
            return PlayState.CONTINUE;
        }
        if (controller.getAnimationState() != AnimationController.State.STOPPED) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void registerSpecificGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CustomFirePanicGoal(this, 4.0));
        this.goalSelector.addGoal(2, new AggroReactionGoal<DendroSlimeEntity>(this, 15));
        this.goalSelector.addGoal(3, (Goal)new SubmergeGoal(this));
        this.goalSelector.addGoal(4, (Goal)new DendroSlimeUndergroundBehaviorGoal(this));
        this.goalSelector.addGoal(5, this.createAttackGoal());
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    protected Goal createAttackGoal() {
        return new SlimeAttackGoal<DendroSlimeEntity>(this);
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        return 1.0;
    }

    @Override
    public void setJumpingAttack(boolean jumping) {
        boolean previousState = this.isJumpingAttack;
        if (previousState == jumping && this.level().isClientSide()) {
            return;
        }
        this.isJumpingAttack = jumping;
        System.out.println("[DendroSlime " + this.getId() + (this.level().isClientSide ? " CLIENT" : " SERVER") + "] setJumpingAttack: " + jumping);
        if (jumping && this.actionAnimationController != null) {
            System.out.println("[DendroSlime " + this.getId() + (this.level().isClientSide ? " CLIENT" : " SERVER") + "] Forcing animation reset on actionController for hop.");
            this.actionAnimationController.forceAnimationReset();
        }
        if (!this.level().isClientSide()) {
            ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack);
        }
    }

    @Override
    public boolean isJumpingAttack() {
        return this.isJumpingAttack;
    }

    @Override
    public void setTauntState(int index) {
        this.currentTauntIndex = index;
    }

    @Override
    public int getTauntState() {
        return this.currentTauntIndex;
    }

    @Override
    public int[] getAvailableTauntStates() {
        return new int[]{1};
    }

    @Override
    public void setAttackingGeckoLib(boolean attacking) {
        if (this.attackingGeckoLib != attacking) {
            this.attackingGeckoLib = attacking;
            System.out.println("[DendroSlimeEntity " + this.getId() + (this.level().isClientSide() ? " CLIENT" : " SERVER") + "] setAttackingGeckoLib set to: " + attacking + " at tick " + this.tickCount);
            if (attacking && this.level().isClientSide() && this.actionAnimationController != null) {
                this.actionAnimationController.forceAnimationReset();
            }
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack());
            }
        }
    }

    @Override
    public void playAnimation(String animationName) {
        System.out.println("[DendroSlimeEntity " + this.getId() + (this.level().isClientSide() ? " CLIENT" : " SERVER") + "] playAnimation called with: '" + animationName + "'. Tick: " + this.tickCount);
        if (!this.level().isClientSide()) {
            this.entityData.set(DATA_CURRENT_ACTION_ANIMATION_NAME, (Object)(animationName == null ? "" : animationName));
            this.setAttackingGeckoLib(true);
        }
    }

    @Override
    public void stopCurrentActionAnimation() {
        if (!this.level().isClientSide()) {
            String oldAnim = (String)this.entityData.get(DATA_CURRENT_ACTION_ANIMATION_NAME);
            this.entityData.set(DATA_CURRENT_ACTION_ANIMATION_NAME, (Object)"");
            this.setAttackingGeckoLib(false);
            System.out.println("[DendroSlimeEntity SERVER " + this.getId() + "] stopCurrentActionAnimation. Old: '" + oldAnim + "', New: \"\". isAttackingGeckoLib set to false. Tick: " + this.tickCount);
        }
    }

    @Override
    public void setLeftCircling(boolean leftCircling) {
        this.leftCircling = leftCircling;
    }

    @Override
    public void tick() {
        super.tick();
    }

    public void travel(Vec3 pTravelInput) {
        super.travel(pTravelInput);
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        if (this.hasLostUndergroundAI()) {
            if (pSource.is(DamageTypes.FELL_OUT_OF_WORLD) || pSource.is(DamageTypes.GENERIC_KILL)) {
                return super.isInvulnerableTo(pSource);
            }
            return false;
        }
        if (this.isStartled()) {
            return false;
        }
        if (this.isUnderground()) {
            if (pSource.is(DamageTypes.FELL_OUT_OF_WORLD) || pSource.is(DamageTypes.GENERIC_KILL)) {
                return super.isInvulnerableTo(pSource);
            }
            return true;
        }
        return super.isInvulnerableTo(pSource);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_UNDERGROUND, (Object)false);
        builder.define(DATA_IS_MOVING_UNDERGROUND, (Object)false);
        builder.define(DATA_IS_STARTLED, (Object)false);
        builder.define(DATA_IS_BURNT, (Object)Boolean.FALSE);
    }

    public boolean isStartled() {
        return (Boolean)this.entityData.get(DATA_IS_STARTLED);
    }

    public void setStartled(boolean startled) {
        boolean oldState = this.isStartled();
        this.entityData.set(DATA_IS_STARTLED, (Object)startled);
        if (!this.level().isClientSide() && oldState != startled) {
            System.out.println("[DendroSlime SERVER " + this.getId() + "] setStartled changed from " + oldState + " to: " + startled + ". Tick: " + this.tickCount);
            if (startled) {
                if (this.isUnderground()) {
                    System.out.println("[DendroSlime SERVER " + this.getId() + "] Was underground, now surfacing due to startle.");
                    this.setUnderground(false);
                }
                this.playAnimation("dendro_slime.animation.startled");
            } else if ("dendro_slime.animation.startled".equals(this.getCurrentActionAnimationName())) {
                System.out.println("[DendroSlime SERVER " + this.getId() + "] No longer startled, stopping startled animation.");
                this.stopCurrentActionAnimation();
            }
        }
    }

    public boolean isMovingUnderground() {
        return (Boolean)this.entityData.get(DATA_IS_MOVING_UNDERGROUND);
    }

    public void setMovingUnderground(boolean moving) {
        this.entityData.set(DATA_IS_MOVING_UNDERGROUND, (Object)moving);
        if (!this.level().isClientSide()) {
            // empty if block
        }
    }

    public boolean isUnderground() {
        return (Boolean)this.entityData.get(DATA_IS_UNDERGROUND);
    }

    public void setUnderground(boolean underground) {
        boolean oldState = this.isUnderground();
        this.entityData.set(DATA_IS_UNDERGROUND, (Object)underground);
        if (!this.level().isClientSide && oldState != underground) {
            System.out.println("[DendroSlime SERVER " + this.getId() + "] setUnderground: " + underground);
            if (underground) {
                this.getNavigation().stop();
            }
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        boolean initiallyBurnt = this.isBurnt();
        boolean initiallyStartled = this.isStartled();
        boolean initiallyLostAI = this.hasLostUndergroundAI();
        boolean wasCurrentlyUndergroundBeforeHit = this.isUnderground();
        boolean wasActuallyHurt = super.hurt(source, amount);
        if (!this.level().isClientSide()) {
            LivingEntity livingAttacker;
            boolean wasSafeAndPokedByMob;
            Entity attackerEntity = source.getEntity();
            if (wasActuallyHurt && !initiallyBurnt && (source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.LAVA))) {
                System.out.println("[DendroSlime SERVER " + this.getId() + "] Took fire/lava damage. Setting isBurnt to true.");
                this.setBurnt(true);
                return wasActuallyHurt;
            }
            boolean bl = wasSafeAndPokedByMob = wasCurrentlyUndergroundBeforeHit && !initiallyStartled && !initiallyLostAI && attackerEntity instanceof LivingEntity && !((livingAttacker = (LivingEntity)attackerEntity) instanceof Player) && !this.isGenshinFriend(livingAttacker);
            if (wasSafeAndPokedByMob && !this.isBurnt()) {
                System.out.println("[DendroSlime SERVER " + this.getId() + "] HIT ATTEMPT by MOB while safe underground (and not burnt). Forcing startled state. (wasActuallyHurt: " + wasActuallyHurt + ")");
                this.setStartled(true);
                return wasActuallyHurt;
            }
            if (wasActuallyHurt && !initiallyLostAI && !this.isBurnt()) {
                System.out.println("[DendroSlime SERVER " + this.getId() + "] Took other qualifying actual damage (wasActuallyHurt=true), and AI was not initially lost, and not burnt. Forcing hasLostUndergroundAI to true.");
                this.setHasLostUndergroundAI(true);
            }
        }
        return wasActuallyHurt;
    }

    @Override
    public void setTarget(@Nullable LivingEntity newTarget) {
        LivingEntity oldTarget = this.getTarget();
        super.setTarget(newTarget);
        if (!this.level().isClientSide()) {
            if (oldTarget != null && newTarget == null && this.hasLostUndergroundAI() && !this.isBurnt()) {
                this.setHasLostUndergroundAI(false);
            }
            boolean targetsEqual = Objects.equals(oldTarget, newTarget);
            boolean shouldSetNeedsReactionFlag = false;
            if (newTarget != null) {
                if (!targetsEqual) {
                    shouldSetNeedsReactionFlag = true;
                }
            } else if (oldTarget != null) {
                this.setNeedsAggroReaction(false);
                this.setShowAggroIndicator(false);
            }
            if (shouldSetNeedsReactionFlag) {
                this.setNeedsAggroReaction(true);
            }
        }
    }

    private static class GroundedBumpAction
    extends CombatAction {
        public GroundedBumpAction(CombatAction.CombatActionParameters params) {
            super(params);
        }

        @Override
        public boolean canPerform(GenshinEntity entity) {
            if (!super.canPerform(entity)) {
                return false;
            }
            boolean isOnSolidGround = entity.onGround();
            boolean isInWater = entity.isInWater();
            return isOnSolidGround || isInWater;
        }
    }

    private static class SubmergeGoal
    extends Goal {
        private final DendroSlimeEntity slime;
        private int submergingDelay = 0;

        public SubmergeGoal(DendroSlimeEntity slime) {
            this.slime = slime;
        }

        public boolean canUse() {
            LivingEntity target = this.slime.getTarget();
            return target != null && target.isAlive() && !this.slime.isUnderground() && !this.slime.hasLostUndergroundAI() && this.slime.onGround();
        }

        public boolean canContinueToUse() {
            return this.submergingDelay > 0 && !this.slime.isUnderground() && this.slime.getTarget() != null && this.slime.getTarget().isAlive();
        }

        public void start() {
            this.submergingDelay = 2;
        }

        public void tick() {
            --this.submergingDelay;
            if (this.submergingDelay <= 0) {
                this.slime.setUnderground(true);
                if (!this.slime.level().isClientSide()) {
                    this.slime.level().playSound(null, this.slime.blockPosition(), SoundEvents.ROOTED_DIRT_BREAK, SoundSource.HOSTILE, 1.0f, 0.8f);
                }
            }
        }

        public void stop() {
            if (this.slime.isUnderground() || this.submergingDelay > 0) {
                // empty if block
            }
            this.submergingDelay = 0;
        }
    }
}

