/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.AggroReactionGoal;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.CombatAction;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.ElementalEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.ISlimeAttackState;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.SlimeAttackGoal;
import net.zenith.hoyocraft.network.ModNetworking;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ElectroSlimeEntity
extends ElementalEntity
implements GeoEntity,
ISlimeAttackState,
ITauntableGenshinEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isJumpingAttack = false;
    private int currentTauntIndex = 0;
    private boolean attackingGeckoLib = false;
    private boolean leftCircling = false;
    private int lightningAttractionCooldown = 0;
    private static final int LIGHTNING_ATTRACTION_COOLDOWN_MAX = 800;
    private static final float LIGHTNING_ATTRACTION_CHANCE_PER_TICK = 0.005f;
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGED = SynchedEntityData.defineId(ElectroSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean localIsCharged = true;
    private static final byte EVENT_ID_RECHARGED_ANIM = 77;
    private int selfRechargeCooldown = 0;
    private static final int SELF_RECHARGE_INTERVAL = 500;
    private AnimationController<ElectroSlimeEntity> eventAnimationController;
    private int eventAnimationPlayTimeLeft = 0;
    private int clientRechargeEventCooldown = 0;
    private AnimationController<ElectroSlimeEntity> actionAnimationController;

    @Override
    public boolean isAttackingGeckoLib() {
        return this.attackingGeckoLib;
    }

    public ElectroSlimeEntity(EntityType<? extends ElectroSlimeEntity> entityType, Level level) {
        super((EntityType<? extends ElementalEntity>)entityType, level);
        this.ensureSpecificGoalsRegistered();
    }

    private static CombatAction.CombatActionParameters createElectroSlimeShockParams() {
        String actionNameForLogging = "ElectroSlimeShock";
        String animationName = "electro_slime.animation.shock";
        int totalActionDurationTicks = 15;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int walkMovementStartTime = 2;
        float desiredEffectiveSpeed = 0.1f;
        float entityBaseSpeed = 0.15f;
        float speedMultiplierForWalk = desiredEffectiveSpeed / entityBaseSpeed;
        int walkMovementDurationTicks = 5;
        movements.add(new CombatAction.MovementSegmentConfig(walkMovementStartTime, walkMovementDurationTicks, CombatAction.MovementType.NAVIGATE_TO_TARGET, speedMultiplierForWalk, true, 0.0f, 0.0f, null));
        ArrayList<CombatAction.DamageEventConfig> damageEvents = new ArrayList<CombatAction.DamageEventConfig>();
        damageEvents.add(new CombatAction.DamageEventConfig(8, 10.0f, 4.0f, new Vec3(0.0, 1.0, 0.0), 0.1f, 0.2f, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 25, 0.5f, 0.2f, SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.HOSTILE, 0.8f, 1.3f));
        ArrayList<CombatAction.TimedParticleEventConfig> timedParticles = new ArrayList<CombatAction.TimedParticleEventConfig>();
        timedParticles.add(new CombatAction.TimedParticleEventConfig(6, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 40, new Vec3(0.0, 0.7, 0.0), 1.5, 0.5, 1.5, 0.05));
        ArrayList<CombatAction.TimedSoundEventConfig> timedSounds = new ArrayList<CombatAction.TimedSoundEventConfig>();
        timedSounds.add(new CombatAction.TimedSoundEventConfig(6, SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.HOSTILE, 0.8f, 1.3f));
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damageEvents, timedParticles, timedSounds, continuouslyFaceTarget);
    }

    private static CombatAction.CombatActionParameters createElectroSlimeBumpParams() {
        String actionNameForLogging = "ElectroSlimeBump";
        String animationName = "electro_slime.animation.bump";
        int totalActionDurationTicks = 20;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int walkMovementStartTime = 2;
        float desiredEffectiveSpeed = 0.1f;
        float entityBaseSpeed = 0.15f;
        float speedMultiplierForWalk = desiredEffectiveSpeed / entityBaseSpeed;
        int walkMovementDurationTicks = 10;
        movements.add(new CombatAction.MovementSegmentConfig(walkMovementStartTime, walkMovementDurationTicks, CombatAction.MovementType.NAVIGATE_TO_TARGET, speedMultiplierForWalk, true, 0.0f, 0.0f, null));
        ArrayList<CombatAction.DamageEventConfig> damageEvents = new ArrayList<CombatAction.DamageEventConfig>();
        damageEvents.add(new CombatAction.DamageEventConfig(10, 5.0f, 1.6f, new Vec3(0.0, 1.0, 2.4), 0.3f, 0.1f, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 25, 0.5f, 0.1f, SoundEvents.MAGMA_CUBE_HURT, SoundSource.HOSTILE, 0.8f, 1.1f));
        ArrayList timedParticles = new ArrayList();
        ArrayList timedSounds = new ArrayList();
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damageEvents, continuouslyFaceTarget);
    }

    public static IGenshinAction createActualElectroSlimeBumpAction() {
        return new GroundedBumpAction(ElectroSlimeEntity.createElectroSlimeBumpParams());
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        ArrayList<Supplier<IGenshinAction>> actions = new ArrayList<Supplier<IGenshinAction>>();
        actions.add(ElectroSlimeEntity::createActualElectroSlimeBumpAction);
        actions.add(ElectroSlimeEntity::createActualElectroSlimeShockAction);
        return actions;
    }

    public static IGenshinAction createActualElectroSlimeShockAction() {
        return new ElectroShockAction(ElectroSlimeEntity.createElectroSlimeShockParams());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 58.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.STEP_HEIGHT, 2.0);
    }

    private PlayState instantStatePredicate(AnimationState<ElectroSlimeEntity> event) {
        ElectroSlimeEntity entity = (ElectroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        RawAnimation aggroAnim = RawAnimation.begin().thenPlay("electro_slime.animation.aggro");
        if (entity.isNeedsAggroReaction()) {
            controller.setAnimation(aggroAnim);
            entity.setNeedsAggroReaction(false);
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController baseController = new AnimationController((GeoAnimatable)this, "base_controller", 5, this::basePredicate);
        controllerRegistrar.add(baseController);
        this.actionAnimationController = new AnimationController((GeoAnimatable)this, "action_controller", 5, this::actionPredicate);
        controllerRegistrar.add(this.actionAnimationController);
        AnimationController instantStateController = new AnimationController((GeoAnimatable)this, "instant_state_controller", 0, this::instantStatePredicate);
        controllerRegistrar.add(instantStateController);
        this.eventAnimationController = new AnimationController((GeoAnimatable)this, "event_controller", 0, event -> {
            if (this.eventAnimationPlayTimeLeft > 0) {
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        });
        controllerRegistrar.add(this.eventAnimationController);
    }

    private PlayState basePredicate(AnimationState<ElectroSlimeEntity> event) {
        ElectroSlimeEntity entity = (ElectroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        if (this.eventAnimationController != null && this.eventAnimationController.getAnimationState() != AnimationController.State.STOPPED) {
            System.out.println("[ElectroSlime CLIENT basePredicate " + this.getId() + "] Yielding to event_controller. EventCtrlState: " + String.valueOf(this.eventAnimationController.getAnimationState()) + ", EventCtrlAnim: " + (this.eventAnimationController.getCurrentAnimation() != null ? this.eventAnimationController.getCurrentAnimation().animation().name() : "none"));
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        if (entity.isAttackingGeckoLib() || entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        RawAnimation idleAnim = RawAnimation.begin().thenLoop("electro_slime.animation.idle");
        RawAnimation walkAnim = RawAnimation.begin().thenLoop("electro_slime.animation.walk");
        if (event.isMoving()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("electro_slime.animation.walk")) {
                controller.setAnimation(walkAnim);
            }
        } else if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("electro_slime.animation.idle")) {
            controller.setAnimation(idleAnim);
        }
        return PlayState.CONTINUE;
    }

    private PlayState actionPredicate(AnimationState<ElectroSlimeEntity> event) {
        ElectroSlimeEntity entity = (ElectroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        String currentGlobalActionAnimName = entity.getCurrentActionAnimationName();
        if (this.eventAnimationController != null && this.eventAnimationController.getAnimationState() != AnimationController.State.STOPPED) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        if (entity.isAttackingGeckoLib() && currentGlobalActionAnimName != null && !currentGlobalActionAnimName.isEmpty()) {
            controller.setAnimation(RawAnimation.begin().thenPlay(currentGlobalActionAnimName));
            return PlayState.CONTINUE;
        }
        if (entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("electro_slime.animation.hop") || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(RawAnimation.begin().thenPlay("electro_slime.animation.hop"));
            }
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void registerSpecificGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new AggroReactionGoal<ElectroSlimeEntity>(this, 15));
        this.goalSelector.addGoal(1, this.createAttackGoal());
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    protected Goal createAttackGoal() {
        return new SlimeAttackGoal<ElectroSlimeEntity>(this);
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        return 1.0;
    }

    @Override
    public void setJumpingAttack(boolean jumping) {
        boolean previousState = this.isJumpingAttack;
        if (previousState == jumping && this.level().isClientSide()) {
            return;
        }
        this.isJumpingAttack = jumping;
        if (jumping && this.actionAnimationController != null) {
            if (this.actionAnimationController.getAnimationState() != null) {
                // empty if block
            }
            this.actionAnimationController.forceAnimationReset();
        }
        if (!this.level().isClientSide()) {
            ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack);
        }
    }

    @Override
    public boolean isJumpingAttack() {
        return this.isJumpingAttack;
    }

    @Override
    public void setTauntState(int index) {
        this.currentTauntIndex = index;
    }

    @Override
    public int getTauntState() {
        return this.currentTauntIndex;
    }

    @Override
    public int[] getAvailableTauntStates() {
        return new int[]{1};
    }

    @Override
    public void setAttackingGeckoLib(boolean attacking) {
        if (this.attackingGeckoLib != attacking) {
            this.attackingGeckoLib = attacking;
            if (attacking && this.level().isClientSide() && this.actionAnimationController != null) {
                this.actionAnimationController.forceAnimationReset();
            }
            if (!this.level().isClientSide()) {
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack());
            }
        }
    }

    @Override
    public void setLeftCircling(boolean leftCircling) {
        this.leftCircling = leftCircling;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.clientRechargeEventCooldown > 0) {
                --this.clientRechargeEventCooldown;
            }
            if (this.eventAnimationPlayTimeLeft > 0) {
                --this.eventAnimationPlayTimeLeft;
                if (this.eventAnimationPlayTimeLeft == 0) {
                    System.out.println("[ElectroSlime CLIENT " + this.getId() + "] eventAnimationPlayTimeLeft reached 0. Controller predicate will now cause STOP.");
                }
            }
        }
        if (!this.level().isClientSide && this.isAlive()) {
            LightningBolt lightning;
            ServerLevel serverLevel = (ServerLevel)this.level();
            if (!this.isCharged()) {
                if (this.selfRechargeCooldown > 0) {
                    --this.selfRechargeCooldown;
                }
                if (this.selfRechargeCooldown <= 0) {
                    this.setCharged(true);
                }
            }
            if (this.lightningAttractionCooldown > 0) {
                --this.lightningAttractionCooldown;
            }
            if (serverLevel.isThundering() && serverLevel.canSeeSky(this.blockPosition().above()) && this.lightningAttractionCooldown <= 0 && this.random.nextFloat() < 0.005f && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel)) != null) {
                lightning.moveTo(this.getX(), this.getY(), this.getZ());
                lightning.setVisualOnly(false);
                serverLevel.addFreshEntity((Entity)lightning);
                this.lightningAttractionCooldown = 800;
            }
        }
        if (!this.level().isClientSide() && this.random.nextFloat() < 0.1f) {
            double particleX = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double particleY = this.getY() + this.random.nextDouble() * (double)this.getBbHeight();
            double particleZ = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        if (pSource.is(DamageTypes.LIGHTNING_BOLT) || pSource.is(DamageTypes.IN_FIRE)) {
            return true;
        }
        return super.isInvulnerableTo(pSource);
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
        float healAmount = this.getMaxHealth() * 0.25f;
        this.heal(healAmount);
        boolean wasChargedBeforeHit = this.isCharged();
        this.setCharged(true);
        if (!wasChargedBeforeHit) {
            pLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ(), 30, 0.6, 0.6, 0.6, 0.15);
            pLevel.playSound(null, this.blockPosition(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.HOSTILE, 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 77) {
            if (this.level().isClientSide && this.clientRechargeEventCooldown > 0) {
                System.out.println("[ElectroSlime CLIENT " + this.getId() + "] Received EVENT_ID_RECHARGED_ANIM but clientRechargeEventCooldown is active (" + this.clientRechargeEventCooldown + "). Skipping.");
                return;
            }
            System.out.println("[ElectroSlime CLIENT " + this.getId() + "] Processing EVENT_ID_RECHARGED_ANIM. eventAnimationController state BEFORE: " + String.valueOf(this.eventAnimationController != null ? this.eventAnimationController.getAnimationState() : "NULL"));
            if (this.level().isClientSide && this.eventAnimationController != null) {
                this.clientRechargeEventCooldown = 2;
                this.eventAnimationController.forceAnimationReset();
                System.out.println("[ElectroSlime CLIENT " + this.getId() + "] State AFTER forceAnimationReset(): " + String.valueOf(this.eventAnimationController.getAnimationState()));
                System.out.println("[ElectroSlime CLIENT " + this.getId() + "] Attempting to SET recharge animation.");
                this.eventAnimationController.setAnimation(RawAnimation.begin().thenPlay("electro_slime.animation.recharge"));
                this.eventAnimationPlayTimeLeft = 25;
                System.out.println("[ElectroSlime CLIENT " + this.getId() + "] Set eventAnimationPlayTimeLeft to " + this.eventAnimationPlayTimeLeft);
                System.out.println("[ElectroSlime CLIENT " + this.getId() + "] State IMMEDIATELY AFTER setAnimation: " + String.valueOf(this.eventAnimationController.getAnimationState()) + ", Current Anim: " + (this.eventAnimationController.getCurrentAnimation() != null ? this.eventAnimationController.getCurrentAnimation().animation().name() : "none_in_queue") + ", CurrentRawAnim: " + (this.eventAnimationController.getCurrentRawAnimation() != null ? ((RawAnimation.Stage)this.eventAnimationController.getCurrentRawAnimation().getAnimationStages().get(0)).animationName() : "null_raw"));
            } else if (this.eventAnimationController == null && this.level().isClientSide) {
                System.out.println("[ElectroSlime CLIENT " + this.getId() + "] ERROR: eventAnimationController is NULL for EVENT_ID_RECHARGED_ANIM.");
            }
        } else {
            super.handleEntityEvent(pId);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHARGED, (Object)true);
    }

    public boolean isCharged() {
        if (this.level().isClientSide()) {
            return (Boolean)this.entityData.get(DATA_IS_CHARGED);
        }
        return this.localIsCharged;
    }

    public void setCharged(boolean charged) {
        if (!this.level().isClientSide()) {
            boolean previouslyCharged = this.localIsCharged;
            this.localIsCharged = charged;
            this.entityData.set(DATA_IS_CHARGED, (Object)charged);
            if (charged) {
                this.selfRechargeCooldown = 0;
                if (charged && !previouslyCharged) {
                    System.out.println("[ElectroSlime SERVER " + this.getId() + "] Broadcasting EVENT_ID_RECHARGED_ANIM (77).");
                    this.level().broadcastEntityEvent((Entity)this, (byte)77);
                }
            } else if (previouslyCharged) {
                this.selfRechargeCooldown = 500;
            }
        }
    }

    public boolean fireImmune() {
        return true;
    }

    @Override
    protected float getModifiedDamage(float baseDamage, CombatAction.DamageEventConfig damageConfig) {
        if (!this.isCharged()) {
            return baseDamage * 0.8f;
        }
        return baseDamage;
    }

    private static class GroundedBumpAction
    extends CombatAction {
        public GroundedBumpAction(CombatAction.CombatActionParameters params) {
            super(params);
        }

        @Override
        public boolean canPerform(GenshinEntity entity) {
            if (!super.canPerform(entity)) {
                return false;
            }
            boolean isOnSolidGround = entity.onGround();
            return isOnSolidGround;
        }
    }

    private static class ElectroShockAction
    extends CombatAction {
        public ElectroShockAction(CombatAction.CombatActionParameters params) {
            super(params);
        }

        @Override
        public boolean canPerform(GenshinEntity entity) {
            if (!super.canPerform(entity)) {
                return false;
            }
            if (entity instanceof ElectroSlimeEntity) {
                ElectroSlimeEntity electroSlime = (ElectroSlimeEntity)entity;
                return electroSlime.isCharged();
            }
            return false;
        }

        @Override
        public void perform(GenshinEntity entity, LivingEntity target) {
            ElectroSlimeEntity electroSlime;
            super.perform(entity, target);
            if (!this.getDealtDamageEventsInThisExecution().isEmpty() && entity instanceof ElectroSlimeEntity && (electroSlime = (ElectroSlimeEntity)entity).isCharged()) {
                electroSlime.setCharged(false);
            }
        }
    }
}

