/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.AggroReactionGoal;
import net.zenith.hoyocraft.entity.core.combat.ITauntableGenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.actions.CombatAction;
import net.zenith.hoyocraft.entity.core.combat.actions.IGenshinAction;
import net.zenith.hoyocraft.entity.core.types.ElementalEntity;
import net.zenith.hoyocraft.entity.custom.elemental.slime.HydroSlimeMoveControl;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.ISlimeAttackState;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.SlimeAttackGoal;
import net.zenith.hoyocraft.network.ModNetworking;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HydroSlimeEntity
extends ElementalEntity
implements GeoEntity,
ISlimeAttackState,
ITauntableGenshinEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isJumpingAttack = false;
    private int currentTauntIndex = 0;
    private boolean attackingGeckoLib = false;
    private boolean leftCircling = false;
    private static final double LAVA_SOLIDIFICATION_DISTANCE = 1.1;
    private static final double LAVA_SOLIDIFICATION_DISTANCE_SQ = 1.2100000000000002;
    private static final double SLIME_WATER_SURFACE_OFFSET = 0.0;
    private int regenerationCooldown = 0;
    private static final int REGENERATION_INTERVAL = 40;
    private static final float REGENERATION_AMOUNT = 1.0f;
    private AnimationController<HydroSlimeEntity> actionAnimationController;

    @Override
    public boolean isAttackingGeckoLib() {
        return this.attackingGeckoLib;
    }

    public HydroSlimeEntity(EntityType<? extends HydroSlimeEntity> entityType, Level level) {
        super((EntityType<? extends ElementalEntity>)entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.moveControl = new HydroSlimeMoveControl(this, 0.0);
        this.ensureSpecificGoalsRegistered();
    }

    private static CombatAction.CombatActionParameters createHydroSlimeBumpParams() {
        String actionNameForLogging = "HydroSlimeBump";
        String animationName = "hydro_slime.animation.bump";
        int totalActionDurationTicks = 20;
        ArrayList<CombatAction.MovementSegmentConfig> movements = new ArrayList<CombatAction.MovementSegmentConfig>();
        int walkMovementStartTime = 2;
        float desiredEffectiveSpeed = 0.1f;
        float entityBaseSpeed = 0.15f;
        float speedMultiplierForWalk = desiredEffectiveSpeed / entityBaseSpeed;
        int walkMovementDurationTicks = 10;
        movements.add(new CombatAction.MovementSegmentConfig(walkMovementStartTime, walkMovementDurationTicks, CombatAction.MovementType.NAVIGATE_TO_TARGET, speedMultiplierForWalk, true, 0.0f, 0.0f, null));
        ArrayList<CombatAction.DamageEventConfig> damageEvents = new ArrayList<CombatAction.DamageEventConfig>();
        damageEvents.add(new CombatAction.DamageEventConfig(10, 5.0f, 1.6f, new Vec3(0.0, 1.0, 2.4), 0.3f, 0.1f, (ParticleOptions)ParticleTypes.SPLASH, 15, 0.5f, 0.05f, SoundEvents.PLAYER_SPLASH_HIGH_SPEED, SoundSource.HOSTILE, 0.8f, 1.1f));
        ArrayList timedParticles = new ArrayList();
        ArrayList timedSounds = new ArrayList();
        boolean continuouslyFaceTarget = true;
        return new CombatAction.CombatActionParameters(actionNameForLogging, animationName, totalActionDurationTicks, movements, damageEvents, continuouslyFaceTarget);
    }

    public static IGenshinAction createActualHydroSlimeBumpAction() {
        return new GroundedBumpAction(HydroSlimeEntity.createHydroSlimeBumpParams());
    }

    @Override
    public List<Supplier<IGenshinAction>> getAvailableCombatActions() {
        ArrayList<Supplier<IGenshinAction>> actions = new ArrayList<Supplier<IGenshinAction>>();
        actions.add(HydroSlimeEntity::createActualHydroSlimeBumpAction);
        return actions;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 58.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.STEP_HEIGHT, 2.0);
    }

    private PlayState instantStatePredicate(AnimationState<HydroSlimeEntity> event) {
        HydroSlimeEntity entity = (HydroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        RawAnimation aggroAnim = RawAnimation.begin().thenPlay("hydro_slime.animation.aggro");
        if (entity.isNeedsAggroReaction()) {
            controller.setAnimation(aggroAnim);
            entity.setNeedsAggroReaction(false);
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController baseController = new AnimationController((GeoAnimatable)this, "base_controller", 5, this::basePredicate);
        controllerRegistrar.add(baseController);
        this.actionAnimationController = new AnimationController((GeoAnimatable)this, "action_controller", 5, this::actionPredicate);
        controllerRegistrar.add(this.actionAnimationController);
        AnimationController instantStateController = new AnimationController((GeoAnimatable)this, "instant_state_controller", 0, this::instantStatePredicate);
        controllerRegistrar.add(instantStateController);
    }

    private PlayState basePredicate(AnimationState<HydroSlimeEntity> event) {
        HydroSlimeEntity entity = (HydroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        if (entity.isAttackingGeckoLib() || entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() != null) {
                controller.setAnimation(null);
            }
            return PlayState.CONTINUE;
        }
        RawAnimation idleAnim = RawAnimation.begin().thenLoop("hydro_slime.animation.idle");
        RawAnimation walkAnim = RawAnimation.begin().thenLoop("hydro_slime.animation.walk");
        if (event.isMoving()) {
            controller.setAnimation(walkAnim);
        } else {
            controller.setAnimation(idleAnim);
        }
        return PlayState.CONTINUE;
    }

    private PlayState actionPredicate(AnimationState<HydroSlimeEntity> event) {
        HydroSlimeEntity entity = (HydroSlimeEntity)event.getAnimatable();
        AnimationController controller = event.getController();
        String currentGlobalActionAnimName = entity.getCurrentActionAnimationName();
        if (controller.getCurrentAnimation() != null) {
            // empty if block
        }
        if (entity.isAttackingGeckoLib() && currentGlobalActionAnimName != null && !currentGlobalActionAnimName.isEmpty()) {
            controller.setAnimation(RawAnimation.begin().thenPlay(currentGlobalActionAnimName));
            return PlayState.CONTINUE;
        }
        if (entity.isJumpingAttack()) {
            if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals("hydro_slime.animation.hop") || controller.getAnimationState() == AnimationController.State.STOPPED) {
                controller.setAnimation(RawAnimation.begin().thenPlay("hydro_slime.animation.hop"));
            }
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null) {
            controller.setAnimation(null);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void registerSpecificGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new AggroReactionGoal<HydroSlimeEntity>(this, 15));
        this.goalSelector.addGoal(1, this.createAttackGoal());
        this.goalSelector.addGoal(5, (Goal)new HydroSlimeWaterWanderGoal(this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    protected Goal createAttackGoal() {
        return new SlimeAttackGoal<HydroSlimeEntity>(this);
    }

    @Override
    public double getNavigationSpeedMultiplier() {
        return 1.0;
    }

    @Override
    public void setJumpingAttack(boolean jumping) {
        boolean previousState = this.isJumpingAttack;
        if (previousState == jumping && this.level().isClientSide()) {
            return;
        }
        this.isJumpingAttack = jumping;
        if (jumping && this.actionAnimationController != null) {
            if (this.actionAnimationController.getAnimationState() != null) {
                System.out.println("[HydroSlimeEntity CLIENT " + this.getId() + "] State of actionAnimationController before reset: " + this.actionAnimationController.getAnimationState().toString());
            } else {
                System.out.println("[HydroSlimeEntity CLIENT " + this.getId() + "] actionAnimationController state is NULL before reset attempt.");
            }
            this.actionAnimationController.forceAnimationReset();
        }
        if (this.level().isClientSide()) {
            System.out.println("[HydroSlimeEntity CLIENT] setJumpingAttack(" + jumping + "). Old: " + previousState + ", New: " + this.isJumpingAttack + ", EntityID: " + this.getId());
        } else {
            System.out.println("[HydroSlimeEntity SERVER] setJumpingAttack(" + jumping + "). Old: " + previousState + ", New: " + this.isJumpingAttack + ", EntityID: " + this.getId());
            ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack);
        }
    }

    @Override
    public boolean isJumpingAttack() {
        return this.isJumpingAttack;
    }

    @Override
    public void setTauntState(int index) {
        this.currentTauntIndex = index;
    }

    @Override
    public int getTauntState() {
        return this.currentTauntIndex;
    }

    @Override
    public int[] getAvailableTauntStates() {
        return new int[]{1};
    }

    @Override
    public void setAttackingGeckoLib(boolean attacking) {
        if (this.attackingGeckoLib != attacking) {
            this.attackingGeckoLib = attacking;
            if (attacking && this.level().isClientSide()) {
                if (this.actionAnimationController != null) {
                    System.out.println("[HydroSlimeEntity CLIENT " + this.getId() + "] Forcing animation reset on this.actionAnimationController due to setAttackingGeckoLib(true)");
                    this.actionAnimationController.forceAnimationReset();
                } else {
                    System.out.println("[HydroSlimeEntity CLIENT " + this.getId() + "] this.actionAnimationController is null, cannot reset for attacking=true.");
                }
            }
            if (!this.level().isClientSide()) {
                System.out.println("[HydroSlimeEntity SERVER " + this.getId() + "] Syncing attackingGeckoLib state: " + this.attackingGeckoLib);
                ModNetworking.sendEntityStateSync((Entity)this, this.currentTauntIndex, false, this.attackingGeckoLib, this.leftCircling, this.isJumpingAttack());
            }
        }
    }

    @Override
    public void setLeftCircling(boolean leftCircling) {
        this.leftCircling = leftCircling;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            Vec3 entityPos = this.position();
            BlockPos originBlock = this.blockPosition();
            int maxOffset = (int)Math.ceil(1.1) + 1;
            for (int x = -maxOffset; x <= maxOffset; ++x) {
                for (int y = -1; y <= 0; ++y) {
                    for (int z = -maxOffset; z <= maxOffset; ++z) {
                        BlockState targetState;
                        BlockPos targetPos = originBlock.offset(x, y, z);
                        Vec3 targetBlockCenter = Vec3.atCenterOf((Vec3i)targetPos);
                        double distanceSq = entityPos.distanceToSqr(targetBlockCenter);
                        if (!(distanceSq <= 1.2100000000000002) || !(targetState = this.level().getBlockState(targetPos)).is(Blocks.LAVA)) continue;
                        this.level().setBlockAndUpdate(targetPos, Blocks.OBSIDIAN.defaultBlockState());
                        this.level().levelEvent(1501, targetPos, 0);
                    }
                }
            }
        }
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.isAlive() && this.getHealth() < this.getMaxHealth()) {
                boolean shouldRegenerate = false;
                if (this.isInWater()) {
                    shouldRegenerate = true;
                } else if (this.level().isRainingAt(this.blockPosition())) {
                    shouldRegenerate = true;
                }
                if (shouldRegenerate) {
                    if (this.regenerationCooldown > 0) {
                        --this.regenerationCooldown;
                    } else {
                        this.heal(1.0f);
                        this.regenerationCooldown = 40;
                    }
                }
            } else {
                this.regenerationCooldown = 0;
            }
        }
        if (!this.level().isClientSide() && this.random.nextFloat() < 0.1f) {
            double particleX = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double particleY = this.getY() + this.random.nextDouble() * (double)this.getBbHeight();
            double particleZ = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.RAIN, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void travel(Vec3 pTravelInput) {
        super.travel(pTravelInput);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canStandOnFluid(FluidState pFluidState) {
        return pFluidState.is(FluidTags.WATER) || super.canStandOnFluid(pFluidState);
    }

    public float getSpeed() {
        float baseSpeed = super.getSpeed();
        if (this.isInWater() || this.isStandingOnWater()) {
            return baseSpeed * 1.8f;
        }
        return baseSpeed;
    }

    private boolean isStandingOnWater() {
        return this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER);
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        if (pSource.is(DamageTypes.DROWN)) {
            return true;
        }
        return super.isInvulnerableTo(pSource);
    }

    private static class GroundedBumpAction
    extends CombatAction {
        public GroundedBumpAction(CombatAction.CombatActionParameters params) {
            super(params);
        }

        @Override
        public boolean canPerform(GenshinEntity entity) {
            if (!super.canPerform(entity)) {
                return false;
            }
            boolean isOnSolidGround = entity.onGround();
            boolean isInWater = entity.isInWater();
            return isOnSolidGround || isInWater;
        }
    }

    private static class HydroSlimeWaterWanderGoal
    extends Goal {
        private final HydroSlimeEntity slime;
        private final double speedModifier;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private int cooldownTicks = 0;
        private static final int WANDER_COOLDOWN = 60;

        public HydroSlimeWaterWanderGoal(HydroSlimeEntity slime, double speedModifier) {
            this.slime = slime;
            this.speedModifier = speedModifier;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.slime.getTarget() != null) {
                return false;
            }
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                return false;
            }
            Vec3 wanderPos = this.findWanderPosition();
            if (wanderPos != null) {
                this.wantedX = wanderPos.x;
                this.wantedY = wanderPos.y;
                this.wantedZ = wanderPos.z;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return !this.slime.getNavigation().isDone() && this.slime.getTarget() == null;
        }

        public void start() {
            double actualSpeedModifier = this.speedModifier;
            if (this.slime.isInWater() || this.slime.isStandingOnWater()) {
                actualSpeedModifier = this.speedModifier * 1.8;
            }
            this.slime.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, actualSpeedModifier);
        }

        public void stop() {
            this.cooldownTicks = 60 + this.slime.getRandom().nextInt(60);
            this.slime.getNavigation().stop();
        }

        private Vec3 findWanderPosition() {
            for (int attempts = 0; attempts < 10; ++attempts) {
                double range = 8.0;
                double randomX = this.slime.getX() + (this.slime.getRandom().nextDouble() - 0.5) * range * 2.0;
                double randomZ = this.slime.getZ() + (this.slime.getRandom().nextDouble() - 0.5) * range * 2.0;
                BlockPos targetPos = new BlockPos((int)randomX, (int)this.slime.getY(), (int)randomZ);
                if (!this.isValidWanderPosition(targetPos)) continue;
                return new Vec3(randomX, (double)targetPos.getY() + 1.0, randomZ);
            }
            return null;
        }

        private boolean isValidWanderPosition(BlockPos pos) {
            Level level = this.slime.level();
            for (int yOffset = -2; yOffset <= 2; ++yOffset) {
                BlockPos checkPos = pos.offset(0, yOffset, 0);
                BlockState blockState = level.getBlockState(checkPos);
                BlockState aboveState = level.getBlockState(checkPos.above());
                if ((!blockState.is(Blocks.WATER) || !aboveState.isAir() && !aboveState.is(Blocks.WATER)) && (!blockState.isSolid() || !aboveState.isAir()) || this.slime.getNavigation().createPath((double)checkPos.getX() + 0.5, (double)checkPos.getY() + 1.0, (double)checkPos.getZ() + 0.5, 0) == null) continue;
                return true;
            }
            return false;
        }
    }
}

