/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.custom.elemental.slime.HydroSlimeEntity;

public class HydroSlimeMoveControl
extends MoveControl {
    private final HydroSlimeEntity slime;
    private final double waterSurfaceOffset;
    private static final double WATER_SPEED_MULTIPLIER = 3.8;

    public HydroSlimeMoveControl(HydroSlimeEntity slime, double waterSurfaceOffset) {
        super((Mob)slime);
        this.slime = slime;
        this.waterSurfaceOffset = waterSurfaceOffset;
    }

    public void tick() {
        if (this.mob.isInWater()) {
            super.tick();
            Vec3 originalDelta = this.mob.getDeltaMovement();
            double boostedX = originalDelta.x;
            double boostedZ = originalDelta.z;
            double currentY = this.mob.getY();
            double waterSurfaceY = (double)this.mob.blockPosition().getY() + 1.0;
            double targetY = waterSurfaceY + this.waterSurfaceOffset;
            double verticalDifference = targetY - currentY;
            double velocityY = Math.abs(verticalDifference) > 0.2 ? (verticalDifference > 0.0 ? 0.1 : -0.1) : verticalDifference * 0.2;
            this.mob.setDeltaMovement(new Vec3(boostedX, velocityY, boostedZ));
            LivingEntity target = this.mob.getTarget();
            if (target != null) {
                this.mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ(), 30.0f, 30.0f);
            }
        } else {
            super.tick();
        }
    }
}

