/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.custom.elemental.slime.PyroSlimeEntity;

public class PyroSlimeMoveControl
extends MoveControl {
    private final PyroSlimeEntity slime;
    private final double lavaSurfaceOffset;

    public PyroSlimeMoveControl(PyroSlimeEntity slime, double lavaSurfaceOffset) {
        super((Mob)slime);
        this.slime = slime;
        this.lavaSurfaceOffset = lavaSurfaceOffset;
    }

    public void tick() {
        if (this.mob.isInLava()) {
            super.tick();
            Vec3 originalDelta = this.mob.getDeltaMovement();
            double currentY = this.mob.getY();
            double lavaSurfaceY = (double)this.mob.blockPosition().getY() + 1.0;
            double targetY = lavaSurfaceY + this.lavaSurfaceOffset;
            double verticalDifference = targetY - currentY;
            double velocityY = Math.abs(verticalDifference) > 0.2 ? (verticalDifference > 0.0 ? 0.1 : -0.1) : verticalDifference * 0.2;
            this.mob.setDeltaMovement(new Vec3(originalDelta.x, velocityY, originalDelta.z));
            LivingEntity target = this.mob.getTarget();
            if (target != null) {
                this.mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ(), 30.0f, 30.0f);
            }
        } else {
            super.tick();
        }
    }
}

