/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.custom.elemental.slime.attacks;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.combat.GenshinAttackGoal;
import net.zenith.hoyocraft.entity.custom.elemental.slime.attacks.ISlimeAttackState;

public class SlimeAttackGoal<T extends GenshinEntity>
extends GenshinAttackGoal {
    private int hopTimer = 0;
    private int jumpAnimationTimer = 0;
    private Vec3 currentHopDirection = null;
    private boolean hopPhysicsAppliedThisCycle = false;
    private boolean currentHopIsBackoff = false;
    private int prepPhaseTimer = 0;
    private static final int HOP_ANIM_SYNC_DELAY_TICKS = 3;
    private static final float LOOK_YAW_SPEED = 30.0f;
    private static final float LOOK_PITCH_SPEED = 30.0f;
    private static final int POST_BACKOFF_HOP_COOLDOWN_TICKS = 5;

    public SlimeAttackGoal(T entity) {
        super((GenshinEntity)((Object)entity));
    }

    private ISlimeAttackState getSlimeState() {
        return (ISlimeAttackState)((Object)this.entity);
    }

    private Mob getSlimeMob() {
        return this.entity;
    }

    protected int getTicksBetweenHops() {
        return 10;
    }

    protected int getHopAnimationDuration() {
        return 18;
    }

    protected float getHopVerticalPower() {
        return 0.53f;
    }

    protected float getHopForwardPower() {
        return 0.5f;
    }

    protected float getHopBackwardPower() {
        return 0.4f;
    }

    @Override
    protected double getStopDistanceSq() {
        return 16.0;
    }

    @Override
    protected double getTooCloseDistanceSq() {
        return 4.840000000000001;
    }

    @Override
    protected double getMinActionDistance() {
        return 2.0;
    }

    @Override
    protected double getMaxActionDistance() {
        return 4.0;
    }

    private void resetHopState() {
        boolean wasPerformingBackoffHop = this.currentHopIsBackoff;
        this.jumpAnimationTimer = 0;
        this.prepPhaseTimer = 0;
        this.hopPhysicsAppliedThisCycle = false;
        this.currentHopDirection = null;
        this.currentHopIsBackoff = false;
        if (this.getSlimeState().isJumpingAttack()) {
            this.getSlimeState().setJumpingAttack(false);
        }
        if (wasPerformingBackoffHop) {
            this.cooldown = 5;
        }
    }

    public void start() {
        super.start();
        this.hopTimer = 0;
        this.resetHopState();
        if (!this.getSlimeMob().getNavigation().isDone()) {
            this.getSlimeMob().getNavigation().stop();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.resetHopState();
        if (!this.getSlimeMob().getNavigation().isDone()) {
            this.getSlimeMob().getNavigation().stop();
        }
    }

    @Override
    protected void resetEntityAnimationStates() {
        this.resetHopState();
    }

    @Override
    protected void moveNormally(double speedMultiplier) {
        if (this.target == null || !this.target.isAlive()) {
            if (this.getSlimeState().isJumpingAttack()) {
                this.resetHopState();
            }
            return;
        }
        ISlimeAttackState slimeState = this.getSlimeState();
        if (!slimeState.isJumpingAttack()) {
            this.entity.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ(), 30.0f, 30.0f);
        }
        if (slimeState.isJumpingAttack()) {
            this.manageActiveHop();
        } else {
            ++this.hopTimer;
            if (this.hopTimer >= this.getTicksBetweenHops()) {
                this.hopTimer = 0;
                double distanceSqToTarget = this.entity.distanceToSqr((Entity)this.target);
                Vec3 calculatedHopDir = null;
                if (distanceSqToTarget < this.getTooCloseDistanceSq()) {
                    calculatedHopDir = this.target.position().vectorTo(this.entity.position()).normalize();
                    this.currentHopIsBackoff = true;
                } else if (distanceSqToTarget > this.getStopDistanceSq()) {
                    calculatedHopDir = this.entity.position().vectorTo(this.target.position()).normalize();
                    this.currentHopIsBackoff = false;
                } else {
                    if (!this.getSlimeMob().getNavigation().isDone()) {
                        this.getSlimeMob().getNavigation().stop();
                    }
                    this.currentHopIsBackoff = false;
                }
                if (calculatedHopDir != null) {
                    if (calculatedHopDir.lengthSqr() < 1.0E-4 && (calculatedHopDir = new Vec3((this.entity.getRandom().nextDouble() - 0.5) * 0.1, 0.0, (this.entity.getRandom().nextDouble() - 0.5) * 0.1).normalize()).lengthSqr() < 1.0E-4) {
                        calculatedHopDir = null;
                    }
                    if (calculatedHopDir != null) {
                        this.currentHopDirection = calculatedHopDir;
                        this.initiateHopVisualsAndTiming();
                    }
                }
            } else if (!slimeState.isJumpingAttack() && !this.getSlimeMob().getNavigation().isDone()) {
                this.getSlimeMob().getNavigation().stop();
            }
        }
    }

    private void initiateHopVisualsAndTiming() {
        this.getSlimeState().setJumpingAttack(true);
        this.jumpAnimationTimer = this.getHopAnimationDuration();
        this.prepPhaseTimer = 3;
        this.hopPhysicsAppliedThisCycle = false;
        System.out.println("[SlimeAttackGoal for " + this.entity.getId() + "] Called initiateHopVisualsAndTiming. Setting isJumpingAttack to true.");
        this.getSlimeState().setJumpingAttack(true);
        this.jumpAnimationTimer = this.getHopAnimationDuration();
    }

    private void manageActiveHop() {
        if (!this.getSlimeMob().getNavigation().isDone()) {
            this.getSlimeMob().getNavigation().stop();
        }
        if (this.target != null && this.target.isAlive()) {
            this.entity.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ(), 30.0f, 30.0f);
        }
        if (this.prepPhaseTimer > 0) {
            --this.prepPhaseTimer;
        } else if (!this.hopPhysicsAppliedThisCycle && this.currentHopDirection != null) {
            float vPower = this.getHopVerticalPower();
            float hPower = this.currentHopIsBackoff ? this.getHopBackwardPower() : this.getHopForwardPower();
            this.entity.setDeltaMovement(this.currentHopDirection.x * (double)hPower, vPower, this.currentHopDirection.z * (double)hPower);
            this.entity.triggerHurtMarkedForSync();
            this.hopPhysicsAppliedThisCycle = true;
        }
        if (this.jumpAnimationTimer > 0) {
            --this.jumpAnimationTimer;
            if (this.jumpAnimationTimer <= 0) {
                this.resetHopState();
            }
        } else if (this.getSlimeState().isJumpingAttack()) {
            this.resetHopState();
        }
    }
}

