/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.spawn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.HoyoEntity;
import net.zenith.hoyocraft.entity.spawn.GroupSpawnConfig;

public class GenshinEntityGroupSpawner {
    private static final Map<EntityType<? extends GenshinEntity>, GroupSpawnConfig> GROUP_CONFIGS = new HashMap<EntityType<? extends GenshinEntity>, GroupSpawnConfig>();

    public static void registerGroupSpawnConfig(EntityType<? extends GenshinEntity> leaderType, GroupSpawnConfig config) {
        System.out.println("GenshinEntityGroupSpawner: ATTEMPTING to register config for " + leaderType.getDescriptionId());
        System.out.println("GenshinEntityGroupSpawner: Config details: " + String.valueOf(config));
        System.out.println("GenshinEntityGroupSpawner: Config has follower types: " + config.hasFollowerTypes());
        if (config.hasFollowerTypes()) {
            GROUP_CONFIGS.put(leaderType, config);
            System.out.println("GenshinEntityGroupSpawner: \u2705 SUCCESSFULLY registered group config for " + leaderType.getDescriptionId() + " -> " + String.valueOf(config));
            System.out.println("GenshinEntityGroupSpawner: Total registered configs: " + GROUP_CONFIGS.size());
        } else {
            System.out.println("GenshinEntityGroupSpawner: \u274c WARNING - Config for " + leaderType.getDescriptionId() + " has no valid follower types!");
        }
    }

    public static void spawnFollowerGroup(GenshinEntity leader, ServerLevel level, MobSpawnType spawnType) {
        System.out.println("GenshinEntityGroupSpawner.spawnFollowerGroup: CALLED for " + leader.getType().getDescriptionId() + " with spawnType=" + String.valueOf(spawnType));
        if (spawnType != MobSpawnType.NATURAL && spawnType != MobSpawnType.CHUNK_GENERATION) {
            System.out.println("GenshinEntityGroupSpawner: Skipping follower spawn (not natural spawning, spawnType=" + String.valueOf(spawnType) + ")");
            return;
        }
        System.out.println("GenshinEntityGroupSpawner: Looking for config for entity type: " + leader.getType().getDescriptionId());
        System.out.println("GenshinEntityGroupSpawner: Available configs: " + String.valueOf(GROUP_CONFIGS.keySet().stream().map(EntityType::getDescriptionId).toList()));
        GroupSpawnConfig config = GROUP_CONFIGS.get(leader.getType());
        if (config == null) {
            System.out.println("GenshinEntityGroupSpawner: No group config found for " + leader.getType().getDescriptionId());
            return;
        }
        System.out.println("GenshinEntityGroupSpawner: Found config for " + leader.getType().getDescriptionId() + " -> " + String.valueOf(config));
        RandomSource random = level.getRandom();
        BlockPos leaderPos = leader.blockPosition();
        int followerCount = config.getMinFollowers() + random.nextInt(config.getMaxFollowers() - config.getMinFollowers() + 1);
        System.out.println("GenshinEntityGroupSpawner: Spawning " + followerCount + " followers around leader at " + String.valueOf(leaderPos));
        ArrayList<GenshinEntity> spawnedFollowers = new ArrayList<GenshinEntity>();
        for (int i = 0; i < followerCount; ++i) {
            EntityType<? extends GenshinEntity> selectedType = GenshinEntityGroupSpawner.selectRandomFollowerType(config, random);
            if (selectedType == null) {
                System.out.println("GenshinEntityGroupSpawner: Failed to select follower type for spawn " + i);
                continue;
            }
            GenshinEntity follower = GenshinEntityGroupSpawner.createFollowerEntity(selectedType, level);
            if (follower == null) {
                System.out.println("GenshinEntityGroupSpawner: Failed to create follower of type " + selectedType.getDescriptionId());
                continue;
            }
            BlockPos spawnPos = GenshinEntityGroupSpawner.findValidSpawnPosition(level, leaderPos, config, random);
            if (spawnPos == null) {
                System.out.println("GenshinEntityGroupSpawner: Could not find valid spawn position for follower " + i);
                continue;
            }
            follower.setPos((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
            follower.setLeader(false);
            if (level.addFreshEntity((Entity)follower)) {
                spawnedFollowers.add(follower);
                System.out.println("GenshinEntityGroupSpawner: Successfully spawned " + selectedType.getDescriptionId() + " follower at " + String.valueOf(spawnPos));
                continue;
            }
            System.out.println("GenshinEntityGroupSpawner: Failed to add follower to world");
        }
        System.out.println("GenshinEntityGroupSpawner: Successfully spawned " + spawnedFollowers.size() + " out of " + followerCount + " intended followers for " + leader.getType().getDescriptionId());
    }

    private static EntityType<? extends GenshinEntity> selectRandomFollowerType(GroupSpawnConfig config, RandomSource random) {
        List<GroupSpawnConfig.FollowerSpawnEntry> followerTypes = config.getFollowerTypes();
        int totalWeight = config.getTotalWeight();
        if (totalWeight <= 0) {
            return null;
        }
        int randomValue = random.nextInt(totalWeight);
        int currentWeight = 0;
        for (GroupSpawnConfig.FollowerSpawnEntry entry : followerTypes) {
            if (randomValue >= (currentWeight += entry.getWeight())) continue;
            return entry.getEntityType();
        }
        return followerTypes.get(0).getEntityType();
    }

    private static GenshinEntity createFollowerEntity(EntityType<? extends GenshinEntity> entityType, ServerLevel level) {
        try {
            return (GenshinEntity)entityType.create((Level)level);
        }
        catch (Exception e) {
            System.out.println("GenshinEntityGroupSpawner: Error creating follower entity: " + e.getMessage());
            return null;
        }
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, BlockPos leaderPos, GroupSpawnConfig config, RandomSource random) {
        for (int attempt = 0; attempt < config.getMaxSpawnAttempts(); ++attempt) {
            int offsetX = random.nextInt(config.getSpawnRadius() * 2 + 1) - config.getSpawnRadius();
            int offsetZ = random.nextInt(config.getSpawnRadius() * 2 + 1) - config.getSpawnRadius();
            BlockPos testPos = leaderPos.offset(offsetX, 0, offsetZ);
            int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, testPos.getX(), testPos.getZ());
            if (!GenshinEntityGroupSpawner.isValidSpawnPosition(level, testPos = new BlockPos(testPos.getX(), surfaceY, testPos.getZ()), config)) continue;
            return testPos;
        }
        return null;
    }

    private static boolean isValidSpawnPosition(ServerLevel level, BlockPos pos, GroupSpawnConfig config) {
        if (config.isRequireSolidGround() && !HoyoEntity.hasSolidGround((ServerLevelAccessor)level, pos)) {
            return false;
        }
        if (config.isAvoidLeaves() && HoyoEntity.isOnLeaves((ServerLevelAccessor)level, pos)) {
            return false;
        }
        BlockState spawnBlock = level.getBlockState(pos);
        if (!spawnBlock.isAir() && !spawnBlock.canBeReplaced()) {
            return false;
        }
        BlockState blockAbove = level.getBlockState(pos.above());
        if (!blockAbove.isAir() && !blockAbove.canBeReplaced()) {
            return false;
        }
        return HoyoEntity.getLightLevel((ServerLevelAccessor)level, pos) >= config.getMinimumLightLevel();
    }

    public static Map<EntityType<? extends GenshinEntity>, GroupSpawnConfig> getRegisteredConfigs() {
        return new HashMap<EntityType<? extends GenshinEntity>, GroupSpawnConfig>(GROUP_CONFIGS);
    }

    public static boolean hasGroupConfig(EntityType<? extends GenshinEntity> entityType) {
        return GROUP_CONFIGS.containsKey(entityType);
    }
}

