/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.spawn;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.zenith.hoyocraft.entity.core.GenshinEntity;
import net.zenith.hoyocraft.entity.core.HoyoEntity;
import net.zenith.hoyocraft.entity.spawn.SpawnRuleConfig;

public class GenshinEntitySpawnRules {
    private static final Map<EntityType<? extends GenshinEntity>, SpawnRuleConfig> SPAWN_RULES = new HashMap<EntityType<? extends GenshinEntity>, SpawnRuleConfig>();

    public static void registerSpawnRules(EntityType<? extends GenshinEntity> entityType, SpawnRuleConfig config) {
        SPAWN_RULES.put(entityType, config);
        System.out.println("GenshinEntitySpawnRules: Registered spawn rules for " + entityType.getDescriptionId() + " -> " + String.valueOf(config));
    }

    public static boolean checkEntitySpawnRules(EntityType<? extends GenshinEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.DISPENSER) {
            return true;
        }
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        SpawnRuleConfig config = SPAWN_RULES.get(entityType);
        if (config == null) {
            System.out.println("GenshinEntitySpawnRules: No spawn rules found for " + entityType.getDescriptionId() + ", using default HoyoEntity rules");
            return HoyoEntity.checkHoyoEntitySpawnRules(entityType, level, spawnType, pos, random);
        }
        boolean result = GenshinEntitySpawnRules.checkAllSpawnConditions(config, level, pos, random);
        if (!result) {
            System.out.println("GenshinEntitySpawnRules: Spawn FAILED for " + entityType.getDescriptionId() + " at " + String.valueOf(pos) + " (config: " + String.valueOf(config) + ")");
        }
        return result;
    }

    private static boolean checkAllSpawnConditions(SpawnRuleConfig config, ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (!GenshinEntitySpawnRules.checkBasicSafety(level, pos)) {
            System.out.println("GenshinEntitySpawnRules: FAILED basic safety at " + String.valueOf(pos));
            return false;
        }
        if (!GenshinEntitySpawnRules.checkTimeRequirement(config, level)) {
            System.out.println("GenshinEntitySpawnRules: FAILED time requirement at " + String.valueOf(pos));
            return false;
        }
        if (!GenshinEntitySpawnRules.checkHeightRequirement(config, pos)) {
            System.out.println("GenshinEntitySpawnRules: FAILED height requirement at " + String.valueOf(pos) + " (Y=" + pos.getY() + ")");
            return false;
        }
        if (!GenshinEntitySpawnRules.checkLightRequirement(config, level, pos)) {
            System.out.println("GenshinEntitySpawnRules: FAILED light requirement at " + String.valueOf(pos) + " (light=" + HoyoEntity.getLightLevel(level, pos) + ")");
            return false;
        }
        if (!GenshinEntitySpawnRules.checkBlockRequirement(config, level, pos)) {
            System.out.println("GenshinEntitySpawnRules: FAILED block requirement at " + String.valueOf(pos) + " (block=" + String.valueOf(level.getBlockState(pos.below()).getBlock()) + ")");
            return false;
        }
        if (!GenshinEntitySpawnRules.checkGroundRequirement(config, level, pos)) {
            System.out.println("GenshinEntitySpawnRules: FAILED ground requirement at " + String.valueOf(pos));
            return false;
        }
        if (!GenshinEntitySpawnRules.checkAdvancedRequirements(config, level, pos)) {
            System.out.println("GenshinEntitySpawnRules: FAILED advanced requirement at " + String.valueOf(pos));
            return false;
        }
        return true;
    }

    private static boolean checkBasicSafety(ServerLevelAccessor level, BlockPos pos) {
        BlockState spawnBlock = level.getBlockState(pos);
        Block spawnBlockType = spawnBlock.getBlock();
        if (spawnBlockType == Blocks.WATER || spawnBlockType == Blocks.LAVA) {
            BlockState blockAbove = level.getBlockState(pos.above());
            return blockAbove.isAir() || blockAbove.canBeReplaced() || blockAbove.getBlock() == Blocks.WATER || blockAbove.getBlock() == Blocks.LAVA;
        }
        if (!spawnBlock.isAir() && !spawnBlock.canBeReplaced()) {
            return false;
        }
        BlockState blockAbove = level.getBlockState(pos.above());
        return blockAbove.isAir() || blockAbove.canBeReplaced();
    }

    private static boolean checkTimeRequirement(SpawnRuleConfig config, ServerLevelAccessor level) {
        if (config.getTimeRequirement() == SpawnRuleConfig.TimeRequirement.ANY_TIME) {
            return true;
        }
        ServerLevel worldLevel = level.getLevel();
        boolean isDaytime = HoyoEntity.isDaytime((Level)worldLevel);
        return switch (config.getTimeRequirement()) {
            default -> throw new MatchException(null, null);
            case SpawnRuleConfig.TimeRequirement.DAYTIME_ONLY -> isDaytime;
            case SpawnRuleConfig.TimeRequirement.NIGHTTIME_ONLY -> {
                if (!isDaytime) {
                    yield true;
                }
                yield false;
            }
            case SpawnRuleConfig.TimeRequirement.ANY_TIME -> true;
        };
    }

    private static boolean checkHeightRequirement(SpawnRuleConfig config, BlockPos pos) {
        int y = pos.getY();
        return switch (config.getHeightRequirement()) {
            default -> throw new MatchException(null, null);
            case SpawnRuleConfig.HeightRequirement.SURFACE_ONLY -> {
                if (y >= 60) {
                    yield true;
                }
                yield false;
            }
            case SpawnRuleConfig.HeightRequirement.UNDERGROUND -> {
                if (y < 60) {
                    yield true;
                }
                yield false;
            }
            case SpawnRuleConfig.HeightRequirement.CUSTOM_RANGE -> {
                if (y >= config.getMinYLevel() && y <= config.getMaxYLevel()) {
                    yield true;
                }
                yield false;
            }
            case SpawnRuleConfig.HeightRequirement.ANY_HEIGHT -> true;
            case SpawnRuleConfig.HeightRequirement.NO_HEIGHT_RESTRICTION -> true;
        };
    }

    private static boolean checkLightRequirement(SpawnRuleConfig config, ServerLevelAccessor level, BlockPos pos) {
        int lightLevel = HoyoEntity.getLightLevel(level, pos);
        return lightLevel >= config.getMinLightLevel() && lightLevel <= config.getMaxLightLevel();
    }

    private static boolean checkBlockRequirement(SpawnRuleConfig config, ServerLevelAccessor level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        Block block = blockBelow.getBlock();
        if (config.getForbiddenBlocks().contains(block)) {
            return false;
        }
        return switch (config.getBlockRequirement()) {
            default -> throw new MatchException(null, null);
            case SpawnRuleConfig.BlockRequirement.ANY_BLOCK -> true;
            case SpawnRuleConfig.BlockRequirement.SPECIFIC_BLOCKS -> config.getRequiredBlocks().contains(block);
            case SpawnRuleConfig.BlockRequirement.WATER_ONLY -> {
                if (block == Blocks.WATER) {
                    yield true;
                }
                yield false;
            }
            case SpawnRuleConfig.BlockRequirement.LAVA_ONLY -> {
                if (block == Blocks.LAVA) {
                    yield true;
                }
                yield false;
            }
            case SpawnRuleConfig.BlockRequirement.SOLID_ONLY -> blockBelow.isSolid();
        };
    }

    private static boolean checkGroundRequirement(SpawnRuleConfig config, ServerLevelAccessor level, BlockPos pos) {
        if (config.isRequireSolidGround() && !HoyoEntity.hasSolidGround(level, pos)) {
            return false;
        }
        if (config.isAvoidLeaves() && HoyoEntity.isOnLeaves(level, pos)) {
            return false;
        }
        BlockState spawnBlock = level.getBlockState(pos);
        if (spawnBlock.getBlock() == Blocks.WATER && !config.isAllowWaterSpawning()) {
            return false;
        }
        return spawnBlock.getBlock() != Blocks.LAVA || config.isAllowLavaSpawning();
    }

    private static boolean checkAdvancedRequirements(SpawnRuleConfig config, ServerLevelAccessor level, BlockPos pos) {
        if (config.isRequireSkyAccess()) {
            for (int y = pos.getY() + 1; y < level.getMaxBuildHeight(); ++y) {
                BlockState blockState = level.getBlockState(new BlockPos(pos.getX(), y, pos.getZ()));
                if (blockState.isAir()) continue;
                return false;
            }
        }
        return true;
    }

    public static Map<EntityType<? extends GenshinEntity>, SpawnRuleConfig> getRegisteredRules() {
        return new HashMap<EntityType<? extends GenshinEntity>, SpawnRuleConfig>(SPAWN_RULES);
    }

    public static boolean hasSpawnRules(EntityType<? extends GenshinEntity> entityType) {
        return SPAWN_RULES.containsKey(entityType);
    }
}

