/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.spawn;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.zenith.hoyocraft.entity.core.GenshinEntity;

public class GroupSpawnConfig {
    private int minFollowers = 1;
    private int maxFollowers = 3;
    private final List<FollowerSpawnEntry> followerTypes = new ArrayList<FollowerSpawnEntry>();
    private int spawnRadius = 8;
    private int maxSpawnAttempts = 20;
    private boolean requireSolidGround = true;
    private boolean avoidLeaves = true;
    private int minimumLightLevel = 4;

    public GroupSpawnConfig setMinFollowers(int min) {
        this.minFollowers = Math.max(0, min);
        return this;
    }

    public GroupSpawnConfig setMaxFollowers(int max) {
        this.maxFollowers = Math.max(1, max);
        return this;
    }

    public GroupSpawnConfig addFollowerType(EntityType<? extends GenshinEntity> entityType, int weight) {
        if (weight > 0) {
            this.followerTypes.add(new FollowerSpawnEntry(entityType, weight));
        }
        return this;
    }

    public GroupSpawnConfig setSpawnRadius(int radius) {
        this.spawnRadius = Math.max(1, radius);
        return this;
    }

    public GroupSpawnConfig setMaxSpawnAttempts(int attempts) {
        this.maxSpawnAttempts = Math.max(1, attempts);
        return this;
    }

    public GroupSpawnConfig setRequireSolidGround(boolean require) {
        this.requireSolidGround = require;
        return this;
    }

    public GroupSpawnConfig setAvoidLeaves(boolean avoid) {
        this.avoidLeaves = avoid;
        return this;
    }

    public GroupSpawnConfig setMinimumLightLevel(int lightLevel) {
        this.minimumLightLevel = Math.max(0, Math.min(15, lightLevel));
        return this;
    }

    public int getMinFollowers() {
        return this.minFollowers;
    }

    public int getMaxFollowers() {
        return this.maxFollowers;
    }

    public List<FollowerSpawnEntry> getFollowerTypes() {
        return this.followerTypes;
    }

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public int getMaxSpawnAttempts() {
        return this.maxSpawnAttempts;
    }

    public boolean isRequireSolidGround() {
        return this.requireSolidGround;
    }

    public boolean isAvoidLeaves() {
        return this.avoidLeaves;
    }

    public int getMinimumLightLevel() {
        return this.minimumLightLevel;
    }

    public int getTotalWeight() {
        return this.followerTypes.stream().mapToInt(FollowerSpawnEntry::getWeight).sum();
    }

    public boolean hasFollowerTypes() {
        return !this.followerTypes.isEmpty() && this.getTotalWeight() > 0;
    }

    public String toString() {
        return "GroupSpawnConfig{followers=" + this.minFollowers + "-" + this.maxFollowers + ", types=" + this.followerTypes.size() + ", radius=" + this.spawnRadius + "}";
    }

    public static class FollowerSpawnEntry {
        private final EntityType<? extends GenshinEntity> entityType;
        private final int weight;

        public FollowerSpawnEntry(EntityType<? extends GenshinEntity> entityType, int weight) {
            this.entityType = entityType;
            this.weight = weight;
        }

        public EntityType<? extends GenshinEntity> getEntityType() {
            return this.entityType;
        }

        public int getWeight() {
            return this.weight;
        }

        public String toString() {
            return this.entityType.getDescriptionId() + " (weight: " + this.weight + ")";
        }
    }
}

