/*
 * Decompiled with CFR 0.152.
 */
package net.zenith.hoyocraft.entity.spawn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.block.Block;

public class SpawnRuleConfig {
    private TimeRequirement timeRequirement = TimeRequirement.ANY_TIME;
    private HeightRequirement heightRequirement = HeightRequirement.ANY_HEIGHT;
    private int minYLevel = -64;
    private int maxYLevel = 320;
    private int minLightLevel = 0;
    private int maxLightLevel = 15;
    private BlockRequirement blockRequirement = BlockRequirement.ANY_BLOCK;
    private final List<Block> requiredBlocks = new ArrayList<Block>();
    private final List<Block> forbiddenBlocks = new ArrayList<Block>();
    private boolean requireSolidGround = true;
    private boolean avoidLeaves = true;
    private boolean allowWaterSpawning = false;
    private boolean allowLavaSpawning = false;
    private boolean requireSkyAccess = false;
    private int minDistanceFromPlayer = 0;
    private int maxDistanceFromPlayer = 128;

    public SpawnRuleConfig setTimeRequirement(TimeRequirement requirement) {
        this.timeRequirement = requirement;
        return this;
    }

    public SpawnRuleConfig setHeightRequirement(HeightRequirement requirement) {
        this.heightRequirement = requirement;
        return this;
    }

    public SpawnRuleConfig setNoHeightRestriction() {
        this.heightRequirement = HeightRequirement.NO_HEIGHT_RESTRICTION;
        return this;
    }

    public SpawnRuleConfig setYLevel(int min, int max) {
        this.minYLevel = Math.min(min, max);
        this.maxYLevel = Math.max(min, max);
        this.heightRequirement = HeightRequirement.CUSTOM_RANGE;
        return this;
    }

    public SpawnRuleConfig setLightLevel(int min, int max) {
        this.minLightLevel = Math.max(0, Math.min(15, min));
        this.maxLightLevel = Math.max(0, Math.min(15, max));
        return this;
    }

    public SpawnRuleConfig setMinLightLevel(int min) {
        return this.setLightLevel(min, 15);
    }

    public SpawnRuleConfig setMaxLightLevel(int max) {
        return this.setLightLevel(0, max);
    }

    public SpawnRuleConfig setRequiredBlocks(Block ... blocks) {
        this.requiredBlocks.clear();
        this.requiredBlocks.addAll(Arrays.asList(blocks));
        this.blockRequirement = BlockRequirement.SPECIFIC_BLOCKS;
        return this;
    }

    public SpawnRuleConfig setForbiddenBlocks(Block ... blocks) {
        this.forbiddenBlocks.clear();
        this.forbiddenBlocks.addAll(Arrays.asList(blocks));
        return this;
    }

    public SpawnRuleConfig setRequireSolidGround(boolean require) {
        this.requireSolidGround = require;
        return this;
    }

    public SpawnRuleConfig setAvoidLeaves(boolean avoid) {
        this.avoidLeaves = avoid;
        return this;
    }

    public SpawnRuleConfig setAllowWaterSpawning(boolean allow) {
        this.allowWaterSpawning = allow;
        if (allow) {
            this.requireSolidGround = false;
        }
        return this;
    }

    public SpawnRuleConfig setAllowLavaSpawning(boolean allow) {
        this.allowLavaSpawning = allow;
        if (allow) {
            this.requireSolidGround = false;
        }
        return this;
    }

    public SpawnRuleConfig setRequireSkyAccess(boolean require) {
        this.requireSkyAccess = require;
        return this;
    }

    public SpawnRuleConfig setPlayerDistance(int min, int max) {
        this.minDistanceFromPlayer = Math.max(0, min);
        this.maxDistanceFromPlayer = Math.max(min, max);
        return this;
    }

    public TimeRequirement getTimeRequirement() {
        return this.timeRequirement;
    }

    public HeightRequirement getHeightRequirement() {
        return this.heightRequirement;
    }

    public int getMinYLevel() {
        return this.minYLevel;
    }

    public int getMaxYLevel() {
        return this.maxYLevel;
    }

    public int getMinLightLevel() {
        return this.minLightLevel;
    }

    public int getMaxLightLevel() {
        return this.maxLightLevel;
    }

    public BlockRequirement getBlockRequirement() {
        return this.blockRequirement;
    }

    public List<Block> getRequiredBlocks() {
        return this.requiredBlocks;
    }

    public List<Block> getForbiddenBlocks() {
        return this.forbiddenBlocks;
    }

    public boolean isRequireSolidGround() {
        return this.requireSolidGround;
    }

    public boolean isAvoidLeaves() {
        return this.avoidLeaves;
    }

    public boolean isAllowWaterSpawning() {
        return this.allowWaterSpawning;
    }

    public boolean isAllowLavaSpawning() {
        return this.allowLavaSpawning;
    }

    public boolean isRequireSkyAccess() {
        return this.requireSkyAccess;
    }

    public int getMinDistanceFromPlayer() {
        return this.minDistanceFromPlayer;
    }

    public int getMaxDistanceFromPlayer() {
        return this.maxDistanceFromPlayer;
    }

    public String toString() {
        return "SpawnRuleConfig{time=" + String.valueOf((Object)this.timeRequirement) + ", height=" + String.valueOf((Object)this.heightRequirement) + ", light=" + this.minLightLevel + "-" + this.maxLightLevel + ", blocks=" + String.valueOf((Object)this.blockRequirement) + ", solidGround=" + this.requireSolidGround + "}";
    }

    public static enum TimeRequirement {
        DAYTIME_ONLY,
        NIGHTTIME_ONLY,
        ANY_TIME;

    }

    public static enum HeightRequirement {
        SURFACE_ONLY,
        UNDERGROUND,
        CUSTOM_RANGE,
        ANY_HEIGHT,
        NO_HEIGHT_RESTRICTION;

    }

    public static enum BlockRequirement {
        ANY_BLOCK,
        SPECIFIC_BLOCKS,
        WATER_ONLY,
        LAVA_ONLY,
        SOLID_ONLY;

    }
}

